/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.deftu.omnicore.client.OmniClient;
import dev.deftu.omnicore.client.render.OmniMatrixStack;
import dev.deftu.omnicore.client.render.OmniRenderState;
import java.awt.Color;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Deprecated(message="Replace with OmniBufferBuilder.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 @2\u00020\u0001:\u0003@ABB\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000e\u00a2\u0006\u0004\b\f\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ-\u0010#\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f\u00a2\u0006\u0004\b#\u0010$J-\u0010%\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f\u00a2\u0006\u0004\b%\u0010$J-\u0010*\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001f\u00a2\u0006\u0004\b*\u0010+J-\u0010*\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004\u00a2\u0006\u0004\b*\u0010,J\u0015\u0010*\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0004\u00a2\u0006\u0004\b*\u0010-J\u0015\u0010*\u001a\u00020\u00002\u0006\u0010*\u001a\u00020.\u00a2\u0006\u0004\b*\u0010/J\u001d\u00102\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001f\u00a2\u0006\u0004\b2\u00103J\u001d\u00104\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004\u00a2\u0006\u0004\b4\u00105J\u001d\u00106\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004\u00a2\u0006\u0004\b6\u00105J\r\u00107\u001a\u00020\u0000\u00a2\u0006\u0004\b7\u00108J\u000f\u00109\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b9\u0010\u0017R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010:R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010;R\u0018\u0010<\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0018\u0010>\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?\u00a8\u0006C"}, d2={"Ldev/deftu/omnicore/client/render/OmniTessellator;", "", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "buffer", "", "size", "<init>", "(Lcom/mojang/blaze3d/vertex/BufferBuilder;I)V", "Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;", "mode", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "format", "beginWithActiveShader", "(Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;Lcom/mojang/blaze3d/vertex/VertexFormat;)Ldev/deftu/omnicore/client/render/OmniTessellator;", "Ldev/deftu/omnicore/client/render/OmniTessellator$VertexFormats;", "(Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;Ldev/deftu/omnicore/client/render/OmniTessellator$VertexFormats;)Ldev/deftu/omnicore/client/render/OmniTessellator;", "beginWithDefaultShader", "Lnet/minecraft/client/renderer/RenderType;", "layer", "beginRenderLayer", "(Lnet/minecraft/client/renderer/RenderType;)Ldev/deftu/omnicore/client/render/OmniTessellator;", "", "draw", "()V", "Lcom/mojang/blaze3d/vertex/MeshData;", "builtBuffer", "handleDraw", "(Lcom/mojang/blaze3d/vertex/MeshData;)V", "drawBuffer", "Ldev/deftu/omnicore/client/render/OmniMatrixStack;", "stack", "", "x", "y", "z", "vertex", "(Ldev/deftu/omnicore/client/render/OmniMatrixStack;FFF)Ldev/deftu/omnicore/client/render/OmniTessellator;", "normal", "red", "green", "blue", "alpha", "color", "(FFFF)Ldev/deftu/omnicore/client/render/OmniTessellator;", "(IIII)Ldev/deftu/omnicore/client/render/OmniTessellator;", "(I)Ldev/deftu/omnicore/client/render/OmniTessellator;", "Ljava/awt/Color;", "(Ljava/awt/Color;)Ldev/deftu/omnicore/client/render/OmniTessellator;", "u", "v", "texture", "(FF)Ldev/deftu/omnicore/client/render/OmniTessellator;", "overlay", "(II)Ldev/deftu/omnicore/client/render/OmniTessellator;", "light", "next", "()Ldev/deftu/omnicore/client/render/OmniTessellator;", "checkBuffer", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "I", "currentVertexFormat", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "renderLayer", "Lnet/minecraft/client/renderer/RenderType;", "Companion", "VertexFormats", "DrawModes", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nOmniTessellator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniTessellator.kt\ndev/deftu/omnicore/client/render/OmniTessellator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,578:1\n1#2:579\n*E\n"})
public final class OmniTessellator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BufferBuilder buffer;
    private int size;
    @Nullable
    private VertexFormat currentVertexFormat;
    @Nullable
    private RenderType renderLayer;
    @NotNull
    private static final Lazy<IdentityHashMap<VertexFormat, Supplier<ShaderInstance>>> defaultShaders$delegate = LazyKt.lazy(OmniTessellator::defaultShaders_delegate$lambda$22);

    public OmniTessellator(@Nullable BufferBuilder buffer, int size) {
        this.buffer = buffer;
        this.size = size;
    }

    public /* synthetic */ OmniTessellator(BufferBuilder bufferBuilder, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(bufferBuilder, n);
    }

    @NotNull
    public final OmniTessellator beginWithActiveShader(@NotNull DrawModes mode, @NotNull VertexFormat format) {
        OmniTessellator omniTessellator;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        OmniTessellator $this$beginWithActiveShader_u24lambda_u240 = omniTessellator = this;
        boolean bl = false;
        $this$beginWithActiveShader_u24lambda_u240.currentVertexFormat = format;
        $this$beginWithActiveShader_u24lambda_u240.buffer = $this$beginWithActiveShader_u24lambda_u240.size == 0 ? Companion.getTessellator().begin(mode.getVanilla(), format) : new BufferBuilder(new ByteBufferBuilder($this$beginWithActiveShader_u24lambda_u240.size), mode.getVanilla(), format);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator beginWithActiveShader(@NotNull DrawModes mode, @NotNull VertexFormats format) {
        OmniTessellator omniTessellator;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        OmniTessellator $this$beginWithActiveShader_u24lambda_u241 = omniTessellator = this;
        boolean bl = false;
        $this$beginWithActiveShader_u24lambda_u241.beginWithActiveShader(mode, format.getVanilla());
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator beginWithDefaultShader(@NotNull DrawModes mode, @NotNull VertexFormat format) {
        OmniTessellator omniTessellator;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        OmniTessellator $this$beginWithDefaultShader_u24lambda_u242 = omniTessellator = this;
        boolean bl = false;
        Supplier<ShaderInstance> supplier = Companion.getDefaultShaders().get(format);
        if (supplier == null) {
            throw new IllegalStateException(("Unsupported vertex format '" + format + "' - no default shader").toString());
        }
        Supplier<ShaderInstance> supplier2 = supplier;
        OmniRenderState.setShader(supplier2);
        $this$beginWithDefaultShader_u24lambda_u242.beginWithActiveShader(mode, format);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator beginWithDefaultShader(@NotNull DrawModes mode, @NotNull VertexFormats format) {
        OmniTessellator omniTessellator;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        OmniTessellator $this$beginWithDefaultShader_u24lambda_u243 = omniTessellator = this;
        boolean bl = false;
        $this$beginWithDefaultShader_u24lambda_u243.beginWithDefaultShader(mode, format.getVanilla());
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator beginRenderLayer(@NotNull RenderType layer) {
        OmniTessellator omniTessellator;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        OmniTessellator $this$beginRenderLayer_u24lambda_u244 = omniTessellator = this;
        boolean bl = false;
        $this$beginRenderLayer_u24lambda_u244.renderLayer = layer;
        DrawModes drawModes = DrawModes.Companion.fromRenderLayer(layer);
        VertexFormat vertexFormat = layer.format();
        Intrinsics.checkNotNullExpressionValue((Object)vertexFormat, (String)"format(...)");
        $this$beginRenderLayer_u24lambda_u244.beginWithActiveShader(drawModes, vertexFormat);
        return omniTessellator;
    }

    public final void draw() {
        this.checkBuffer();
        BufferBuilder bufferBuilder = this.buffer;
        Intrinsics.checkNotNull((Object)bufferBuilder);
        MeshData builtBuffer = bufferBuilder.buildOrThrow();
        if (this.renderLayer != null) {
            RenderType renderType = this.renderLayer;
            Intrinsics.checkNotNull((Object)renderType);
            renderType.draw(builtBuffer);
            return;
        }
        Intrinsics.checkNotNull((Object)builtBuffer);
        this.handleDraw(builtBuffer);
    }

    private final void handleDraw(MeshData builtBuffer) {
        this.checkBuffer();
        if (this.currentVertexFormat == null) {
            this.drawBuffer(builtBuffer);
            return;
        }
        this.drawBuffer(builtBuffer);
    }

    private final void drawBuffer(MeshData builtBuffer) {
        this.checkBuffer();
        BufferUploader.drawWithShader((MeshData)builtBuffer);
    }

    @NotNull
    public final OmniTessellator vertex(@NotNull OmniMatrixStack stack, float x, float y, float z) {
        OmniTessellator omniTessellator;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        OmniTessellator $this$vertex_u24lambda_u245 = omniTessellator = this;
        boolean bl = false;
        $this$vertex_u24lambda_u245.checkBuffer();
        BufferBuilder bufferBuilder = $this$vertex_u24lambda_u245.buffer;
        Intrinsics.checkNotNull((Object)bufferBuilder);
        bufferBuilder.addVertex(stack.peek().getMatrix(), x, y, z);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator normal(@NotNull OmniMatrixStack stack, float x, float y, float z) {
        OmniTessellator omniTessellator;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        OmniTessellator $this$normal_u24lambda_u246 = omniTessellator = this;
        boolean bl = false;
        $this$normal_u24lambda_u246.checkBuffer();
        Vector3f normal = stack.peek().getNormal().transform(x, y, z, new Vector3f());
        BufferBuilder bufferBuilder = $this$normal_u24lambda_u246.buffer;
        Intrinsics.checkNotNull((Object)bufferBuilder);
        bufferBuilder.setNormal(normal.x, normal.y, normal.z);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator color(float red, float green, float blue, float alpha) {
        OmniTessellator omniTessellator;
        OmniTessellator $this$color_u24lambda_u247 = omniTessellator = this;
        boolean bl = false;
        $this$color_u24lambda_u247.checkBuffer();
        BufferBuilder bufferBuilder = $this$color_u24lambda_u247.buffer;
        Intrinsics.checkNotNull((Object)bufferBuilder);
        bufferBuilder.setColor(red, green, blue, alpha);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator color(int red, int green, int blue, int alpha) {
        return this.color((float)red, (float)green, (float)blue, (float)alpha);
    }

    @NotNull
    public final OmniTessellator color(int color) {
        return this.color((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }

    @NotNull
    public final OmniTessellator color(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return this.color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    @NotNull
    public final OmniTessellator texture(float u, float v) {
        OmniTessellator omniTessellator;
        OmniTessellator $this$texture_u24lambda_u248 = omniTessellator = this;
        boolean bl = false;
        $this$texture_u24lambda_u248.checkBuffer();
        BufferBuilder bufferBuilder = $this$texture_u24lambda_u248.buffer;
        Intrinsics.checkNotNull((Object)bufferBuilder);
        bufferBuilder.setUv(u, v);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator overlay(int u, int v) {
        OmniTessellator omniTessellator;
        OmniTessellator $this$overlay_u24lambda_u249 = omniTessellator = this;
        boolean bl = false;
        $this$overlay_u24lambda_u249.checkBuffer();
        BufferBuilder bufferBuilder = $this$overlay_u24lambda_u249.buffer;
        Intrinsics.checkNotNull((Object)bufferBuilder);
        bufferBuilder.setUv1(u, v);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator light(int u, int v) {
        OmniTessellator omniTessellator;
        OmniTessellator $this$light_u24lambda_u2410 = omniTessellator = this;
        boolean bl = false;
        $this$light_u24lambda_u2410.checkBuffer();
        BufferBuilder bufferBuilder = $this$light_u24lambda_u2410.buffer;
        Intrinsics.checkNotNull((Object)bufferBuilder);
        bufferBuilder.setUv2(u, v);
        return omniTessellator;
    }

    @NotNull
    public final OmniTessellator next() {
        OmniTessellator omniTessellator;
        OmniTessellator $this$next_u24lambda_u2411 = omniTessellator = this;
        boolean bl = false;
        $this$next_u24lambda_u2411.checkBuffer();
        return omniTessellator;
    }

    private final void checkBuffer() {
        if (this.buffer == null) {
            boolean bl = false;
            String string = "BufferBuilder is null";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$13() {
        return GameRenderer.getPositionShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$14() {
        return GameRenderer.getPositionColorShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$15() {
        return GameRenderer.getPositionTexShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$16() {
        return GameRenderer.getPositionTexColorShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$17() {
        return GameRenderer.getParticleShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$18() {
        return GameRenderer.getPositionColorTexLightmapShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$19() {
        return GameRenderer.getPositionColorLightmapShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$20() {
        return GameRenderer.getRendertypeLinesShader();
    }

    private static final ShaderInstance defaultShaders_delegate$lambda$22$lambda$21() {
        return OmniClient.getInstance().gameRenderer.blitShader;
    }

    private static final IdentityHashMap defaultShaders_delegate$lambda$22() {
        IdentityHashMap value = new IdentityHashMap();
        ((Map)value).put(DefaultVertexFormat.POSITION, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$13);
        ((Map)value).put(DefaultVertexFormat.POSITION_COLOR, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$14);
        ((Map)value).put(DefaultVertexFormat.POSITION_TEX, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$15);
        ((Map)value).put(DefaultVertexFormat.POSITION_TEX_COLOR, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$16);
        ((Map)value).put(DefaultVertexFormat.PARTICLE, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$17);
        ((Map)value).put(DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$18);
        ((Map)value).put(DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$19);
        ((Map)value).put(DefaultVertexFormat.POSITION_COLOR_NORMAL, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$20);
        ((Map)value).put(DefaultVertexFormat.BLIT_SCREEN, OmniTessellator::defaultShaders_delegate$lambda$22$lambda$21);
        return value;
    }

    @JvmStatic
    @NotNull
    public static final Tesselator getTessellator() {
        return Companion.getTessellator();
    }

    @JvmStatic
    @NotNull
    public static final OmniTessellator getFromBuffer() {
        return Companion.getFromBuffer();
    }

    @JvmStatic
    @NotNull
    public static final OmniTessellator getWithBuffer(@NotNull BufferBuilder buffer) {
        return Companion.getWithBuffer(buffer);
    }

    @JvmStatic
    @NotNull
    public static final OmniTessellator getFromSize(int size) {
        return Companion.getFromSize(size);
    }

    @NotNull
    public static final IdentityHashMap<VertexFormat, Supplier<ShaderInstance>> getDefaultShaders() {
        return Companion.getDefaultShaders();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R5\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\u00128FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Ldev/deftu/omnicore/client/render/OmniTessellator$Companion;", "", "<init>", "()V", "Lcom/mojang/blaze3d/vertex/Tesselator;", "getTessellator", "()Lcom/mojang/blaze3d/vertex/Tesselator;", "Ldev/deftu/omnicore/client/render/OmniTessellator;", "getFromBuffer", "()Ldev/deftu/omnicore/client/render/OmniTessellator;", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "buffer", "getWithBuffer", "(Lcom/mojang/blaze3d/vertex/BufferBuilder;)Ldev/deftu/omnicore/client/render/OmniTessellator;", "", "size", "getFromSize", "(I)Ldev/deftu/omnicore/client/render/OmniTessellator;", "Ljava/util/IdentityHashMap;", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "Ljava/util/function/Supplier;", "Lnet/minecraft/client/renderer/ShaderInstance;", "defaultShaders$delegate", "Lkotlin/Lazy;", "getDefaultShaders", "()Ljava/util/IdentityHashMap;", "getDefaultShaders$annotations", "defaultShaders", "OmniCore"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Tesselator getTessellator() {
            Tesselator tesselator = Tesselator.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)tesselator, (String)"getInstance(...)");
            return tesselator;
        }

        @JvmStatic
        @NotNull
        public final OmniTessellator getFromBuffer() {
            return new OmniTessellator(null, 0, 2, null);
        }

        @JvmStatic
        @NotNull
        public final OmniTessellator getWithBuffer(@NotNull BufferBuilder buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return new OmniTessellator(buffer, 0, 2, null);
        }

        @JvmStatic
        @NotNull
        public final OmniTessellator getFromSize(int size) {
            return new OmniTessellator(null, size);
        }

        @NotNull
        public final IdentityHashMap<VertexFormat, Supplier<ShaderInstance>> getDefaultShaders() {
            Lazy lazy = defaultShaders$delegate;
            return (IdentityHashMap)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultShaders$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;", "", "", "gl", "<init>", "(Ljava/lang/String;II)V", "I", "getGl", "()I", "Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;", "vanilla", "Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;", "getVanilla", "()Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;", "Companion", "LINES", "LINE_STRIP", "TRIANGLES", "TRIANGLE_STRIP", "TRIANGLE_FAN", "QUADS", "OmniCore"})
    public static final class DrawModes
    extends Enum<DrawModes> {
        @NotNull
        public static final Companion Companion;
        private final int gl;
        @NotNull
        private final VertexFormat.Mode vanilla;
        public static final /* enum */ DrawModes LINES;
        public static final /* enum */ DrawModes LINE_STRIP;
        public static final /* enum */ DrawModes TRIANGLES;
        public static final /* enum */ DrawModes TRIANGLE_STRIP;
        public static final /* enum */ DrawModes TRIANGLE_FAN;
        public static final /* enum */ DrawModes QUADS;
        private static final /* synthetic */ DrawModes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DrawModes(int gl) {
            this.gl = gl;
            this.vanilla = switch (this.gl) {
                case 1 -> VertexFormat.Mode.LINES;
                case 3 -> VertexFormat.Mode.LINE_STRIP;
                case 4 -> VertexFormat.Mode.TRIANGLES;
                case 5 -> VertexFormat.Mode.TRIANGLE_STRIP;
                case 6 -> VertexFormat.Mode.TRIANGLE_FAN;
                case 7 -> VertexFormat.Mode.QUADS;
                default -> throw new IllegalArgumentException("Unsupported draw mode " + this.gl);
            };
        }

        public final int getGl() {
            return this.gl;
        }

        @NotNull
        public final VertexFormat.Mode getVanilla() {
            return this.vanilla;
        }

        public static DrawModes[] values() {
            return (DrawModes[])$VALUES.clone();
        }

        public static DrawModes valueOf(String value) {
            return Enum.valueOf(DrawModes.class, value);
        }

        @NotNull
        public static EnumEntries<DrawModes> getEntries() {
            return $ENTRIES;
        }

        @JvmStatic
        @NotNull
        public static final DrawModes fromGl(int gl) {
            return Companion.fromGl(gl);
        }

        @JvmStatic
        @NotNull
        public static final VertexFormat.Mode glToVanillaDrawMode(int glMode) {
            return Companion.glToVanillaDrawMode(glMode);
        }

        @JvmStatic
        @NotNull
        public static final DrawModes fromMc(@NotNull VertexFormat.Mode mcMode) {
            return Companion.fromMc(mcMode);
        }

        @JvmStatic
        @NotNull
        public static final DrawModes fromRenderLayer(@NotNull RenderType layer) {
            return Companion.fromRenderLayer(layer);
        }

        static {
            LINES = new DrawModes(1);
            LINE_STRIP = new DrawModes(3);
            TRIANGLES = new DrawModes(4);
            TRIANGLE_STRIP = new DrawModes(5);
            TRIANGLE_FAN = new DrawModes(6);
            QUADS = new DrawModes(7);
            $VALUES = drawModesArray = new DrawModes[]{DrawModes.LINES, DrawModes.LINE_STRIP, DrawModes.TRIANGLES, DrawModes.TRIANGLE_STRIP, DrawModes.TRIANGLE_FAN, DrawModes.QUADS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes$Companion;", "", "<init>", "()V", "", "gl", "Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;", "fromGl", "(I)Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;", "glMode", "Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;", "glToVanillaDrawMode", "(I)Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;", "mcMode", "fromMc", "(Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;)Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;", "Lnet/minecraft/client/renderer/RenderType;", "layer", "fromRenderLayer", "(Lnet/minecraft/client/renderer/RenderType;)Ldev/deftu/omnicore/client/render/OmniTessellator$DrawModes;", "OmniCore"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final DrawModes fromGl(int gl) {
                return switch (gl) {
                    case 1 -> LINES;
                    case 3 -> LINE_STRIP;
                    case 4 -> TRIANGLES;
                    case 5 -> TRIANGLE_STRIP;
                    case 6 -> TRIANGLE_FAN;
                    case 7 -> QUADS;
                    default -> throw new IllegalArgumentException("Unsupported draw mode " + gl);
                };
            }

            @JvmStatic
            @NotNull
            public final VertexFormat.Mode glToVanillaDrawMode(int glMode) {
                return switch (glMode) {
                    case 1 -> VertexFormat.Mode.LINES;
                    case 3 -> VertexFormat.Mode.LINE_STRIP;
                    case 4 -> VertexFormat.Mode.TRIANGLES;
                    case 5 -> VertexFormat.Mode.TRIANGLE_STRIP;
                    case 6 -> VertexFormat.Mode.TRIANGLE_FAN;
                    case 7 -> VertexFormat.Mode.QUADS;
                    default -> throw new IllegalArgumentException("Unsupported draw mode " + glMode);
                };
            }

            @JvmStatic
            @NotNull
            public final DrawModes fromMc(@NotNull VertexFormat.Mode mcMode) {
                Intrinsics.checkNotNullParameter((Object)mcMode, (String)"mcMode");
                return switch (WhenMappings.$EnumSwitchMapping$0[mcMode.ordinal()]) {
                    case 1 -> LINES;
                    case 2 -> LINE_STRIP;
                    case 3 -> TRIANGLES;
                    case 4 -> TRIANGLE_STRIP;
                    case 5 -> TRIANGLE_FAN;
                    case 6 -> QUADS;
                    default -> throw new IllegalArgumentException("Unsupported draw mode " + mcMode);
                };
            }

            @JvmStatic
            @NotNull
            public final DrawModes fromRenderLayer(@NotNull RenderType layer) {
                Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
                VertexFormat.Mode mode = layer.mode();
                Intrinsics.checkNotNullExpressionValue((Object)mode, (String)"mode(...)");
                return this.fromMc(mode);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[VertexFormat.Mode.values().length];
                    try {
                        nArray[VertexFormat.Mode.LINES.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[VertexFormat.Mode.LINE_STRIP.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[VertexFormat.Mode.TRIANGLES.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[VertexFormat.Mode.TRIANGLE_STRIP.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[VertexFormat.Mode.TRIANGLE_FAN.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[VertexFormat.Mode.QUADS.ordinal()] = 6;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Ldev/deftu/omnicore/client/render/OmniTessellator$VertexFormats;", "", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "vanilla", "<init>", "(Ljava/lang/String;ILcom/mojang/blaze3d/vertex/VertexFormat;)V", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "getVanilla", "()Lcom/mojang/blaze3d/vertex/VertexFormat;", "POSITION", "POSITION_COLOR", "POSITION_TEXTURE", "POSITION_TEXTURE_COLOR", "OmniCore"})
    public static final class VertexFormats
    extends Enum<VertexFormats> {
        @NotNull
        private final VertexFormat vanilla;
        public static final /* enum */ VertexFormats POSITION;
        public static final /* enum */ VertexFormats POSITION_COLOR;
        public static final /* enum */ VertexFormats POSITION_TEXTURE;
        public static final /* enum */ VertexFormats POSITION_TEXTURE_COLOR;
        private static final /* synthetic */ VertexFormats[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VertexFormats(VertexFormat vanilla) {
            this.vanilla = vanilla;
        }

        @NotNull
        public final VertexFormat getVanilla() {
            return this.vanilla;
        }

        public static VertexFormats[] values() {
            return (VertexFormats[])$VALUES.clone();
        }

        public static VertexFormats valueOf(String value) {
            return Enum.valueOf(VertexFormats.class, value);
        }

        @NotNull
        public static EnumEntries<VertexFormats> getEntries() {
            return $ENTRIES;
        }

        static {
            VertexFormat vertexFormat = DefaultVertexFormat.POSITION;
            Intrinsics.checkNotNullExpressionValue((Object)vertexFormat, (String)"POSITION");
            POSITION = new VertexFormats(vertexFormat);
            VertexFormat vertexFormat2 = DefaultVertexFormat.POSITION_COLOR;
            Intrinsics.checkNotNullExpressionValue((Object)vertexFormat2, (String)"POSITION_COLOR");
            POSITION_COLOR = new VertexFormats(vertexFormat2);
            VertexFormat vertexFormat3 = DefaultVertexFormat.POSITION_TEX;
            Intrinsics.checkNotNullExpressionValue((Object)vertexFormat3, (String)"POSITION_TEX");
            POSITION_TEXTURE = new VertexFormats(vertexFormat3);
            VertexFormat vertexFormat4 = DefaultVertexFormat.POSITION_TEX_COLOR;
            Intrinsics.checkNotNullExpressionValue((Object)vertexFormat4, (String)"POSITION_TEX_COLOR");
            POSITION_TEXTURE_COLOR = new VertexFormats(vertexFormat4);
            $VALUES = vertexFormatsArray = new VertexFormats[]{VertexFormats.POSITION, VertexFormats.POSITION_COLOR, VertexFormats.POSITION_TEXTURE, VertexFormats.POSITION_TEXTURE_COLOR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

