/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.texture.GpuTexture;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1641;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00060\u0001j\u0002`\u0002:\u0001*B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0012J\r\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001b\u0010\u001fJ\u000f\u0010 \u001a\u00020\rH\u0016\u00a2\u0006\u0004\b \u0010\u0017R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b$\u0010#R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Ldev/deftu/omnicore/client/render/OmniImage;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "width", "height", "<init>", "(II)V", "x", "y", "getPixel", "(II)I", "color", "", "setPixel", "(III)V", "level", "loadFromBoundTexture", "(I)V", "id", "prepareTexture", "uploadTexture", "flipX", "()V", "flipY", "Ljava/nio/file/Path;", "path", "saveTo", "(Ljava/nio/file/Path;)V", "Ljava/io/File;", "file", "(Ljava/io/File;)V", "close", "I", "getWidth", "()I", "getHeight", "Ljava/awt/image/BufferedImage;", "native", "Ljava/awt/image/BufferedImage;", "getNative", "()Ljava/awt/image/BufferedImage;", "Companion", "OmniCore"})
public final class OmniImage
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final BufferedImage native;

    public OmniImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.native = new BufferedImage(this.width, this.height, 2);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final BufferedImage getNative() {
        return this.native;
    }

    public final int getPixel(int x, int y) {
        return this.native.getRGB(x, y);
    }

    public final void setPixel(int x, int y, int color) {
        this.native.setRGB(x, y, color);
    }

    @JvmOverloads
    public final void loadFromBoundTexture(int level) {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.width * this.height * 4));
        GL11.glGetTexImage((int)3553, (int)level, (int)6408, (int)5121, (ByteBuffer)buffer);
        int n = this.height;
        for (int y = 0; y < n; ++y) {
            int n2 = this.width;
            for (int x = 0; x < n2; ++x) {
                int index = (y * this.width + x) * 4;
                int r = buffer.get(index) & 0xFF;
                int g = buffer.get(index + 1) & 0xFF;
                int b = buffer.get(index + 2) & 0xFF;
                int a = buffer.get(index + 3) & 0xFF;
                this.setPixel(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
    }

    public static /* synthetic */ void loadFromBoundTexture$default(OmniImage omniImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        omniImage.loadFromBoundTexture(n);
    }

    public final void prepareTexture(int id) {
        class_1641.method_5857((int)id, (int)this.width, (int)this.height);
    }

    public final void uploadTexture(int id) {
        int[] data = this.native.getRGB(0, 0, this.width, this.height, null, 0, this.width);
        class_1641.method_5861((int)id, (int[])data, (int)this.width, (int)this.height);
    }

    public final void flipX() {
        Graphics2D graphics = this.native.createGraphics();
        graphics.scale(-1.0, 1.0);
        graphics.drawImage((Image)this.native, -this.width, 0, null);
        graphics.dispose();
    }

    public final void flipY() {
        Graphics2D graphics = this.native.createGraphics();
        graphics.scale(1.0, -1.0);
        graphics.drawImage((Image)this.native, 0, -this.height, null);
        graphics.dispose();
    }

    public final void saveTo(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ImageIO.write((RenderedImage)this.native, "png", path.toFile());
    }

    public final void saveTo(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ImageIO.write((RenderedImage)this.native, "png", file);
    }

    @Override
    public void close() {
        this.native.flush();
    }

    @JvmOverloads
    public final void loadFromBoundTexture() {
        OmniImage.loadFromBoundTexture$default(this, 0, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final OmniImage from(@NotNull BufferedImage bufferedImage) {
        return Companion.from(bufferedImage);
    }

    @JvmStatic
    @NotNull
    public static final OmniImage from(@NotNull GpuTexture texture) {
        return Companion.from(texture);
    }

    @JvmStatic
    @NotNull
    public static final OmniImage read(@NotNull Path path) {
        return Companion.read(path);
    }

    @JvmStatic
    @NotNull
    public static final OmniImage read(@NotNull File file) {
        return Companion.read(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ldev/deftu/omnicore/client/render/OmniImage$Companion;", "", "<init>", "()V", "Ljava/awt/image/BufferedImage;", "native", "Ldev/deftu/omnicore/client/render/OmniImage;", "from", "(Ljava/awt/image/BufferedImage;)Ldev/deftu/omnicore/client/render/OmniImage;", "Ldev/deftu/omnicore/client/render/texture/GpuTexture;", "texture", "(Ldev/deftu/omnicore/client/render/texture/GpuTexture;)Ldev/deftu/omnicore/client/render/OmniImage;", "Ljava/nio/file/Path;", "path", "read", "(Ljava/nio/file/Path;)Ldev/deftu/omnicore/client/render/OmniImage;", "Ljava/io/File;", "file", "(Ljava/io/File;)Ldev/deftu/omnicore/client/render/OmniImage;", "OmniCore"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OmniImage from(@NotNull BufferedImage bufferedImage) {
            OmniImage omniImage;
            Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"native");
            OmniImage $this$from_u24lambda_u240 = omniImage = new OmniImage(bufferedImage.getWidth(), bufferedImage.getHeight());
            boolean bl = false;
            Graphics2D graphics = $this$from_u24lambda_u240.getNative().createGraphics();
            graphics.drawImage((Image)bufferedImage, 0, 0, null);
            graphics.dispose();
            return omniImage;
        }

        @JvmStatic
        @NotNull
        public final OmniImage from(@NotNull GpuTexture texture) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            OmniImage image = new OmniImage(texture.getWidth(), texture.getHeight());
            OmniTextureManager.Companion.configureTexture(texture.getId(), () -> Companion.from$lambda$1(image));
            return image;
        }

        @JvmStatic
        @NotNull
        public final OmniImage read(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            BufferedImage bufferedImage = ImageIO.read(path.toFile());
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
            return this.from(bufferedImage);
        }

        @JvmStatic
        @NotNull
        public final OmniImage read(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            BufferedImage bufferedImage = ImageIO.read(file);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
            return this.from(bufferedImage);
        }

        private static final void from$lambda$1(OmniImage $image) {
            $image.loadFromBoundTexture(0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

