/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import dev.deftu.omnicore.client.OmniClient;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import java.io.Closeable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001(B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\rJ\u000f\u0010\u0012\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0015\u0010\rR\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R5\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001a\u0010\u0018\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u000b*\u0004\b\u001e\u0010\u001fR(\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0004\b!\u0010\"\u0012\u0004\b'\u0010\u0010\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture;", "Lnet/minecraft/client/renderer/texture/AbstractTexture;", "", "width", "height", "Lcom/mojang/blaze3d/platform/NativeImage;", "data", "<init>", "(IILcom/mojang/blaze3d/platform/NativeImage;)V", "(II)V", "image", "(Lcom/mojang/blaze3d/platform/NativeImage;)V", "allocGlId", "()I", "", "upload", "()V", "getId", "releaseId", "I", "getWidth", "getHeight", "Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture$Resources;", "resources", "Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture$Resources;", "<set-?>", "data$receiver", "getData", "()Lcom/mojang/blaze3d/platform/NativeImage;", "setData", "getData$delegate", "(Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture;)Ljava/lang/Object;", "", "uploaded", "Z", "getUploaded", "()Z", "setUploaded", "(Z)V", "getUploaded$annotations", "Resources", "OmniCore"})
public final class ReleasedDynamicTexture
extends AbstractTexture {
    private final int width;
    private final int height;
    @NotNull
    private Resources resources;
    @NotNull
    private final Resources data$receiver;
    private boolean uploaded;

    public ReleasedDynamicTexture(int width, int height, @Nullable NativeImage data) {
        this.width = width;
        this.height = height;
        this.data$receiver = this.resources = new Resources(this);
        NativeImage nativeImage = data;
        if (nativeImage == null) {
            nativeImage = new NativeImage(this.width, this.height, true);
        }
        this.resources.setData(nativeImage);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public ReleasedDynamicTexture(int width, int height) {
        this(width, height, null);
    }

    public ReleasedDynamicTexture(@NotNull NativeImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this(image.getWidth(), image.getHeight(), image);
    }

    private final NativeImage getData() {
        return this.data$receiver.getData();
    }

    private final void setData(NativeImage nativeImage) {
        this.data$receiver.setData(nativeImage);
    }

    private static Object getData$delegate(ReleasedDynamicTexture releasedDynamicTexture) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)releasedDynamicTexture.data$receiver, Resources.class, "data", "getData()Lcom/mojang/blaze3d/platform/NativeImage;", 0)));
    }

    public final boolean getUploaded() {
        return this.uploaded;
    }

    public final void setUploaded(boolean bl) {
        this.uploaded = bl;
    }

    public static /* synthetic */ void getUploaded$annotations() {
    }

    private final int allocGlId() {
        return super.getId();
    }

    public final void upload() {
        if (!this.uploaded) {
            TextureUtil.prepareImage((int)this.allocGlId(), (int)this.width, (int)this.height);
            OmniTextureManager.Companion.configureTexture(this.allocGlId(), () -> ReleasedDynamicTexture.upload$lambda$0(this));
            this.setData(null);
            this.uploaded = true;
            this.resources.setGlId(this.allocGlId());
            Resources.Companion.drainCleanupQueue();
        }
    }

    public int getId() {
        this.upload();
        return super.getId();
    }

    public void releaseId() {
        super.releaseId();
        this.resources.setGlId(-1);
    }

    private static final void upload$lambda$0(ReleasedDynamicTexture this$0) {
        block0: {
            NativeImage nativeImage = this$0.getData();
            if (nativeImage == null) break block0;
            nativeImage.upload(0, 0, 0, false);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0019B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R.\u0010\u0013\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture$Resources;", "Ljava/lang/ref/PhantomReference;", "Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture;", "Ljava/io/Closeable;", "referent", "<init>", "(Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture;)V", "", "close", "()V", "", "glId", "I", "getGlId", "()I", "setGlId", "(I)V", "Lcom/mojang/blaze3d/platform/NativeImage;", "value", "data", "Lcom/mojang/blaze3d/platform/NativeImage;", "getData", "()Lcom/mojang/blaze3d/platform/NativeImage;", "setData", "(Lcom/mojang/blaze3d/platform/NativeImage;)V", "Companion", "OmniCore"})
    private static final class Resources
    extends PhantomReference<ReleasedDynamicTexture>
    implements Closeable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int glId;
        @Nullable
        private NativeImage data;
        @NotNull
        private static final ReferenceQueue<ReleasedDynamicTexture> referenceQueue = new ReferenceQueue();
        @NotNull
        private static final Set<Resources> toBeCleanedUp;

        public Resources(@NotNull ReleasedDynamicTexture referent) {
            Intrinsics.checkNotNullParameter((Object)((Object)referent), (String)"referent");
            super(referent, referenceQueue);
            this.glId = -1;
            toBeCleanedUp.add(this);
        }

        public final int getGlId() {
            return this.glId;
        }

        public final void setGlId(int n) {
            this.glId = n;
        }

        @Nullable
        public final NativeImage getData() {
            return this.data;
        }

        public final void setData(@Nullable NativeImage value) {
            NativeImage nativeImage = this.data;
            if (nativeImage != null) {
                nativeImage.close();
            }
            this.data = value;
        }

        @Override
        public void close() {
            toBeCleanedUp.remove(this);
            if (this.glId != -1) {
                OmniClient.getTextureManager().deleteTexture(this.glId);
                this.glId = -1;
            }
            this.setData(null);
        }

        static {
            Set set = Collections.newSetFromMap(new ConcurrentHashMap());
            Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
            toBeCleanedUp = set;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture$Resources$Companion;", "", "<init>", "()V", "", "drainCleanupQueue", "Ljava/lang/ref/ReferenceQueue;", "Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "", "Ldev/deftu/omnicore/client/render/ReleasedDynamicTexture$Resources;", "toBeCleanedUp", "Ljava/util/Set;", "getToBeCleanedUp", "()Ljava/util/Set;", "OmniCore"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ReferenceQueue<ReleasedDynamicTexture> getReferenceQueue() {
                return referenceQueue;
            }

            @NotNull
            public final Set<Resources> getToBeCleanedUp() {
                return toBeCleanedUp;
            }

            public final void drainCleanupQueue() {
                while (true) {
                    Reference<ReleasedDynamicTexture> reference = this.getReferenceQueue().poll();
                    if (reference == null) break;
                    ((Resources)reference).close();
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

