/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common;

import dev.deftu.omnicore.common.TickScheduler;
import java.io.Serializable;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0002&'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006("}, d2={"Ldev/deftu/omnicore/common/DefaultTickScheduler;", "Ldev/deftu/omnicore/common/TickScheduler;", "", "name", "<init>", "(Ljava/lang/String;)V", "Ljava/lang/Runnable;", "runnable", "", "post", "(Ljava/lang/Runnable;)V", "", "delay", "Ldev/deftu/omnicore/common/TickScheduler$Handle;", "after", "(ILjava/lang/Runnable;)Ldev/deftu/omnicore/common/TickScheduler$Handle;", "period", "initialDelay", "", "isFixedRate", "every", "(IIZLjava/lang/Runnable;)Ldev/deftu/omnicore/common/TickScheduler$Handle;", "tick", "()V", "Ljava/lang/String;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "immediate", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/PriorityQueue;", "Ldev/deftu/omnicore/common/DefaultTickScheduler$ScheduledHandle;", "scheduled", "Ljava/util/PriorityQueue;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isTicking", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "tickCounter", "J", "Companion", "ScheduledHandle", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nDefaultTickScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTickScheduler.kt\ndev/deftu/omnicore/common/DefaultTickScheduler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class DefaultTickScheduler
implements TickScheduler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final ConcurrentLinkedQueue<Runnable> immediate;
    @NotNull
    private final PriorityQueue<ScheduledHandle> scheduled;
    @NotNull
    private AtomicBoolean isTicking;
    private long tickCounter;
    private static final Logger logger = LogManager.getLogger(TickScheduler.class);

    public DefaultTickScheduler(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.immediate = new ConcurrentLinkedQueue();
        this.scheduled = new PriorityQueue(new Comparator(){

            public final int compare(T a, T b) {
                ScheduledHandle p0 = (ScheduledHandle)a;
                boolean $i$f$scheduled$stub_for_inlining = false;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getWhenTick());
                p0 = (ScheduledHandle)b;
                Comparable comparable2 = comparable;
                $i$f$scheduled$stub_for_inlining = false;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getWhenTick()));
            }
        });
        this.isTicking = new AtomicBoolean(false);
    }

    @Override
    public void post(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.immediate.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TickScheduler.Handle after(int delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (!(delay >= 0)) {
            boolean bl = false;
            String string = "Delay must be non-negative";
            throw new IllegalArgumentException(string.toString());
        }
        long target = this.tickCounter + (long)Math.max(1, delay);
        ScheduledHandle handle = new ScheduledHandle(target, 0, false, runnable);
        PriorityQueue<ScheduledHandle> priorityQueue = this.scheduled;
        synchronized (priorityQueue) {
            boolean bl = false;
            boolean bl2 = this.scheduled.add(handle);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TickScheduler.Handle every(int period, int initialDelay, boolean isFixedRate, @NotNull Runnable runnable) {
        void it;
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (!(period > 0)) {
            boolean $i$a$-require-DefaultTickScheduler$every$32 = false;
            String $i$a$-require-DefaultTickScheduler$every$32 = "Period must be positive";
            throw new IllegalArgumentException($i$a$-require-DefaultTickScheduler$every$32.toString());
        }
        if (!(initialDelay >= 0)) {
            boolean bl = false;
            String string = "Initial delay must be non-negative";
            throw new IllegalArgumentException(string.toString());
        }
        int n = 1;
        Serializable serializable = initialDelay;
        int n2 = ((Number)serializable).intValue();
        long l = this.tickCounter;
        boolean bl = false;
        boolean bl2 = it > 0;
        Integer n3 = bl2 ? serializable : null;
        int n4 = n3 != null ? n3 : period;
        long first = l + (long)Math.max(n, n4);
        ScheduledHandle handle = new ScheduledHandle(first, period, isFixedRate, runnable);
        serializable = this.scheduled;
        synchronized (serializable) {
            boolean bl3 = false;
            n2 = this.scheduled.add(handle) ? 1 : 0;
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void tick() {
        if (this.isTicking.get()) {
            logger.warn("TickScheduler " + this.name + " is already ticking; skipping to avoid reentrancy");
            return;
        }
        this.isTicking.set(true);
        try {
            long l = this.tickCounter;
            this.tickCounter = l + 1L;
            while (this.immediate.poll() != null) {
                try {
                    Runnable task;
                    task.run();
                }
                catch (Throwable e) {
                    logger.error("Error executing immediate task in " + this.name, e);
                }
            }
            while (true) {
                ScheduledHandle next;
                PriorityQueue<ScheduledHandle> priorityQueue = this.scheduled;
                // MONITORENTER : priorityQueue
                boolean bl = false;
                ScheduledHandle scheduledHandle = this.scheduled.peek();
                // MONITOREXIT : priorityQueue
                if (scheduledHandle == null) {
                    return;
                }
                if (next.getWhenTick() > this.tickCounter) {
                    return;
                }
                PriorityQueue<ScheduledHandle> priorityQueue2 = this.scheduled;
                // MONITORENTER : priorityQueue2
                boolean $i$a$-synchronized-DefaultTickScheduler$tick$32 = false;
                ScheduledHandle $i$a$-synchronized-DefaultTickScheduler$tick$32 = this.scheduled.poll();
                // MONITOREXIT : priorityQueue2
                if (next.isCancelled()) continue;
                try {
                    next.getRunnable().run();
                }
                catch (Throwable e) {
                    logger.error("Error executing scheduled task in " + this.name, e);
                }
                if (next.isCancelled() || next.getPeriod() <= 0) continue;
                next.setWhenTick(next.isFixedRate() ? next.getWhenTick() + (long)next.getPeriod() : this.tickCounter + (long)next.getPeriod());
                priorityQueue2 = this.scheduled;
                // MONITORENTER : priorityQueue2
                boolean bl2 = false;
                boolean bl3 = this.scheduled.add(next);
                // MONITOREXIT : priorityQueue2
            }
        }
        finally {
            this.isTicking.set(false);
        }
    }

    @Override
    @NotNull
    public TickScheduler.Handle every(int period, int initialDelay, @NotNull Runnable runnable) {
        return TickScheduler.DefaultImpls.every(this, period, initialDelay, runnable);
    }

    @Override
    @NotNull
    public TickScheduler.Handle every(int period, @NotNull Runnable runnable) {
        return TickScheduler.DefaultImpls.every(this, period, runnable);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/deftu/omnicore/common/DefaultTickScheduler$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "OmniCore"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J8\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001b\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0012J\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010$R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b&\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b\u0007\u0010\u0014R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010(\u001a\u0004\b)\u0010\u0016R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R$\u0010.\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0014\"\u0004\b/\u00100\u00a8\u00061"}, d2={"Ldev/deftu/omnicore/common/DefaultTickScheduler$ScheduledHandle;", "Ldev/deftu/omnicore/common/TickScheduler$Handle;", "", "whenTick", "", "period", "", "isFixedRate", "Ljava/lang/Runnable;", "runnable", "<init>", "(JIZLjava/lang/Runnable;)V", "", "cancel", "()V", "component1", "()J", "component2", "()I", "component3", "()Z", "component4", "()Ljava/lang/Runnable;", "copy", "(JIZLjava/lang/Runnable;)Ldev/deftu/omnicore/common/DefaultTickScheduler$ScheduledHandle;", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "J", "getWhenTick", "setWhenTick", "(J)V", "I", "getPeriod", "Z", "Ljava/lang/Runnable;", "getRunnable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "value", "isCancelled", "setCancelled", "(Z)V", "OmniCore"})
    private static final class ScheduledHandle
    implements TickScheduler.Handle {
        private long whenTick;
        private final int period;
        private final boolean isFixedRate;
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final AtomicBoolean cancelled;

        public ScheduledHandle(long whenTick, int period, boolean isFixedRate, @NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            this.whenTick = whenTick;
            this.period = period;
            this.isFixedRate = isFixedRate;
            this.runnable = runnable;
            this.cancelled = new AtomicBoolean(false);
        }

        public final long getWhenTick() {
            return this.whenTick;
        }

        public final void setWhenTick(long l) {
            this.whenTick = l;
        }

        public final int getPeriod() {
            return this.period;
        }

        public final boolean isFixedRate() {
            return this.isFixedRate;
        }

        @NotNull
        public final Runnable getRunnable() {
            return this.runnable;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        public void setCancelled(boolean value) {
            this.cancelled.set(value);
        }

        @Override
        public void cancel() {
            this.setCancelled(true);
        }

        public final long component1() {
            return this.whenTick;
        }

        public final int component2() {
            return this.period;
        }

        public final boolean component3() {
            return this.isFixedRate;
        }

        @NotNull
        public final Runnable component4() {
            return this.runnable;
        }

        @NotNull
        public final ScheduledHandle copy(long whenTick, int period, boolean isFixedRate, @NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            return new ScheduledHandle(whenTick, period, isFixedRate, runnable);
        }

        public static /* synthetic */ ScheduledHandle copy$default(ScheduledHandle scheduledHandle, long l, int n, boolean bl, Runnable runnable, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = scheduledHandle.whenTick;
            }
            if ((n2 & 2) != 0) {
                n = scheduledHandle.period;
            }
            if ((n2 & 4) != 0) {
                bl = scheduledHandle.isFixedRate;
            }
            if ((n2 & 8) != 0) {
                runnable = scheduledHandle.runnable;
            }
            return scheduledHandle.copy(l, n, bl, runnable);
        }

        @NotNull
        public String toString() {
            return "ScheduledHandle(whenTick=" + this.whenTick + ", period=" + this.period + ", isFixedRate=" + this.isFixedRate + ", runnable=" + this.runnable + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.whenTick);
            result = result * 31 + Integer.hashCode(this.period);
            result = result * 31 + Boolean.hashCode(this.isFixedRate);
            result = result * 31 + this.runnable.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScheduledHandle)) {
                return false;
            }
            ScheduledHandle scheduledHandle = (ScheduledHandle)other;
            if (this.whenTick != scheduledHandle.whenTick) {
                return false;
            }
            if (this.period != scheduledHandle.period) {
                return false;
            }
            if (this.isFixedRate != scheduledHandle.isFixedRate) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.runnable, (Object)scheduledHandle.runnable);
        }
    }
}

