/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.pipeline;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.LogicOp;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.deftu.omnicore.client.render.pipeline.DrawModes;
import dev.deftu.omnicore.client.render.pipeline.LegacyShaderSource;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipeline;
import dev.deftu.omnicore.client.render.pipeline.ShaderSource;
import dev.deftu.omnicore.client.render.pipeline.VanillaShaderSource;
import dev.deftu.omnicore.client.render.state.ColorLogicMode;
import dev.deftu.omnicore.client.render.state.DepthFunction;
import dev.deftu.omnicore.client.render.state.OmniManagedAlphaState;
import dev.deftu.omnicore.client.render.state.OmniManagedBlendState;
import dev.deftu.omnicore.client.render.state.OmniManagedColorLogic;
import dev.deftu.omnicore.client.render.state.OmniManagedColorMask;
import dev.deftu.omnicore.client.render.state.OmniManagedDepthState;
import dev.deftu.omnicore.client.render.state.OmniManagedPolygonOffset;
import dev.deftu.omnicore.client.shaders.ShaderProcessor;
import dev.deftu.omnicore.client.shaders.UniformType;
import dev.deftu.omnicore.common.OmniIdentifier;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0011R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "vertexFormat", "Ldev/deftu/omnicore/client/render/pipeline/DrawModes;", "mode", "Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;", "shaderSource", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;)V", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "build", "()Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "Ldev/deftu/omnicore/client/render/pipeline/DrawModes;", "Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;", "Ldev/deftu/omnicore/client/render/state/OmniManagedBlendState;", "blendState", "Ldev/deftu/omnicore/client/render/state/OmniManagedBlendState;", "Ldev/deftu/omnicore/client/render/state/OmniManagedDepthState;", "depthState", "Ldev/deftu/omnicore/client/render/state/OmniManagedDepthState;", "Ldev/deftu/omnicore/client/render/state/OmniManagedAlphaState;", "alphaState", "Ldev/deftu/omnicore/client/render/state/OmniManagedAlphaState;", "Ldev/deftu/omnicore/client/render/state/OmniManagedColorLogic;", "colorLogic", "Ldev/deftu/omnicore/client/render/state/OmniManagedColorLogic;", "Ldev/deftu/omnicore/client/render/state/OmniManagedColorMask;", "colorMask", "Ldev/deftu/omnicore/client/render/state/OmniManagedColorMask;", "Ldev/deftu/omnicore/client/render/state/OmniManagedPolygonOffset;", "polygonOffset", "Ldev/deftu/omnicore/client/render/state/OmniManagedPolygonOffset;", "", "isCullFace", "Z", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nOmniRenderPipelineBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniRenderPipelineBuilder.kt\ndev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,160:1\n1869#2,2:161\n1869#2,2:165\n216#3,2:163\n*S KotlinDebug\n*F\n+ 1 OmniRenderPipelineBuilder.kt\ndev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder\n*L\n108#1:161,2\n115#1:165,2\n109#1:163,2\n*E\n"})
public final class OmniRenderPipelineBuilder {
    @NotNull
    private final ResourceLocation identifier;
    @NotNull
    private final VertexFormat vertexFormat;
    @NotNull
    private final DrawModes mode;
    @NotNull
    private final ShaderSource shaderSource;
    @JvmField
    @NotNull
    public OmniManagedBlendState blendState;
    @JvmField
    @NotNull
    public OmniManagedDepthState depthState;
    @JvmField
    @NotNull
    public OmniManagedAlphaState alphaState;
    @JvmField
    @NotNull
    public OmniManagedColorLogic colorLogic;
    @JvmField
    @NotNull
    public OmniManagedColorMask colorMask;
    @JvmField
    @NotNull
    public OmniManagedPolygonOffset polygonOffset;
    @JvmField
    public boolean isCullFace;

    public OmniRenderPipelineBuilder(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @NotNull ShaderSource shaderSource) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)shaderSource, (String)"shaderSource");
        this.identifier = identifier;
        this.vertexFormat = vertexFormat;
        this.mode = mode;
        this.shaderSource = shaderSource;
        this.blendState = OmniManagedBlendState.DISABLED;
        this.depthState = OmniManagedDepthState.DISABLED;
        this.alphaState = OmniManagedAlphaState.DISABLED;
        this.colorLogic = OmniManagedColorLogic.DISABLED;
        this.colorMask = OmniManagedColorMask.DEFAULT;
        this.polygonOffset = OmniManagedPolygonOffset.DISABLED;
    }

    @NotNull
    public final OmniRenderPipeline build() {
        RenderPipeline.Builder builder;
        Function2 shaderSourcesFunction = null;
        RenderPipeline.Builder $this$build_u24lambda_u244 = builder = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]);
        boolean bl = false;
        $this$build_u24lambda_u244.withLocation(this.identifier);
        $this$build_u24lambda_u244.withVertexFormat(this.vertexFormat, this.mode.getVanilla());
        $this$build_u24lambda_u244.withDepthWrite(this.depthState.isMask());
        $this$build_u24lambda_u244.withCull(this.isCullFace);
        boolean isWritingColor = this.colorMask.getRed() || this.colorMask.getGreen() || this.colorMask.getBlue();
        boolean isWritingAlpha = this.colorMask.getAlpha();
        $this$build_u24lambda_u244.withColorWrite(isWritingColor, isWritingAlpha);
        RenderPipeline.Builder builder2 = this.blendState.isEnabled() ? $this$build_u24lambda_u244.withBlend(this.blendState.getFunction().getVanilla()) : $this$build_u24lambda_u244.withoutBlend();
        if (this.polygonOffset.isEnabled()) {
            $this$build_u24lambda_u244.withDepthBias(this.polygonOffset.getFactor(), this.polygonOffset.getUnits());
        }
        $this$build_u24lambda_u244.withDepthTestFunction(switch (WhenMappings.$EnumSwitchMapping$0[this.depthState.getFunction().ordinal()]) {
            case 1 -> DepthTestFunction.LESS_DEPTH_TEST;
            case 2 -> DepthTestFunction.EQUAL_DEPTH_TEST;
            case 3 -> DepthTestFunction.LEQUAL_DEPTH_TEST;
            case 4 -> DepthTestFunction.GREATER_DEPTH_TEST;
            default -> DepthTestFunction.NO_DEPTH_TEST;
        });
        $this$build_u24lambda_u244.withColorLogic(WhenMappings.$EnumSwitchMapping$1[this.colorLogic.getMode().ordinal()] == 1 ? LogicOp.OR_REVERSE : LogicOp.NONE);
        ShaderSource shaderSource = this.shaderSource;
        if (shaderSource instanceof LegacyShaderSource) {
            Object element$iv;
            ShaderProcessor processor = new ShaderProcessor(this.vertexFormat, 150);
            String transformedVertexSource = processor.transform(((LegacyShaderSource)this.shaderSource).getVertexSource());
            ResourceLocation vertexIdentifier = OmniIdentifier.create("omnicore", "shader/generated/" + DigestUtils.sha1Hex((String)transformedVertexSource));
            String transformedFragmentSource = processor.transform(((LegacyShaderSource)this.shaderSource).getFragmentSource());
            ResourceLocation fragmentIdentifier = OmniIdentifier.create("omnicore", "shader/generated/" + DigestUtils.sha1Hex((String)transformedFragmentSource));
            shaderSourcesFunction = (arg_0, arg_1) -> OmniRenderPipelineBuilder.build$lambda$4$lambda$0(vertexIdentifier, transformedVertexSource, fragmentIdentifier, transformedFragmentSource, arg_0, arg_1);
            $this$build_u24lambda_u244.withVertexShader(vertexIdentifier);
            $this$build_u24lambda_u244.withFragmentShader(fragmentIdentifier);
            Object $this$forEach$iv = processor.getSamplers();
            boolean $i$f$forEach = false;
            Iterator<Object> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                String p0 = (String)element$iv;
                boolean bl2 = false;
                $this$build_u24lambda_u244.withSampler(p0);
            }
            $this$forEach$iv = processor.getUniforms();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = element$iv = (Map.Entry)iterator.next();
                boolean bl3 = false;
                String name = (String)object.getKey();
                UniformType type = (UniformType)((Object)object.getValue());
                $this$build_u24lambda_u244.withUniform(name, type.getVanilla());
            }
        } else if (shaderSource instanceof VanillaShaderSource) {
            $this$build_u24lambda_u244.withVertexShader(((VanillaShaderSource)this.shaderSource).getVertexIdentifier());
            $this$build_u24lambda_u244.withFragmentShader(((VanillaShaderSource)this.shaderSource).getFragmentIdentifier());
            Iterable $this$forEach$iv = ((VanillaShaderSource)this.shaderSource).getSamplers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl4 = false;
                $this$build_u24lambda_u244.withSampler(p0);
            }
            ((VanillaShaderSource)this.shaderSource).getUniforms().forEach((arg_0, arg_1) -> OmniRenderPipelineBuilder.build$lambda$4$lambda$3((Function2)new Function2<String, com.mojang.blaze3d.shaders.UniformType, Unit>((Object)$this$build_u24lambda_u244){

                public final void invoke(String p0, com.mojang.blaze3d.shaders.UniformType p1) {
                    ((RenderPipeline.Builder)this.receiver).withUniform(p0, p1);
                }
            }, arg_0, arg_1));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RenderPipeline vanillaPipeline2 = builder.build();
        builder = vanillaPipeline2;
        Intrinsics.checkNotNull((Object)builder);
        return new OmniRenderPipeline(this.identifier, this.vertexFormat, (RenderPipeline)builder, (Function2<? super ResourceLocation, ? super ShaderType, String>)shaderSourcesFunction);
    }

    private static final String build$lambda$4$lambda$0(ResourceLocation $vertexIdentifier, String $transformedVertexSource, ResourceLocation $fragmentIdentifier, String $transformedFragmentSource, ResourceLocation id, ShaderType type) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ResourceLocation resourceLocation = id;
        return Intrinsics.areEqual((Object)resourceLocation, (Object)$vertexIdentifier) ? $transformedVertexSource : (Intrinsics.areEqual((Object)resourceLocation, (Object)$fragmentIdentifier) ? $transformedFragmentSource : null);
    }

    private static final void build$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DepthFunction.values().length];
            try {
                nArray[DepthFunction.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DepthFunction.EQUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DepthFunction.LESS_OR_EQUAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DepthFunction.GREATER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ColorLogicMode.values().length];
            try {
                nArray[ColorLogicMode.OR_REVERSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

