/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.eventbus;

import dev.deftu.eventbus.EventPriority;
import dev.deftu.eventbus.EventSubscriber;
import dev.deftu.eventbus.SubscribeEvent;
import dev.deftu.eventbus.collection.ConcurrentSubscriberArrayList;
import dev.deftu.eventbus.collection.SubscriberArrayList;
import dev.deftu.eventbus.invokers.Invoker;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u00013B+\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J;\u0010\u0017\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001c\u001a\u00020\u001b\"\u0006\b\u0000\u0010\u0012\u0018\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001fJ\u0015\u0010 \u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0001\u00a2\u0006\u0004\b \u0010\u001fJ\u0015\u0010!\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0001\u00a2\u0006\u0004\b!\u0010\u001fJ\u0013\u0010#\u001a\u00020\u001b*\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$R!\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010(\u001a\u0004\b)\u0010*R-\u0010,\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0+8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00100\u001a\u0004\b1\u00102\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00064"}, d2={"Ldev/deftu/eventbus/EventBus;", "", "Ldev/deftu/eventbus/invokers/Invoker;", "invoker", "Ljava/util/function/Consumer;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exceptionHandler", "", "threadSafety", "<init>", "(Ldev/deftu/eventbus/invokers/Invoker;Ljava/util/function/Consumer;Z)V", "Ljava/lang/Class;", "clazz", "", "Ldev/deftu/eventbus/EventSubscriber;", "getSubscribedEvents", "(Ljava/lang/Class;)Ljava/util/List;", "T", "listener", "Ldev/deftu/eventbus/EventPriority;", "priority", "Ljava/lang/Runnable;", "on", "(Ljava/lang/Class;Ljava/util/function/Consumer;Ldev/deftu/eventbus/EventPriority;)Ljava/lang/Runnable;", "Lkotlin/Function0;", "supplier", "", "post", "(Lkotlin/jvm/functions/Function0;)V", "event", "(Ljava/lang/Object;)V", "register", "unregister", "Ljava/lang/reflect/Method;", "checkParameters", "(Ljava/lang/reflect/Method;)V", "Ljava/util/function/Consumer;", "getExceptionHandler", "()Ljava/util/function/Consumer;", "Ldev/deftu/eventbus/invokers/Invoker;", "getInvoker", "()Ldev/deftu/eventbus/invokers/Invoker;", "Ljava/util/AbstractMap;", "subscribers", "Ljava/util/AbstractMap;", "getSubscribers", "()Ljava/util/AbstractMap;", "Z", "getThreadSafety", "()Z", "PriorityComparator", "EnhancedEventBus"})
public final class EventBus {
    @NotNull
    private final Invoker invoker;
    @NotNull
    private final Consumer<Exception> exceptionHandler;
    private final boolean threadSafety;
    @NotNull
    private final AbstractMap<Class<?>, List<EventSubscriber>> subscribers;

    public EventBus(@NotNull Invoker invoker, @NotNull Consumer<Exception> exceptionHandler2, boolean threadSafety) {
        Intrinsics.checkNotNullParameter((Object)invoker, (String)"invoker");
        Intrinsics.checkNotNullParameter(exceptionHandler2, (String)"exceptionHandler");
        this.invoker = invoker;
        this.exceptionHandler = exceptionHandler2;
        this.threadSafety = threadSafety;
        this.subscribers = this.threadSafety ? (AbstractMap)new ConcurrentHashMap() : (AbstractMap)new HashMap();
    }

    @NotNull
    public final Invoker getInvoker() {
        return this.invoker;
    }

    @NotNull
    public final Consumer<Exception> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final boolean getThreadSafety() {
        return this.threadSafety;
    }

    @NotNull
    public final AbstractMap<Class<?>, List<EventSubscriber>> getSubscribers() {
        return this.subscribers;
    }

    private final void checkParameters(Method $this$checkParameters) {
        if ($this$checkParameters.getParameterCount() < 1) {
            throw new IllegalArgumentException("Method " + $this$checkParameters.getName() + " has no parameters, but it is marked with the @SubscribeEvent annotation. Event listeners must be methods with at least one parameter.");
        }
        if ($this$checkParameters.getParameterCount() > 1) {
            throw new IllegalArgumentException("Subscribed method cannot have more than one parameter.");
        }
    }

    public final void register(@NotNull Object listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Method[] methodArray = listener.getClass().getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"listener::class.java.declaredMethods");
        for (Method method2 : methodArray) {
            SubscribeEvent annotation;
            if (method2.getAnnotation(SubscribeEvent.class) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
            this.checkParameters(method2);
            Class<?> parameterClazz = method2.getParameterTypes()[0];
            if (!Intrinsics.areEqual(method2.getReturnType(), Void.TYPE)) {
                throw new IllegalArgumentException("Subscribed method must be of type 'Void'. ");
            }
            if (parameterClazz.isPrimitive()) {
                throw new IllegalArgumentException("Cannot subscribe method to a primitive.");
            }
            if ((parameterClazz.getModifiers() & 0x600) != 0) {
                throw new IllegalArgumentException("Cannot subscribe method to a polymorphic class.");
            }
            EventSubscriber subscriber = new EventSubscriber(listener, annotation.priority(), this.invoker.setup(listener, listener.getClass(), parameterClazz, method2));
            this.subscribers.computeIfAbsent(parameterClazz, arg_0 -> EventBus.register$lambda-0(this, arg_0)).add(subscriber);
        }
    }

    public final void unregister(@NotNull Object listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Method[] methodArray = listener.getClass().getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"listener::class.java.declaredMethods");
        for (Method method2 : methodArray) {
            if (method2.getAnnotation(SubscribeEvent.class) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
            this.checkParameters(method2);
            Class<?> parameterClazz = method2.getParameterTypes()[0];
            List<EventSubscriber> list = this.subscribers.get(parameterClazz);
            if (list == null) continue;
            list.removeIf(arg_0 -> EventBus.unregister$lambda-1(listener, arg_0));
        }
    }

    @JvmOverloads
    @NotNull
    public final <T> Runnable on(@NotNull Class<T> clazz, @NotNull Consumer<T> listener, @NotNull EventPriority priority) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Invoker.SubscriberMethod method2 = arg_0 -> EventBus.on$lambda-2(listener, arg_0);
        EventSubscriber subscriber = new EventSubscriber(this, priority, method2);
        this.subscribers.computeIfAbsent(clazz, arg_0 -> EventBus.on$lambda-3(this, arg_0)).add(subscriber);
        return () -> EventBus.on$lambda-4(this, clazz, subscriber);
    }

    public static /* synthetic */ Runnable on$default(EventBus eventBus, Class clazz, Consumer consumer, EventPriority eventPriority, int n, Object object) {
        if ((n & 4) != 0) {
            eventPriority = EventPriority.NORMAL;
        }
        return eventBus.on(clazz, consumer, eventPriority);
    }

    public final void post(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<EventSubscriber> list = this.subscribers.get(event.getClass());
        if (list == null) {
            return;
        }
        List<EventSubscriber> listeners = list;
        CollectionsKt.sortWith(listeners, (Comparator)new PriorityComparator());
        for (EventSubscriber listener : listeners) {
            try {
                listener.invoke(event);
            }
            catch (Exception e) {
                this.exceptionHandler.accept(e);
            }
        }
    }

    public final /* synthetic */ <T> void post(Function0<? extends T> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        boolean $i$f$post = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        List<EventSubscriber> list = this.getSubscribedEvents(Object.class);
        if (list == null) {
            return;
        }
        List<EventSubscriber> events = list;
        Object event = supplier.invoke();
        CollectionsKt.sortWith(events, (Comparator)new PriorityComparator());
        for (EventSubscriber listener : events) {
            try {
                listener.invoke(event);
            }
            catch (Exception e) {
                this.getExceptionHandler().accept(e);
            }
        }
    }

    @Nullable
    public final List<EventSubscriber> getSubscribedEvents(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.subscribers.get(clazz);
    }

    @JvmOverloads
    @NotNull
    public final <T> Runnable on(@NotNull Class<T> clazz, @NotNull Consumer<T> listener) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return EventBus.on$default(this, clazz, listener, null, 4, null);
    }

    private static final List register$lambda-0(EventBus this$0, Class it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.threadSafety ? (List)new ConcurrentSubscriberArrayList() : (List)new SubscriberArrayList();
    }

    private static final boolean unregister$lambda-1(Object $listener, EventSubscriber it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getListener(), (Object)$listener);
    }

    private static final void on$lambda-2(Consumer $listener, Object arg) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.accept(arg);
    }

    private static final List on$lambda-3(EventBus this$0, Class it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.threadSafety ? (List)new ConcurrentSubscriberArrayList() : (List)new SubscriberArrayList();
    }

    private static final void on$lambda-4(EventBus this$0, Class $clazz, EventSubscriber $subscriber) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$clazz, (String)"$clazz");
            Intrinsics.checkNotNullParameter((Object)$subscriber, (String)"$subscriber");
            List<EventSubscriber> list = this$0.subscribers.get($clazz);
            if (list == null) break block0;
            list.remove($subscriber);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ldev/deftu/eventbus/EventBus$PriorityComparator;", "Ljava/util/Comparator;", "Ldev/deftu/eventbus/EventSubscriber;", "<init>", "()V", "o1", "o2", "", "compare", "(Ldev/deftu/eventbus/EventSubscriber;Ldev/deftu/eventbus/EventSubscriber;)I", "EnhancedEventBus"})
    public static final class PriorityComparator
    implements Comparator<EventSubscriber> {
        @Override
        public int compare(@NotNull EventSubscriber o1, @NotNull EventSubscriber o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return o2.getPriority().ordinal() - o1.getPriority().ordinal();
        }
    }
}

