/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.shaders;

import dev.deftu.omnicore.client.shaders.UniformType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_2522;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\rR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R#\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Ldev/deftu/omnicore/client/shaders/ShaderProcessor;", "", "Lnet/minecraft/class_2522;", "vertexFormat", "", "targetVersion", "<init>", "(Lnet/minecraft/class_2522;I)V", "", "originalSource", "transform", "(Ljava/lang/String;)Ljava/lang/String;", "Lnet/minecraft/class_2522;", "I", "", "attributes", "Ljava/util/List;", "getAttributes", "()Ljava/util/List;", "", "samplers", "Ljava/util/Set;", "getSamplers", "()Ljava/util/Set;", "", "Ldev/deftu/omnicore/client/shaders/UniformType;", "uniforms", "Ljava/util/Map;", "getUniforms", "()Ljava/util/Map;", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nShaderProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderProcessor.kt\ndev/deftu/omnicore/client/shaders/ShaderProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1863#2,2:209\n1797#2,3:211\n*S KotlinDebug\n*F\n+ 1 ShaderProcessor.kt\ndev/deftu/omnicore/client/shaders/ShaderProcessor\n*L\n94#1:209,2\n160#1:211,3\n*E\n"})
public final class ShaderProcessor {
    @Nullable
    private final class_2522 vertexFormat;
    private final int targetVersion;
    @NotNull
    private final List<String> attributes;
    @NotNull
    private final Set<String> samplers;
    @NotNull
    private final Map<String, UniformType> uniforms;

    public ShaderProcessor(@Nullable class_2522 vertexFormat, int targetVersion) {
        this.vertexFormat = vertexFormat;
        this.targetVersion = targetVersion;
        this.attributes = new ArrayList();
        this.samplers = new LinkedHashSet();
        this.uniforms = new LinkedHashMap();
        Object[] objectArray = new Integer[]{110, 130, 150};
        if (!SetsKt.setOf((Object[])objectArray).contains(this.targetVersion)) {
            throw new IllegalArgumentException("Target version " + this.targetVersion + " is not supported. Supported versions are 110, 130, and 150.");
        }
    }

    @NotNull
    public final List<String> getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final Set<String> getSamplers() {
        return this.samplers;
    }

    @NotNull
    public final Map<String, UniformType> getUniforms() {
        return this.uniforms;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String transform(@NotNull String originalSource) {
        Object object;
        String varyingOut;
        Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
        Ref.ObjectRef source = new Ref.ObjectRef();
        source.element = originalSource;
        source.element = StringsKt.replace$default((String)((String)source.element), (String)"gl_ModelViewProjectionMatrix", (String)"gl_ProjectionMatrix * gl_ModelViewMatrix", (boolean)false, (int)4, null);
        if (this.targetVersion >= 130) {
            source.element = StringsKt.replace$default((String)((String)source.element), (String)"texture2D", (String)"texture", (boolean)false, (int)4, null);
        }
        Map replacements = new LinkedHashMap();
        List transformed = new ArrayList();
        transformed.add("#version " + this.targetVersion);
        boolean isFrag = StringsKt.contains$default((CharSequence)originalSource, (CharSequence)"gl_FragColor", (boolean)false, (int)2, null);
        boolean isVert = !isFrag;
        String attributeIn = this.targetVersion >= 130 ? "in" : "attribute";
        String varyingIn = this.targetVersion >= 130 ? "in" : "varying";
        String string = varyingOut = this.targetVersion >= 130 ? "out" : "varying";
        if (isFrag && this.targetVersion >= 130) {
            transformed.add(varyingOut + " vec4 oc_FragColor;");
            replacements.put("gl_FragColor", "oc_FragColor");
        }
        if (isVert && StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)"gl_FrontColor", (boolean)false, (int)2, null)) {
            transformed.add(varyingOut + " vec4 oc_FrontColor;");
            replacements.put("gl_FrontColor", "oc_FrontColor");
        }
        if (isFrag && StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)"gl_Color", (boolean)false, (int)2, null)) {
            transformed.add(varyingIn + " vec4 oc_FrontColor;");
            replacements.put("gl_Color", "oc_FrontColor");
        }
        if (isVert) {
            List newAttributes = new ArrayList();
            ShaderProcessor.transform$replaceAttrib((Ref.ObjectRef<String>)source, replacements, attributeIn, newAttributes, "gl_Vertex", "vec3", "oc_Position", "vec4(oc_Position, 1.0)");
            ShaderProcessor.transform$replaceAttrib$default(source, replacements, attributeIn, newAttributes, "gl_Color", "vec4", null, null, 192, null);
            ShaderProcessor.transform$replaceAttrib$default(source, replacements, attributeIn, newAttributes, "gl_MultiTexCoord0.st", "vec2", "oc_UV0", null, 128, null);
            ShaderProcessor.transform$replaceAttrib$default(source, replacements, attributeIn, newAttributes, "gl_MultiTexCoord1.st", "vec2", "oc_UV1", null, 128, null);
            ShaderProcessor.transform$replaceAttrib$default(source, replacements, attributeIn, newAttributes, "gl_MultiTexCoord2.st", "vec2", "oc_UV2", null, 128, null);
            Iterable $this$forEach$iv = newAttributes;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                String name = (String)pair.component1();
                String type = (String)pair.component2();
                this.attributes.add(name);
                transformed.add(type);
            }
        }
        ShaderProcessor.transform$replaceUniform$default(source, replacements, this, transformed, "gl_ModelViewMatrix", UniformType.Mat4, "ModelViewMat", null, 128, null);
        ShaderProcessor.transform$replaceUniform$default(source, replacements, this, transformed, "gl_ProjectionMatrix", UniformType.Mat4, "ProjMat", null, 128, null);
        for (String line : StringsKt.lines((CharSequence)((CharSequence)source.element))) {
            String string2;
            List list = transformed;
            if (StringsKt.startsWith$default((String)line, (String)"#version", (boolean)false, (int)2, null)) continue;
            if (StringsKt.startsWith$default((String)line, (String)"varying ", (boolean)false, (int)2, null) && this.targetVersion >= 130) {
                string2 = (isFrag ? "in " : "out ") + StringsKt.substringAfter$default((String)line, (String)"varying ", null, (int)2, null);
            } else if (StringsKt.startsWith$default((String)line, (String)"uniform ", (boolean)false, (int)2, null)) {
                object = new char[]{';'};
                CharSequence charSequence = StringsKt.trimEnd((String)line, (char[])object);
                object = new String[]{" "};
                List $i$f$forEach = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
                String typeName = (String)$i$f$forEach.get(1);
                String name = (String)$i$f$forEach.get(2);
                if (Intrinsics.areEqual((Object)typeName, (Object)"sampler2D")) {
                    this.samplers.add(name);
                    string2 = line;
                } else {
                    this.uniforms.put(name, UniformType.Companion.fromGlsl(typeName));
                    string2 = line;
                }
            } else {
                void $this$fold$iv;
                Iterable $i$f$forEach = replacements.entrySet();
                List list2 = list;
                boolean $i$f$fold = false;
                String accumulator$iv = line;
                for (Object element$iv : $this$fold$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    String acc = accumulator$iv;
                    boolean bl = false;
                    String needle = (String)entry.getKey();
                    String replacement = (String)entry.getValue();
                    accumulator$iv = StringsKt.replace$default((String)acc, (String)needle, (String)replacement, (boolean)false, (int)4, null);
                }
                string2 = accumulator$iv;
                list = list2;
            }
            list.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)transformed, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final void transform$replaceAttrib(Ref.ObjectRef<String> source, Map<String, String> replacements, String attributeIn, List<Pair<String, String>> value, String needle, String type, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)needle, (boolean)false, (int)2, null)) {
            replacements.put(needle, replacement);
            value.add((Pair<String, String>)TuplesKt.to((Object)replacementName, (Object)(attributeIn + ' ' + type + ' ' + replacementName + ';')));
        }
    }

    static /* synthetic */ void transform$replaceAttrib$default(Ref.ObjectRef objectRef, Map map, String string, List list, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 0x40) != 0) {
            string4 = "oc_" + StringsKt.substringAfter$default((String)string2, (String)"_", null, (int)2, null);
        }
        if ((n & 0x80) != 0) {
            string5 = string4;
        }
        ShaderProcessor.transform$replaceAttrib((Ref.ObjectRef<String>)objectRef, map, string, list, string2, string3, string4, string5);
    }

    private static final void transform$replaceUniform(Ref.ObjectRef<String> source, Map<String, String> replacements, ShaderProcessor this$0, List<String> transformed, String needle, UniformType type, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)((CharSequence)source.element), (CharSequence)needle, (boolean)false, (int)2, null)) {
            replacements.put(needle, replacement);
            if (!this$0.uniforms.containsKey(replacementName)) {
                this$0.uniforms.put(replacementName, type);
                transformed.add("uniform " + type.getGlslName() + ' ' + replacementName + ';');
            }
        }
    }

    static /* synthetic */ void transform$replaceUniform$default(Ref.ObjectRef objectRef, Map map, ShaderProcessor shaderProcessor, List list, String string, UniformType uniformType, String string2, String string3, int n, Object object) {
        if ((n & 0x80) != 0) {
            string3 = string2;
        }
        ShaderProcessor.transform$replaceUniform((Ref.ObjectRef<String>)objectRef, map, shaderProcessor, list, string, uniformType, string2, string3);
    }
}

