/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\bJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\fJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0015\"\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR*\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u0012\u0004\b\"\u0010\u0003\u001a\u0004\b\u001f\u0010!R*\u0010#\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010 \u0012\u0004\b$\u0010\u0003\u001a\u0004\b#\u0010!R*\u0010%\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010 \u0012\u0004\b&\u0010\u0003\u001a\u0004\b%\u0010!R*\u0010'\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010 \u0012\u0004\b(\u0010\u0003\u001a\u0004\b'\u0010!R*\u0010)\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010 \u0012\u0004\b*\u0010\u0003\u001a\u0004\b)\u0010!R*\u0010+\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010 \u0012\u0004\b,\u0010\u0003\u001a\u0004\b+\u0010!\u00a8\u0006-"}, d2={"Ldev/deftu/omnicore/client/OmniDesktop;", "", "<init>", "()V", "Ljava/net/URI;", "uri", "", "browse", "(Ljava/net/URI;)Z", "Ljava/io/File;", "file", "open", "(Ljava/io/File;)Z", "edit", "browseInternally", "openInternally", "editInternally", "", "path", "openWithCommand", "(Ljava/lang/String;)Z", "", "command", "checkExit", "run", "([Ljava/lang/String;Z)Z", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "value", "isWindows", "Z", "()Z", "isWindows$annotations", "isMac", "isMac$annotations", "isLinux", "isLinux$annotations", "isXdg", "isXdg$annotations", "isKde", "isKde$annotations", "isGnome", "isGnome$annotations", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nOmniDesktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniDesktop.kt\ndev/deftu/omnicore/client/OmniDesktop\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1761#2,3:164\n*S KotlinDebug\n*F\n+ 1 OmniDesktop.kt\ndev/deftu/omnicore/client/OmniDesktop\n*L\n138#1:164,3\n*E\n"})
public final class OmniDesktop {
    @NotNull
    public static final OmniDesktop INSTANCE;
    private static final Logger logger;
    private static boolean isWindows;
    private static boolean isMac;
    private static boolean isLinux;
    private static boolean isXdg;
    private static boolean isKde;
    private static boolean isGnome;

    private OmniDesktop() {
    }

    public static final boolean isWindows() {
        return isWindows;
    }

    @JvmStatic
    public static /* synthetic */ void isWindows$annotations() {
    }

    public static final boolean isMac() {
        return isMac;
    }

    @JvmStatic
    public static /* synthetic */ void isMac$annotations() {
    }

    public static final boolean isLinux() {
        return isLinux;
    }

    @JvmStatic
    public static /* synthetic */ void isLinux$annotations() {
    }

    public static final boolean isXdg() {
        return isXdg;
    }

    @JvmStatic
    public static /* synthetic */ void isXdg$annotations() {
    }

    public static final boolean isKde() {
        return isKde;
    }

    @JvmStatic
    public static /* synthetic */ void isKde$annotations() {
    }

    public static final boolean isGnome() {
        return isGnome;
    }

    @JvmStatic
    public static /* synthetic */ void isGnome$annotations() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean browse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (INSTANCE.browseInternally(uri)) return true;
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (!INSTANCE.openWithCommand(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean open(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (INSTANCE.openInternally(file)) return true;
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        if (!INSTANCE.openWithCommand(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean edit(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (INSTANCE.editInternally(file)) return true;
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        if (!INSTANCE.openWithCommand(string)) return false;
        return true;
    }

    private final boolean browseInternally(URI uri) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        try {
            if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                return false;
            }
            Desktop.getDesktop().browse(uri);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Failed to browse URI", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final boolean openInternally(File file) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        try {
            if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                return false;
            }
            Desktop.getDesktop().open(file);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Failed to open file", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final boolean editInternally(File file) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        try {
            if (!Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                return false;
            }
            Desktop.getDesktop().edit(file);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Failed to edit file", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final boolean openWithCommand(String path) {
        boolean bl;
        block9: {
            if (isWindows) {
                String[] stringArray = new String[]{"rundll32", "url.dll.FileProtocolHandler", path};
                bl = this.run(stringArray, false);
            } else if (isMac) {
                String[] stringArray = new String[]{"open", path};
                bl = this.run(stringArray, false);
            } else if (isLinux) {
                Object[] objectArray = new String[]{"xdg-open", "gnome-open", "kde-open"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String command = (String)element$iv;
                        boolean bl2 = false;
                        String[] stringArray = new String[]{command, path};
                        if (!INSTANCE.run(stringArray, true)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean run(String[] command, boolean checkExit) {
        boolean bl;
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (process == null) {
                return false;
            }
            Process process2 = process;
            bl = checkExit ? (process2.waitFor(5L, TimeUnit.SECONDS) ? process2.exitValue() == 0 : true) : process2.isAlive();
        }
        catch (Exception e) {
            logger.error("Failed to run command", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    static {
        String string;
        INSTANCE = new OmniDesktop();
        logger = LogManager.getLogger();
        try {
            String string2 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string = string3;
        }
        catch (Exception e) {
            logger.error("Failed to get OS name", (Throwable)e);
            string = null;
        }
        String osName = string;
        if (osName != null) {
            isWindows = StringsKt.startsWith$default((String)osName, (String)"Windows", (boolean)false, (int)2, null);
            isMac = StringsKt.startsWith$default((String)osName, (String)"Mac", (boolean)false, (int)2, null);
            boolean bl = isLinux = StringsKt.startsWith$default((String)osName, (String)"Linux", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osName, (String)"LINUX", (boolean)false, (int)2, null);
            if (isLinux) {
                String gnomeSession;
                String string4;
                String string5 = System.getenv("XDG_SESSION_ID");
                isXdg = string5 != null ? ((CharSequence)string5).length() > 0 : false;
                String string6 = System.getenv("GDMSESSION");
                if (string6 != null) {
                    String string7 = string6.toLowerCase(Locale.ROOT);
                    string4 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                } else {
                    string4 = null;
                }
                String string8 = gnomeSession = string4;
                isGnome = string8 != null ? StringsKt.contains$default((CharSequence)string8, (CharSequence)"gnome", (boolean)false, (int)2, null) : false;
                String string9 = gnomeSession;
                isKde = string9 != null ? StringsKt.contains$default((CharSequence)string9, (CharSequence)"kde", (boolean)false, (int)2, null) : false;
            }
        } else {
            logger.error("Couldn't assign OS variables because the OS name is null");
        }
    }
}

