/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client;

import dev.deftu.omnicore.common.OmniIdentifier;
import dev.deftu.omnicore.common.OmniPacketHandler;
import dev.deftu.omnicore.common.OmniPacketReceiverContext;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001BG\u0012$\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u00030\u0002\u0012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R2\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0013R&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/deftu/omnicore/client/OmniClientPacketHandler;", "Ldev/deftu/omnicore/common/OmniPacketHandler;", "Lkotlin/Function0;", "", "Lnet/minecraft/util/ResourceLocation;", "", "Ljava/util/function/Predicate;", "Ldev/deftu/omnicore/common/OmniPacketReceiverContext;", "channeledPacketReceiverProvider", "globalPacketReceiverProvider", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "Lnet/minecraft/network/Packet;", "packet", "", "handleRead", "(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/Packet;)Z", "Lkotlin/jvm/functions/Function0;", "OmniCore"})
public final class OmniClientPacketHandler
extends OmniPacketHandler {
    @NotNull
    private final Function0<Map<ResourceLocation, Set<Predicate<OmniPacketReceiverContext>>>> channeledPacketReceiverProvider;
    @NotNull
    private final Function0<Set<Predicate<OmniPacketReceiverContext>>> globalPacketReceiverProvider;

    public OmniClientPacketHandler(@NotNull Function0<? extends Map<ResourceLocation, ? extends Set<? extends Predicate<OmniPacketReceiverContext>>>> channeledPacketReceiverProvider, @NotNull Function0<? extends Set<? extends Predicate<OmniPacketReceiverContext>>> globalPacketReceiverProvider) {
        Intrinsics.checkNotNullParameter(channeledPacketReceiverProvider, (String)"channeledPacketReceiverProvider");
        Intrinsics.checkNotNullParameter(globalPacketReceiverProvider, (String)"globalPacketReceiverProvider");
        this.channeledPacketReceiverProvider = channeledPacketReceiverProvider;
        this.globalPacketReceiverProvider = globalPacketReceiverProvider;
    }

    @Override
    public boolean handleRead(@NotNull ChannelHandlerContext ctx, @Nullable Packet<?> packet) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Map channeledPacketReceivers = (Map)this.channeledPacketReceiverProvider.invoke();
        Set globalPacketReceivers = (Set)this.globalPacketReceiverProvider.invoke();
        S3FPacketCustomPayload s3FPacketCustomPayload = packet instanceof S3FPacketCustomPayload ? (S3FPacketCustomPayload)packet : null;
        if (s3FPacketCustomPayload == null) {
            return false;
        }
        S3FPacketCustomPayload customPayloadPacket = s3FPacketCustomPayload;
        String channelName = customPayloadPacket.func_149169_c();
        PacketBuffer buf = customPayloadPacket.func_180735_b();
        Intrinsics.checkNotNull((Object)channelName);
        ResourceLocation channel = OmniIdentifier.create(channelName);
        Set set = (Set)channeledPacketReceivers.get(channel);
        Collection channeledReceivers = set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
        List receivers = CollectionsKt.plus((Collection)channeledReceivers, (Iterable)globalPacketReceivers);
        Intrinsics.checkNotNull((Object)buf);
        OmniPacketReceiverContext context = new OmniPacketReceiverContext(channel, buf);
        for (Predicate receiver : receivers) {
            if (!receiver.test(context)) continue;
            return true;
        }
        return false;
    }
}

