/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common.codecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.deftu.omnicore.common.OmniNbt;
import dev.deftu.omnicore.common.codecs.NbtByteArrayMerger;
import dev.deftu.omnicore.common.codecs.NbtCompoundListMerger;
import dev.deftu.omnicore.common.codecs.NbtIntArrayMerger;
import dev.deftu.omnicore.common.codecs.NbtMerger;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\r\u001a\u00028\u0000\"\u0004\b\u0000\u0010\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00012\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0017\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b \u0010!J/\u0010$\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020#0\"0\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b$\u0010\u0012J)\u0010&\u001a\u00020\u00022\u0018\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020#0\"H\u0016\u00a2\u0006\u0004\b&\u0010'J#\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\"0\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b(\u0010\u0012J\u001d\u0010)\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0016\u00a2\u0006\u0004\b)\u0010'J\u001f\u0010*\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010,\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b/\u00100R\u001b\u00104\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u0010\t\u00a8\u00065"}, d2={"Ldev/deftu/omnicore/common/codecs/NbtOps;", "Lcom/mojang/serialization/DynamicOps;", "Lnet/minecraft/nbt/NBTBase;", "<init>", "()V", "get", "()Lcom/mojang/serialization/DynamicOps;", "Lnet/minecraft/nbt/NBTTagEnd;", "empty", "()Lnet/minecraft/nbt/NBTTagEnd;", "U", "otherOps", "input", "convertTo", "(Lcom/mojang/serialization/DynamicOps;Lnet/minecraft/nbt/NBTBase;)Ljava/lang/Object;", "Lcom/mojang/serialization/DataResult;", "", "getNumberValue", "(Lnet/minecraft/nbt/NBTBase;)Lcom/mojang/serialization/DataResult;", "i", "createNumeric", "(Ljava/lang/Number;)Lnet/minecraft/nbt/NBTBase;", "", "getStringValue", "value", "createString", "(Ljava/lang/String;)Lnet/minecraft/nbt/NBTBase;", "list", "mergeToList", "(Lnet/minecraft/nbt/NBTBase;Lnet/minecraft/nbt/NBTBase;)Lcom/mojang/serialization/DataResult;", "map", "key", "mergeToMap", "(Lnet/minecraft/nbt/NBTBase;Lnet/minecraft/nbt/NBTBase;Lnet/minecraft/nbt/NBTBase;)Lcom/mojang/serialization/DataResult;", "Ljava/util/stream/Stream;", "Lcom/mojang/datafixers/util/Pair;", "getMapValues", "stream", "createMap", "(Ljava/util/stream/Stream;)Lnet/minecraft/nbt/NBTBase;", "getStream", "createList", "remove", "(Lnet/minecraft/nbt/NBTBase;Ljava/lang/String;)Lnet/minecraft/nbt/NBTBase;", "base", "Ljava/util/Optional;", "Ldev/deftu/omnicore/common/codecs/NbtMerger;", "createMerger", "(Lnet/minecraft/nbt/NBTBase;)Ljava/util/Optional;", "EMPTY$delegate", "Lkotlin/Lazy;", "getEMPTY", "EMPTY", "OmniCore"})
public final class NbtOps
implements DynamicOps<NBTBase> {
    @NotNull
    public static final NbtOps INSTANCE = new NbtOps();
    @NotNull
    private static final Lazy EMPTY$delegate = LazyKt.lazy(NbtOps::EMPTY_delegate$lambda$0);

    private NbtOps() {
    }

    private final NBTTagEnd getEMPTY() {
        Lazy lazy = EMPTY$delegate;
        return (NBTTagEnd)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final DynamicOps<NBTBase> get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public NBTTagEnd empty() {
        return this.getEMPTY();
    }

    @Override
    public <U> U convertTo(@NotNull DynamicOps<U> otherOps, @NotNull NBTBase input) {
        U u;
        Intrinsics.checkNotNullParameter(otherOps, (String)"otherOps");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        NBTBase nBTBase = input;
        if (nBTBase instanceof NBTTagEnd) {
            u = otherOps.empty();
        } else if (nBTBase instanceof NBTTagByte) {
            u = otherOps.createByte(((NBTTagByte)input).func_150290_f());
        } else if (nBTBase instanceof NBTTagShort) {
            u = otherOps.createShort(((NBTTagShort)input).func_150289_e());
        } else if (nBTBase instanceof NBTTagInt) {
            u = otherOps.createInt(((NBTTagInt)input).func_150287_d());
        } else if (nBTBase instanceof NBTTagLong) {
            u = otherOps.createLong(((NBTTagLong)input).func_150291_c());
        } else if (nBTBase instanceof NBTTagFloat) {
            u = otherOps.createFloat(((NBTTagFloat)input).func_150288_h());
        } else if (nBTBase instanceof NBTTagDouble) {
            u = otherOps.createDouble(((NBTTagDouble)input).func_150286_g());
        } else if (nBTBase instanceof NBTTagByteArray) {
            u = otherOps.createByteList(ByteBuffer.wrap(((NBTTagByteArray)input).func_150292_c()));
        } else if (nBTBase instanceof NBTTagString) {
            u = otherOps.createString(((NBTTagString)input).func_150285_a_());
        } else if (nBTBase instanceof NBTTagList) {
            u = this.convertList(otherOps, input);
        } else if (nBTBase instanceof NBTTagCompound) {
            u = this.convertMap(otherOps, input);
        } else if (nBTBase instanceof NBTTagIntArray) {
            u = otherOps.createIntList(Arrays.stream(((NBTTagIntArray)input).func_150302_c()));
        } else {
            throw new IllegalArgumentException("Unknown NBT type: " + input.getClass().getName());
        }
        return u;
    }

    @Override
    @NotNull
    public DataResult<Number> getNumberValue(@NotNull NBTBase input) {
        DataResult<Number> dataResult;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        NBTBase nBTBase = input;
        if (nBTBase instanceof NBTTagByte) {
            DataResult<Byte> dataResult2 = DataResult.success(((NBTTagByte)input).func_150290_f());
            dataResult = dataResult2;
            Intrinsics.checkNotNullExpressionValue(dataResult2, (String)"success(...)");
        } else if (nBTBase instanceof NBTTagShort) {
            DataResult<Short> dataResult3 = DataResult.success(((NBTTagShort)input).func_150289_e());
            dataResult = dataResult3;
            Intrinsics.checkNotNullExpressionValue(dataResult3, (String)"success(...)");
        } else if (nBTBase instanceof NBTTagInt) {
            DataResult<Integer> dataResult4 = DataResult.success(((NBTTagInt)input).func_150287_d());
            dataResult = dataResult4;
            Intrinsics.checkNotNullExpressionValue(dataResult4, (String)"success(...)");
        } else if (nBTBase instanceof NBTTagLong) {
            DataResult<Long> dataResult5 = DataResult.success(((NBTTagLong)input).func_150291_c());
            dataResult = dataResult5;
            Intrinsics.checkNotNullExpressionValue(dataResult5, (String)"success(...)");
        } else if (nBTBase instanceof NBTTagFloat) {
            DataResult<Float> dataResult6 = DataResult.success(Float.valueOf(((NBTTagFloat)input).func_150288_h()));
            dataResult = dataResult6;
            Intrinsics.checkNotNullExpressionValue(dataResult6, (String)"success(...)");
        } else if (nBTBase instanceof NBTTagDouble) {
            DataResult<Double> dataResult7 = DataResult.success(((NBTTagDouble)input).func_150286_g());
            dataResult = dataResult7;
            Intrinsics.checkNotNullExpressionValue(dataResult7, (String)"success(...)");
        } else {
            DataResult dataResult8 = DataResult.error("Not a number: " + input.getClass().getName());
            dataResult = dataResult8;
            Intrinsics.checkNotNullExpressionValue(dataResult8, (String)"error(...)");
        }
        return dataResult;
    }

    @Override
    @NotNull
    public NBTBase createNumeric(@NotNull Number i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return (NBTBase)new NBTTagDouble(i.doubleValue());
    }

    @Override
    @NotNull
    public DataResult<String> getStringValue(@NotNull NBTBase input) {
        DataResult<String> dataResult;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input instanceof NBTTagString) {
            DataResult<String> dataResult2 = DataResult.success(((NBTTagString)input).func_150285_a_());
            Intrinsics.checkNotNull(dataResult2);
            dataResult = dataResult2;
        } else {
            DataResult dataResult3 = DataResult.error("Not a string: " + input.getClass().getName());
            Intrinsics.checkNotNull(dataResult3);
            dataResult = dataResult3;
        }
        return dataResult;
    }

    @Override
    @NotNull
    public NBTBase createString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (NBTBase)new NBTTagString(value);
    }

    @Override
    @NotNull
    public DataResult<NBTBase> mergeToList(@NotNull NBTBase list, @NotNull NBTBase value) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DataResult dataResult = this.createMerger(list).map(arg_0 -> NbtOps.mergeToList$lambda$2(arg_0 -> NbtOps.mergeToList$lambda$1(value, arg_0), arg_0)).orElseGet(() -> NbtOps.mergeToList$lambda$3(list));
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"orElseGet(...)");
        return dataResult;
    }

    @Override
    @NotNull
    public DataResult<NBTBase> mergeToMap(@NotNull NBTBase map, @NotNull NBTBase key, @NotNull NBTBase value) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(map instanceof NBTTagCompound) && !(map instanceof NBTTagEnd)) {
            DataResult<NBTBase> dataResult = DataResult.error("mergeToMap called with not a map: " + map, map);
            Intrinsics.checkNotNullExpressionValue(dataResult, (String)"error(...)");
            return dataResult;
        }
        if (!(key instanceof NBTTagString)) {
            DataResult<NBTBase> dataResult = DataResult.error("key is not a string: " + key, map);
            Intrinsics.checkNotNullExpressionValue(dataResult, (String)"error(...)");
            return dataResult;
        }
        String key2 = ((NBTTagString)key).func_150285_a_();
        if (map instanceof NBTTagCompound) {
            NBTBase nBTBase = ((NBTTagCompound)map).func_74737_b();
            Intrinsics.checkNotNull((Object)nBTBase, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            nBTTagCompound = (NBTTagCompound)nBTBase;
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound copy = nBTTagCompound;
        copy.func_74782_a(key2, value);
        DataResult<NBTTagCompound> dataResult = DataResult.success(copy);
        Intrinsics.checkNotNullExpressionValue(dataResult, (String)"success(...)");
        return dataResult;
    }

    @Override
    @NotNull
    public DataResult<Stream<Pair<NBTBase, NBTBase>>> getMapValues(@NotNull NBTBase input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(input instanceof NBTTagCompound)) {
            DataResult<Stream<Pair<NBTBase, NBTBase>>> dataResult = DataResult.error("Not a map: " + input.getClass().getName());
            Intrinsics.checkNotNullExpressionValue(dataResult, (String)"error(...)");
            return dataResult;
        }
        Map map = new LinkedHashMap();
        for (String key : ((NBTTagCompound)input).func_150296_c()) {
            NBTBase value = ((NBTTagCompound)input).func_74781_a(key);
            if (value == null) continue;
            map.put(new NBTTagString(key), value);
        }
        DataResult<Stream<Pair<NBTBase, NBTBase>>> dataResult = DataResult.success(map.entrySet().stream().map(arg_0 -> NbtOps.getMapValues$lambda$5(NbtOps::getMapValues$lambda$4, arg_0)));
        Intrinsics.checkNotNullExpressionValue(dataResult, (String)"success(...)");
        return dataResult;
    }

    @Override
    @NotNull
    public NBTBase createMap(@NotNull Stream<Pair<NBTBase, NBTBase>> stream) {
        Intrinsics.checkNotNullParameter(stream, (String)"stream");
        NBTTagCompound compound = new NBTTagCompound();
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            NBTBase key = (NBTBase)pair.getFirst();
            NBTBase value = (NBTBase)pair.getSecond();
            if (key instanceof NBTTagString) {
                compound.func_74782_a(((NBTTagString)key).func_150285_a_(), value);
                continue;
            }
            throw new UnsupportedOperationException("Cannot create map with non-string key: " + key);
        }
        return (NBTBase)compound;
    }

    @Override
    @NotNull
    public DataResult<Stream<NBTBase>> getStream(@NotNull NBTBase input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(input instanceof NBTTagList)) {
            DataResult<Stream<NBTBase>> dataResult = DataResult.error("Not a list: " + input.getClass().getName());
            Intrinsics.checkNotNullExpressionValue(dataResult, (String)"error(...)");
            return dataResult;
        }
        List newList = new ArrayList();
        int n = OmniNbt.List.size((NBTTagList)input);
        for (int i = 0; i < n; ++i) {
            NBTBase item = ((NBTTagList)input).func_179238_g(i);
            if (item == null) continue;
            newList.add(item);
        }
        DataResult<Stream<NBTBase>> dataResult = DataResult.success(newList.stream());
        Intrinsics.checkNotNullExpressionValue(dataResult, (String)"success(...)");
        return dataResult;
    }

    @Override
    @NotNull
    public NBTBase createList(@NotNull Stream<NBTBase> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        NBTTagList list = new NBTTagList();
        Iterator iterator = input.iterator();
        while (iterator.hasNext()) {
            NBTBase item = (NBTBase)iterator.next();
            list.func_74742_a(item);
        }
        return (NBTBase)list;
    }

    @Override
    @NotNull
    public NBTBase remove(@NotNull NBTBase input, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(input instanceof NBTTagCompound)) {
            return input;
        }
        NBTBase nBTBase = ((NBTTagCompound)input).func_74737_b();
        Intrinsics.checkNotNull((Object)nBTBase, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
        NBTTagCompound copy = (NBTTagCompound)nBTBase;
        copy.func_82580_o(key);
        return (NBTBase)copy;
    }

    private final Optional<NbtMerger> createMerger(NBTBase base) {
        Optional<NbtMerger> optional;
        if (base instanceof NBTTagEnd) {
            Optional<NbtMerger> optional2 = Optional.of(new NbtCompoundListMerger(null, 1, null));
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
            return optional2;
        }
        NBTBase nBTBase = base;
        if (nBTBase instanceof NBTTagList) {
            Optional<NbtCompoundListMerger> optional3 = ((NBTTagList)base).func_82582_d() ? Optional.of(new NbtCompoundListMerger(null, 1, null)) : Optional.of(new NbtCompoundListMerger((NBTTagList)base));
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        } else if (nBTBase instanceof NBTTagByteArray) {
            Optional<NbtMerger> optional4;
            if (base.func_82582_d()) {
                optional4 = Optional.of(new NbtCompoundListMerger(null, 1, null));
            } else {
                byte[] byArray = ((NBTTagByteArray)base).func_150292_c();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getByteArray(...)");
                optional4 = Optional.of(new NbtByteArrayMerger(byArray));
            }
            Optional<NbtCompoundListMerger> optional5 = optional4;
            Intrinsics.checkNotNull(optional5);
            optional = optional5;
        } else if (nBTBase instanceof NBTTagIntArray) {
            Optional<NbtMerger> optional6;
            if (base.func_82582_d()) {
                optional6 = Optional.of(new NbtCompoundListMerger(null, 1, null));
            } else {
                int[] nArray = ((NBTTagIntArray)base).func_150302_c();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getIntArray(...)");
                optional6 = Optional.of(new NbtIntArrayMerger(nArray));
            }
            Optional<NbtCompoundListMerger> optional7 = optional6;
            Intrinsics.checkNotNull(optional7);
            optional = optional7;
        } else {
            Optional<NbtMerger> optional8 = Optional.empty();
            optional = optional8;
            Intrinsics.checkNotNullExpressionValue(optional8, (String)"empty(...)");
        }
        return optional;
    }

    private static final NBTTagEnd EMPTY_delegate$lambda$0() {
        Class[] classArray = new Class[]{Integer.TYPE};
        Method create = NBTBase.class.getDeclaredMethod("create", classArray);
        create.setAccessible(true);
        Object[] objectArray = new Object[]{0};
        Object object = create.invoke(null, objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagEnd");
        return (NBTTagEnd)object;
    }

    private static final DataResult mergeToList$lambda$1(NBTBase $value, NbtMerger merger) {
        return DataResult.success(merger.merge($value).getResult());
    }

    private static final DataResult mergeToList$lambda$2(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final DataResult mergeToList$lambda$3(NBTBase $list) {
        return DataResult.error("mergeToList called with not a list: " + $list, $list);
    }

    private static final Pair getMapValues$lambda$4(Map.Entry entry) {
        return Pair.of(entry.getKey(), entry.getValue());
    }

    private static final Pair getMapValues$lambda$5(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }
}

