/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common.codecs;

import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0000H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\u0004\b\u0000\u0010\u00042\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0000H\u0007\u00a2\u0006\u0004\b\t\u0010\rJ7\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J=\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\b\"\u0004\b\u0000\u0010\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u000fH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0012J%\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ldev/deftu/omnicore/common/codecs/OmniDataResult;", "", "<init>", "()V", "T", "", "message", "partialValue", "Lcom/mojang/serialization/DataResult;", "error", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "Lkotlin/Function0;", "supplier", "(Lkotlin/jvm/functions/Function0;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "result", "Ljava/util/function/Consumer;", "consumer", "ifSuccess", "(Lcom/mojang/serialization/DataResult;Ljava/util/function/Consumer;)Lcom/mojang/serialization/DataResult;", "Lcom/mojang/serialization/DataResult$PartialResult;", "ifError", "Ljava/util/stream/IntStream;", "stream", "", "length", "", "decodeFixedLengthArray", "(Ljava/util/stream/IntStream;I)Lcom/mojang/serialization/DataResult;", "OmniCore"})
public final class OmniDataResult {
    @NotNull
    public static final OmniDataResult INSTANCE = new OmniDataResult();

    private OmniDataResult() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> DataResult<T> error(@NotNull String message, @Nullable T partialValue) {
        DataResult<Object> dataResult;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (partialValue == null) {
            DataResult dataResult2 = DataResult.error(message);
            Intrinsics.checkNotNull(dataResult2);
            dataResult = dataResult2;
        } else {
            DataResult<T> dataResult3 = DataResult.error(message, partialValue);
            Intrinsics.checkNotNull(dataResult3);
            dataResult = dataResult3;
        }
        return dataResult;
    }

    public static /* synthetic */ DataResult error$default(String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return OmniDataResult.error(string, object);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> DataResult<T> error(@NotNull Function0<String> supplier, @Nullable T partialValue) {
        DataResult<Object> dataResult;
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        if (partialValue == null) {
            DataResult dataResult2 = DataResult.error((String)supplier.invoke());
            Intrinsics.checkNotNull(dataResult2);
            dataResult = dataResult2;
        } else {
            DataResult<T> dataResult3 = DataResult.error((String)supplier.invoke(), partialValue);
            Intrinsics.checkNotNull(dataResult3);
            dataResult = dataResult3;
        }
        return dataResult;
    }

    public static /* synthetic */ DataResult error$default(Function0 function0, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return OmniDataResult.error((Function0<String>)function0, object);
    }

    @JvmStatic
    @NotNull
    public static final <T> DataResult<T> ifSuccess(@NotNull DataResult<T> result, @NotNull Consumer<T> consumer) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        result.result().ifPresent(consumer);
        return result;
    }

    @JvmStatic
    @NotNull
    public static final <T> DataResult<T> ifError(@NotNull DataResult<T> result, @NotNull Consumer<DataResult.PartialResult<T>> consumer) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        result.error().ifPresent(consumer);
        return result;
    }

    @JvmStatic
    @NotNull
    public static final DataResult<int[]> decodeFixedLengthArray(@NotNull IntStream stream, int length) {
        DataResult<int[]> dataResult;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        int[] limitedStream = stream.limit((long)length + 1L).toArray();
        if (limitedStream.length != length) {
            String errorMessage = "Input is not a list of " + length + " ints";
            if (limitedStream.length >= length) {
                Intrinsics.checkNotNull((Object)limitedStream);
                int[] nArray = Arrays.copyOf(limitedStream, length);
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
                dataResult = OmniDataResult.error(errorMessage, nArray);
            } else {
                dataResult = OmniDataResult.error$default(errorMessage, null, 2, null);
            }
        } else {
            DataResult<int[]> dataResult2 = DataResult.success(limitedStream);
            Intrinsics.checkNotNull(dataResult2);
            dataResult = dataResult2;
        }
        return dataResult;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> DataResult<T> error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return OmniDataResult.error$default(message, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> DataResult<T> error(@NotNull Function0<String> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        return OmniDataResult.error$default(supplier, null, 2, null);
    }
}

