/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.server;

import dev.deftu.textile.TextFormat;
import dev.deftu.textile.minecraft.MCMutableTextHolder;
import dev.deftu.textile.minecraft.MCSimpleMutableTextHolder;
import dev.deftu.textile.minecraft.MCSimpleTextHolder;
import dev.deftu.textile.minecraft.MCTextFormat;
import dev.deftu.textile.minecraft.MCTextHolder;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u00020\f2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\r\u0010\u0011J)\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0012\b\u0002\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u0017\u001a\u00020\f2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u0015\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010!R\u0013\u0010%\u001a\u0004\u0018\u00010\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Ldev/deftu/omnicore/server/OmniServerCommandSource;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/command/ICommandSender;", "output", "Lnet/minecraft/world/WorldServer;", "world", "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;Lnet/minecraft/world/WorldServer;)V", "Ldev/deftu/textile/minecraft/MCTextHolder;", "textHolder", "", "displayMessage", "(Ldev/deftu/textile/minecraft/MCTextHolder;)V", "", "text", "(Ljava/lang/String;)V", "", "error", "Ljava/util/function/Consumer;", "Ldev/deftu/textile/minecraft/MCMutableTextHolder;", "block", "displayError", "(Ljava/lang/Throwable;Ljava/util/function/Consumer;)V", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "Lnet/minecraft/command/ICommandSender;", "getOutput", "()Lnet/minecraft/command/ICommandSender;", "Lnet/minecraft/world/WorldServer;", "getWorld", "()Lnet/minecraft/world/WorldServer;", "Lnet/minecraft/entity/player/EntityPlayerMP;", "getPlayer", "()Lnet/minecraft/entity/player/EntityPlayerMP;", "player", "Companion", "OmniCore"})
public final class OmniServerCommandSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final ICommandSender output;
    @NotNull
    private final WorldServer world;

    public OmniServerCommandSource(@NotNull MinecraftServer server, @NotNull ICommandSender output, @NotNull WorldServer world) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.server = server;
        this.output = output;
        this.world = world;
    }

    @NotNull
    public final MinecraftServer getServer() {
        return this.server;
    }

    @NotNull
    public final ICommandSender getOutput() {
        return this.output;
    }

    @NotNull
    public final WorldServer getWorld() {
        return this.world;
    }

    @Nullable
    public final EntityPlayerMP getPlayer() {
        ICommandSender iCommandSender = this.output;
        return iCommandSender instanceof EntityPlayerMP ? (EntityPlayerMP)iCommandSender : null;
    }

    public final void displayMessage(@NotNull MCTextHolder<?> textHolder) {
        Intrinsics.checkNotNullParameter(textHolder, (String)"textHolder");
        this.output.func_145747_a(textHolder.asVanilla());
    }

    public final void displayMessage(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.displayMessage((MCTextHolder)new MCSimpleTextHolder(text));
    }

    public final void displayError(@NotNull Throwable error, @NotNull Consumer<MCMutableTextHolder<?>> block) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String string = error.getMessage();
        if (string == null) {
            string = "An error occurred";
        }
        MCTextFormat[] mCTextFormatArray = new MCTextFormat[]{MCTextFormat.RED};
        MCSimpleMutableTextHolder text = (MCSimpleMutableTextHolder)new MCSimpleMutableTextHolder(string).addFormatting((TextFormat[])mCTextFormatArray);
        block.accept((MCMutableTextHolder<?>)text);
        this.displayMessage((MCTextHolder)text);
    }

    public static /* synthetic */ void displayError$default(OmniServerCommandSource omniServerCommandSource, Throwable throwable, Consumer consumer, int n, Object object) {
        if ((n & 2) != 0) {
            consumer = OmniServerCommandSource::displayError$lambda$0;
        }
        omniServerCommandSource.displayError(throwable, consumer);
    }

    public final void displayError(@NotNull MCTextHolder<?> textHolder) {
        Intrinsics.checkNotNullParameter(textHolder, (String)"textHolder");
        MCTextFormat[] mCTextFormatArray = new MCTextFormat[]{MCTextFormat.RED};
        this.displayMessage((MCTextHolder)textHolder.withFormatting((TextFormat[])mCTextFormatArray));
    }

    public final void displayError(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.displayError((MCTextHolder)new MCSimpleTextHolder(text));
    }

    private static final void displayError$lambda$0(MCMutableTextHolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    @JvmStatic
    @NotNull
    public static final OmniServerCommandSource from(@NotNull MinecraftServer server, @NotNull ICommandSender sender) {
        return Companion.from(server, sender);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/deftu/omnicore/server/OmniServerCommandSource$Companion;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/command/ICommandSender;", "sender", "Ldev/deftu/omnicore/server/OmniServerCommandSource;", "from", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;)Ldev/deftu/omnicore/server/OmniServerCommandSource;", "OmniCore"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OmniServerCommandSource from(@NotNull MinecraftServer server, @NotNull ICommandSender sender) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            World world = sender.func_130014_f_();
            Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type net.minecraft.world.WorldServer");
            return new OmniServerCommandSource(server, sender, (WorldServer)world);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

