/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.pipeline;

import dev.deftu.omnicore.client.render.pipeline.OmniRenderPass;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipeline;
import dev.deftu.omnicore.client.render.state.OmniManagedScissorState;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u0011J!\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\n\u0010\u0014\u001a\u00020\u0012\"\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\n\u0010\u0014\u001a\u00020\u0017\"\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0018J-\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u0018\u0010(\u001a\u0004\u0018\u00010'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;", "renderPass", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "pipeline", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "builtBuffer", "<init>", "(Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;)V", "", "name", "", "glId", "texture", "(Ljava/lang/String;I)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "index", "(II)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "", "values", "uniform", "(Ljava/lang/String;[F)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "(Ljava/lang/String;[I)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "x", "y", "width", "height", "enableScissor", "(IIII)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "disableScissor", "()Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "activate", "()V", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "Ldev/deftu/omnicore/client/render/state/OmniManagedScissorState;", "scissorState", "Ldev/deftu/omnicore/client/render/state/OmniManagedScissorState;", "OmniCore"})
public final class RenderPassBuilder {
    @NotNull
    private final OmniRenderPass renderPass;
    @NotNull
    private final OmniRenderPipeline pipeline;
    @NotNull
    private final OmniBuiltBuffer builtBuffer;
    @Nullable
    private OmniManagedScissorState scissorState;

    public RenderPassBuilder(@NotNull OmniRenderPass renderPass, @NotNull OmniRenderPipeline pipeline, @NotNull OmniBuiltBuffer builtBuffer) {
        Intrinsics.checkNotNullParameter((Object)renderPass, (String)"renderPass");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)builtBuffer, (String)"builtBuffer");
        this.renderPass = renderPass;
        this.pipeline = pipeline;
        this.builtBuffer = builtBuffer;
        this.pipeline.bind();
    }

    @NotNull
    public final RenderPassBuilder texture(@NotNull String name, int glId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.pipeline.texture(name, glId);
        return this;
    }

    @NotNull
    public final RenderPassBuilder texture(int index, int glId) {
        this.pipeline.texture(index, glId);
        return this;
    }

    @NotNull
    public final RenderPassBuilder uniform(@NotNull String name, float ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.pipeline.uniform(name, Arrays.copyOf(values, values.length));
        return this;
    }

    @NotNull
    public final RenderPassBuilder uniform(@NotNull String name, int ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.pipeline.uniform(name, Arrays.copyOf(values, values.length));
        return this;
    }

    @NotNull
    public final RenderPassBuilder enableScissor(int x, int y, int width, int height) {
        this.scissorState = OmniManagedScissorState.Companion.asEnabled(x, y, width, height);
        return this;
    }

    @NotNull
    public final RenderPassBuilder disableScissor() {
        this.scissorState = OmniManagedScissorState.DISABLED;
        return this;
    }

    public final void activate() {
        if (!Intrinsics.areEqual((Object)this.renderPass.getActivePipeline$OmniCore(), (Object)this.pipeline)) {
            this.renderPass.setActivePipeline$OmniCore(this.pipeline);
            this.pipeline.getActiveRenderState$OmniCore().apply(this.renderPass.getActiveRenderState$OmniCore());
        }
        OmniManagedScissorState previousScissorState = null;
        if (this.scissorState != null) {
            previousScissorState = OmniManagedScissorState.Companion.active();
            OmniManagedScissorState omniManagedScissorState = this.scissorState;
            if (omniManagedScissorState != null) {
                OmniManagedScissorState.activate$default(omniManagedScissorState, false, 1, null);
            }
        }
        this.pipeline.draw$OmniCore(this.builtBuffer);
        OmniManagedScissorState omniManagedScissorState = previousScissorState;
        if (omniManagedScissorState != null) {
            OmniManagedScissorState.activate$default(omniManagedScissorState, false, 1, null);
        }
        this.pipeline.unbind();
    }
}

