/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import dev.deftu.omnicore.client.render.OmniImageKt;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00060\u0001j\u0002`\u0002:\u0001*B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0012J\r\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001b\u0010\u001fJ\u000f\u0010 \u001a\u00020\rH\u0016\u00a2\u0006\u0004\b \u0010\u0017R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b$\u0010#R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Ldev/deftu/omnicore/client/render/OmniImage;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "width", "height", "<init>", "(II)V", "x", "y", "getPixel", "(II)I", "color", "", "setPixel", "(III)V", "level", "loadFromBoundTexture", "(I)V", "id", "prepareTexture", "uploadTexture", "flipX", "()V", "flipY", "Ljava/nio/file/Path;", "path", "saveTo", "(Ljava/nio/file/Path;)V", "Ljava/io/File;", "file", "(Ljava/io/File;)V", "close", "I", "getWidth", "()I", "getHeight", "Lcom/mojang/blaze3d/platform/NativeImage;", "native", "Lcom/mojang/blaze3d/platform/NativeImage;", "getNative", "()Lcom/mojang/blaze3d/platform/NativeImage;", "Companion", "OmniCore"})
public final class OmniImage
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final NativeImage native;

    public OmniImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.native = new NativeImage(this.width, this.height, false);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final NativeImage getNative() {
        return this.native;
    }

    public final int getPixel(int x, int y) {
        return this.native.m_84985_(x, y);
    }

    public final void setPixel(int x, int y, int color) {
        this.native.m_84988_(x, y, color);
    }

    @JvmOverloads
    public final void loadFromBoundTexture(int level) {
        this.native.m_85045_(level, false);
    }

    public static /* synthetic */ void loadFromBoundTexture$default(OmniImage omniImage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        omniImage.loadFromBoundTexture(n);
    }

    public final void prepareTexture(int id) {
        TextureUtil.prepareImage((int)id, (int)this.width, (int)this.height);
    }

    public final void uploadTexture(int id) {
        OmniTextureManager.Companion.configureTexture(id, () -> OmniImage.uploadTexture$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flipX() {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack memoryStack = (MemoryStack)autoCloseable;
            boolean bl = false;
            int channelCount = this.native.m_85102_().m_85161_();
            int rowSize = this.width * channelCount;
            long rowBuffer = memoryStack.nmalloc(rowSize);
            int n = this.width / 2;
            for (int k = 0; k < n; ++k) {
                int left = k;
                int right = this.width - 1 - k;
                int n2 = this.height;
                for (int i = 0; i < n2; ++i) {
                    int leftOffset = i * rowSize + left * channelCount;
                    int rightOffset = i * rowSize + right * channelCount;
                    MemoryUtil.memCopy((long)(OmniImageKt.getPointer(this.native) + (long)leftOffset), (long)rowBuffer, (long)rowSize);
                    MemoryUtil.memCopy((long)(OmniImageKt.getPointer(this.native) + (long)rightOffset), (long)(OmniImageKt.getPointer(this.native) + (long)leftOffset), (long)rowSize);
                    MemoryUtil.memCopy((long)rowBuffer, (long)(OmniImageKt.getPointer(this.native) + (long)rightOffset), (long)rowSize);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flipY() {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack memoryStack = (MemoryStack)autoCloseable;
            boolean bl = false;
            int channelCount = this.native.m_85102_().m_85161_();
            int rowSize = this.width * channelCount;
            long rowBuffer = memoryStack.nmalloc(rowSize);
            int n = this.height / 2;
            for (int i = 0; i < n; ++i) {
                int bottom = this.height - 1 - i;
                MemoryUtil.memCopy((long)(OmniImageKt.getPointer(this.native) + (long)(i * rowSize)), (long)rowBuffer, (long)rowSize);
                MemoryUtil.memCopy((long)(OmniImageKt.getPointer(this.native) + (long)(bottom * rowSize)), (long)(OmniImageKt.getPointer(this.native) + (long)(i * rowSize)), (long)rowSize);
                MemoryUtil.memCopy((long)rowBuffer, (long)(OmniImageKt.getPointer(this.native) + (long)(bottom * rowSize)), (long)rowSize);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void saveTo(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.native.m_85066_(path);
    }

    public final void saveTo(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.native.m_85056_(file);
    }

    @Override
    public void close() {
        this.native.close();
    }

    @JvmOverloads
    public final void loadFromBoundTexture() {
        OmniImage.loadFromBoundTexture$default(this, 0, 1, null);
    }

    private static final void uploadTexture$lambda$0(OmniImage this$0) {
        this$0.native.m_85040_(0, 0, 0, false);
    }

    @JvmStatic
    @NotNull
    public static final OmniImage from(@NotNull NativeImage nativeImage) {
        return Companion.from(nativeImage);
    }

    @JvmStatic
    @NotNull
    public static final OmniImage read(@NotNull Path path) {
        return Companion.read(path);
    }

    @JvmStatic
    @NotNull
    public static final OmniImage read(@NotNull File file) {
        return Companion.read(file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000b\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/deftu/omnicore/client/render/OmniImage$Companion;", "", "<init>", "()V", "Lcom/mojang/blaze3d/platform/NativeImage;", "native", "Ldev/deftu/omnicore/client/render/OmniImage;", "from", "(Lcom/mojang/blaze3d/platform/NativeImage;)Ldev/deftu/omnicore/client/render/OmniImage;", "Ljava/nio/file/Path;", "path", "read", "(Ljava/nio/file/Path;)Ldev/deftu/omnicore/client/render/OmniImage;", "Ljava/io/File;", "file", "(Ljava/io/File;)Ldev/deftu/omnicore/client/render/OmniImage;", "OmniCore"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OmniImage from(@NotNull NativeImage nativeImage) {
            OmniImage omniImage;
            Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"native");
            OmniImage $this$from_u24lambda_u240 = omniImage = new OmniImage(nativeImage.m_84982_(), nativeImage.m_85084_());
            boolean bl = false;
            $this$from_u24lambda_u240.getNative().m_85054_(nativeImage);
            return omniImage;
        }

        @JvmStatic
        @NotNull
        public final OmniImage read(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            byte[] data = Files.readAllBytes(path);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)inputStream);
            Intrinsics.checkNotNullExpressionValue((Object)nativeImage, (String)"read(...)");
            return this.from(nativeImage);
        }

        @JvmStatic
        @NotNull
        public final OmniImage read(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            byte[] data = FilesKt.readBytes((File)file);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)inputStream);
            Intrinsics.checkNotNullExpressionValue((Object)nativeImage, (String)"read(...)");
            return this.from(nativeImage);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

