/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.deftu.omnicore.common.OmniCommandBridge;
import dev.deftu.omnicore.common.OmniCommands;
import dev.deftu.omnicore.common.OmniProfiler;
import dev.deftu.omnicore.server.OmniServerCommandSource;
import dev.deftu.textile.minecraft.MCTextFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.FMLServerHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ7\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0012\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001c\u0010#\u001a\n \"*\u0004\u0018\u00010!0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Ldev/deftu/omnicore/server/OmniServerCommands;", "", "<init>", "()V", "", "initialize", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Ldev/deftu/omnicore/server/OmniServerCommandSource;", "command", "register", "(Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;)V", "", "name", "literal", "(Ljava/lang/String;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "T", "Lcom/mojang/brigadier/arguments/ArgumentType;", "type", "Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "argument", "(Ljava/lang/String;Lcom/mojang/brigadier/arguments/ArgumentType;)Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/command/ICommandSender;", "sender", "execute", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;Ljava/lang/String;)V", "", "retrieveAutoComplete", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/command/ICommandSender;Ljava/lang/String;)Ljava/util/List;", "", "isInitialized", "Z", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "Lcom/mojang/brigadier/CommandDispatcher;", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nOmniServerCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniServerCommands.kt\ndev/deftu/omnicore/server/OmniServerCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1557#2:190\n1628#2,3:191\n1557#2:194\n1628#2,3:195\n*S KotlinDebug\n*F\n+ 1 OmniServerCommands.kt\ndev/deftu/omnicore/server/OmniServerCommands\n*L\n166#1:190\n166#1:191,3\n167#1:194\n167#1:195,3\n*E\n"})
public final class OmniServerCommands {
    @NotNull
    public static final OmniServerCommands INSTANCE = new OmniServerCommands();
    private static boolean isInitialized;
    private static final Logger logger;
    @NotNull
    private static final CommandDispatcher<OmniServerCommandSource> dispatcher;

    private OmniServerCommands() {
    }

    @JvmStatic
    public static final void initialize() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
    }

    @JvmStatic
    public static final void register(@NotNull LiteralArgumentBuilder<OmniServerCommandSource> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        LiteralCommandNode<OmniServerCommandSource> node = dispatcher.register(command);
        MinecraftServer server = FMLServerHandler.instance().getServer();
        ICommandManager iCommandManager = server.field_71321_q;
        Intrinsics.checkNotNull((Object)iCommandManager, (String)"null cannot be cast to non-null type net.minecraft.command.ServerCommandManager");
        ServerCommandManager commandManager = (ServerCommandManager)iCommandManager;
        CommandNode commandNode = command.build();
        Intrinsics.checkNotNullExpressionValue((Object)commandNode, (String)"build(...)");
        commandManager.func_71560_a((ICommand)new OmniCommandBridge(commandNode, (Function2<? super ICommandSender, ? super String, Unit>)((Function2)(arg_0, arg_1) -> OmniServerCommands.register$lambda$0(server, arg_0, arg_1)), (Function2<? super ICommandSender, ? super String, ? extends List<String>>)((Function2)(arg_0, arg_1) -> OmniServerCommands.register$lambda$1(server, arg_0, arg_1))));
    }

    @JvmStatic
    @NotNull
    public static final LiteralArgumentBuilder<OmniServerCommandSource> literal(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LiteralArgumentBuilder<OmniServerCommandSource> literalArgumentBuilder = LiteralArgumentBuilder.literal(name);
        Intrinsics.checkNotNullExpressionValue(literalArgumentBuilder, (String)"literal(...)");
        return literalArgumentBuilder;
    }

    @JvmStatic
    @NotNull
    public static final <T> RequiredArgumentBuilder<OmniServerCommandSource, T> argument(@NotNull String name, @NotNull ArgumentType<T> type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument(name, type);
        Intrinsics.checkNotNullExpressionValue(requiredArgumentBuilder, (String)"argument(...)");
        return requiredArgumentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execute(MinecraftServer server, ICommandSender sender, String command) {
        OmniServerCommandSource context = OmniServerCommandSource.Companion.from(server, sender);
        ParseResults<OmniServerCommandSource> results = dispatcher.parse(command, context);
        OmniProfiler.start("omnicore_command___" + command);
        try {
            dispatcher.execute(results);
        }
        catch (CommandSyntaxException e) {
            CommandExceptionType commandExceptionType = e.getType();
            Intrinsics.checkNotNullExpressionValue((Object)commandExceptionType, (String)"getType(...)");
            boolean isIgnored = OmniCommands.isIgnoredException(commandExceptionType);
            String message = "Syntax exception for server-sided command '" + command + '\'';
            if (!isIgnored) {
                logger.warn(message, (Throwable)e);
                OmniServerCommandSource.displayError$default(context, e, null, 2, null);
            } else {
                logger.debug(message, (Throwable)e);
            }
        }
        finally {
            OmniProfiler.end();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> retrieveAutoComplete(MinecraftServer server, ICommandSender sender, String command) {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        OmniServerCommandSource context = OmniServerCommandSource.Companion.from(server, sender);
        ParseResults<OmniServerCommandSource> results = dispatcher.parse(command, context);
        List<Suggestion> list = dispatcher.getCompletionSuggestions(results).join().getList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Suggestion suggestion = (Suggestion)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$f$retrieveAutoComplete$stub_for_inlining = false;
            boolean bl = false;
            collection.add(((Suggestion)((Object)p0)).getText());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void text;
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MCTextFormat.GRAY.plus(StringsKt.contains$default((CharSequence)command, (CharSequence)" ", (boolean)false, (int)2, null) ? "" : "/") + (String)text + MCTextFormat.RESET);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private static final Unit register$lambda$0(MinecraftServer $server, ICommandSender sender, String command) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNull((Object)$server);
        INSTANCE.execute($server, sender, command);
        return Unit.INSTANCE;
    }

    private static final List register$lambda$1(MinecraftServer $server, ICommandSender sender, String command) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNull((Object)$server);
        return INSTANCE.retrieveAutoComplete($server, sender, command);
    }

    static {
        logger = LogManager.getLogger();
        dispatcher = new CommandDispatcher();
    }
}

