/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common.codecs;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.EitherMapCodec;
import dev.deftu.omnicore.common.OmniUuid;
import dev.deftu.omnicore.common.codecs.OmniCodecs;
import dev.deftu.omnicore.common.codecs.OmniDataResult;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0007\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0016\u0010\u0006\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ7\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\t\"\u0004\b\u0000\u0010\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012JC\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u0013\"\u0004\b\u0000\u0010\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u0013H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J=\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u0013\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\u0017\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010 R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010 R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010 R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010 R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010 R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010 R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010 \u00a8\u0006,"}, d2={"Ldev/deftu/omnicore/common/codecs/OmniCodecs;", "", "<init>", "()V", "T", "Lcom/mojang/datafixers/util/Either;", "either", "unwrapEither", "(Lcom/mojang/datafixers/util/Either;)Ljava/lang/Object;", "Lcom/mojang/serialization/Codec;", "primary", "alternative", "withAlternative", "(Lcom/mojang/serialization/Codec;Lcom/mojang/serialization/Codec;)Lcom/mojang/serialization/Codec;", "Ljava/time/format/DateTimeFormatter;", "formatter", "Ljava/time/temporal/TemporalAccessor;", "time", "(Ljava/time/format/DateTimeFormatter;)Lcom/mojang/serialization/Codec;", "Lcom/mojang/serialization/MapCodec;", "single", "", "list", "singleOrList", "(Lcom/mojang/serialization/MapCodec;Lcom/mojang/serialization/MapCodec;)Lcom/mojang/serialization/MapCodec;", "", "singleName", "listName", "element", "(Ljava/lang/String;Ljava/lang/String;Lcom/mojang/serialization/Codec;)Lcom/mojang/serialization/MapCodec;", "Ljava/util/UUID;", "UUID_INT_STREAM", "Lcom/mojang/serialization/Codec;", "Lnet/minecraft/resources/ResourceLocation;", "IDENTIFIER", "Ljava/util/regex/Pattern;", "PATTERN", "UUID_STRICT", "UUID_UNDASHED", "UUID_LENIENT", "Lnet/minecraft/core/BlockPos;", "BLOCK_POS", "Ljava/time/Instant;", "INSTANT", "OmniCore"})
public final class OmniCodecs {
    @NotNull
    public static final OmniCodecs INSTANCE = new OmniCodecs();
    @NotNull
    private static final Codec<UUID> UUID_INT_STREAM;
    @JvmField
    @NotNull
    public static final Codec<ResourceLocation> IDENTIFIER;
    @JvmField
    @NotNull
    public static final Codec<Pattern> PATTERN;
    @JvmField
    @NotNull
    public static final Codec<UUID> UUID_STRICT;
    @JvmField
    @NotNull
    public static final Codec<UUID> UUID_UNDASHED;
    @JvmField
    @NotNull
    public static final Codec<UUID> UUID_LENIENT;
    @JvmField
    @NotNull
    public static final Codec<BlockPos> BLOCK_POS;
    @JvmField
    @NotNull
    public static final Codec<Instant> INSTANT;

    private OmniCodecs() {
    }

    @JvmStatic
    public static final <T> T unwrapEither(@NotNull Either<? extends T, ? extends T> either) {
        Intrinsics.checkNotNullParameter(either, (String)"either");
        return (T)Either.unwrap(either);
    }

    @JvmStatic
    @NotNull
    public static final <T> Codec<T> withAlternative(@NotNull Codec<T> primary, @NotNull Codec<T> alternative) {
        Intrinsics.checkNotNullParameter(primary, (String)"primary");
        Intrinsics.checkNotNullParameter(alternative, (String)"alternative");
        Codec codec = Codec.withAlternative(primary, alternative);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"withAlternative(...)");
        return codec;
    }

    @JvmStatic
    @NotNull
    public static final Codec<TemporalAccessor> time(@NotNull DateTimeFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        Codec codec = Codec.STRING.comapFlatMap(arg_0 -> OmniCodecs.time$lambda$16(arg_0 -> OmniCodecs.time$lambda$15(formatter, arg_0), arg_0), arg_0 -> OmniCodecs.time$lambda$17((Function1)new Function1<TemporalAccessor, String>((Object)formatter){

            public final String invoke(TemporalAccessor p0) {
                return ((DateTimeFormatter)this.receiver).format(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"comapFlatMap(...)");
        return codec;
    }

    @JvmStatic
    @NotNull
    public static final <T> MapCodec<List<T>> singleOrList(@NotNull MapCodec<T> single, @NotNull MapCodec<List<T>> list) {
        Intrinsics.checkNotNullParameter(single, (String)"single");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        MapCodec mapCodec = new EitherMapCodec(list, single).xmap(arg_0 -> OmniCodecs.singleOrList$lambda$23(OmniCodecs::singleOrList$lambda$22, arg_0), arg_0 -> OmniCodecs.singleOrList$lambda$25(OmniCodecs::singleOrList$lambda$24, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"xmap(...)");
        return mapCodec;
    }

    @NotNull
    public final <T> MapCodec<List<T>> singleOrList(@NotNull String singleName, @NotNull String listName, @NotNull Codec<T> element) {
        Intrinsics.checkNotNullParameter((Object)singleName, (String)"singleName");
        Intrinsics.checkNotNullParameter((Object)listName, (String)"listName");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        MapCodec mapCodec = element.fieldOf(singleName);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"fieldOf(...)");
        MapCodec mapCodec2 = element.listOf().fieldOf(listName);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec2, (String)"fieldOf(...)");
        return OmniCodecs.singleOrList(mapCodec, mapCodec2);
    }

    private static final UUID UUID_INT_STREAM$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        return (UUID)$tmp0.invoke(p0);
    }

    private static final DataResult UUID_INT_STREAM$lambda$1(IntStream stream) {
        Intrinsics.checkNotNull((Object)stream);
        return OmniDataResult.decodeFixedLengthArray(stream, 4).map(arg_0 -> OmniCodecs.UUID_INT_STREAM$lambda$1$lambda$0((Function1)new Function1<int[], UUID>((Object)OmniUuid.INSTANCE){

            public final UUID invoke(int[] p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OmniUuid.fromIntArray(p0);
            }
        }, arg_0));
    }

    private static final DataResult UUID_INT_STREAM$lambda$2(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final IntStream UUID_INT_STREAM$lambda$3(UUID uuid) {
        Intrinsics.checkNotNull((Object)uuid);
        return Arrays.stream(OmniUuid.toIntArray(uuid));
    }

    private static final IntStream UUID_INT_STREAM$lambda$4(Function1 $tmp0, Object p0) {
        return (IntStream)$tmp0.invoke(p0);
    }

    private static final DataResult PATTERN$lambda$5(String string) {
        DataResult dataResult;
        try {
            dataResult = DataResult.success((Object)Pattern.compile(string));
        }
        catch (Exception e) {
            dataResult = OmniDataResult.error$default("Invalid regex pattern " + string + ": " + e.getMessage(), null, 2, null);
        }
        return dataResult;
    }

    private static final DataResult PATTERN$lambda$6(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final String PATTERN$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final DataResult UUID_STRICT$lambda$8(String string) {
        DataResult dataResult;
        try {
            dataResult = DataResult.success((Object)UUID.fromString(string));
        }
        catch (Exception e) {
            dataResult = OmniDataResult.error$default("Invalid UUID " + string + ": " + e.getMessage(), null, 2, null);
        }
        return dataResult;
    }

    private static final DataResult UUID_STRICT$lambda$9(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final String UUID_STRICT$lambda$10(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final DataResult UUID_UNDASHED$lambda$11(String string) {
        DataResult dataResult;
        try {
            Intrinsics.checkNotNull((Object)string);
            dataResult = DataResult.success((Object)OmniUuid.fromUndashed(string));
        }
        catch (Exception e) {
            dataResult = OmniDataResult.error$default("Invalid UUID " + string + ": " + e.getMessage(), null, 2, null);
        }
        return dataResult;
    }

    private static final DataResult UUID_UNDASHED$lambda$12(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final String UUID_UNDASHED$lambda$13(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Instant INSTANT$lambda$14(Function1 $tmp0, Object p0) {
        return (Instant)$tmp0.invoke(p0);
    }

    private static final DataResult time$lambda$15(DateTimeFormatter $formatter, String string) {
        DataResult dataResult;
        try {
            dataResult = DataResult.success((Object)$formatter.parse(string));
        }
        catch (Exception e) {
            dataResult = OmniDataResult.error$default((Function0)new PropertyReference0Impl(e){

                public Object get() {
                    return ((Exception)this.receiver).getMessage();
                }
            }, null, 2, null);
        }
        return dataResult;
    }

    private static final DataResult time$lambda$16(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final String time$lambda$17(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final List singleOrList$lambda$22$lambda$18(List it) {
        return it;
    }

    private static final List singleOrList$lambda$22$lambda$19(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List singleOrList$lambda$22$lambda$20(Object it) {
        return CollectionsKt.listOf((Object)it);
    }

    private static final List singleOrList$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List singleOrList$lambda$22(Either e) {
        return (List)e.map(arg_0 -> OmniCodecs.singleOrList$lambda$22$lambda$19(OmniCodecs::singleOrList$lambda$22$lambda$18, arg_0), arg_0 -> OmniCodecs.singleOrList$lambda$22$lambda$21(OmniCodecs::singleOrList$lambda$22$lambda$20, arg_0));
    }

    private static final List singleOrList$lambda$23(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Either singleOrList$lambda$24(List xs) {
        return xs.size() == 1 ? Either.right(xs.get(0)) : Either.left((Object)xs);
    }

    private static final Either singleOrList$lambda$25(Function1 $tmp0, Object p0) {
        return (Either)$tmp0.invoke(p0);
    }

    static {
        Codec codec = Codec.INT_STREAM.comapFlatMap(arg_0 -> OmniCodecs.UUID_INT_STREAM$lambda$2(OmniCodecs::UUID_INT_STREAM$lambda$1, arg_0), arg_0 -> OmniCodecs.UUID_INT_STREAM$lambda$4(OmniCodecs::UUID_INT_STREAM$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"comapFlatMap(...)");
        UUID_INT_STREAM = codec;
        Codec codec2 = ResourceLocation.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"CODEC");
        IDENTIFIER = codec2;
        codec = Codec.STRING.comapFlatMap(arg_0 -> OmniCodecs.PATTERN$lambda$6(OmniCodecs::PATTERN$lambda$5, arg_0), arg_0 -> OmniCodecs.PATTERN$lambda$7(PATTERN.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"comapFlatMap(...)");
        PATTERN = codec;
        codec = Codec.STRING.comapFlatMap(arg_0 -> OmniCodecs.UUID_STRICT$lambda$9(OmniCodecs::UUID_STRICT$lambda$8, arg_0), arg_0 -> OmniCodecs.UUID_STRICT$lambda$10(UUID_STRICT.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"comapFlatMap(...)");
        UUID_STRICT = OmniCodecs.withAlternative(codec, UUID_INT_STREAM);
        codec = Codec.STRING.comapFlatMap(arg_0 -> OmniCodecs.UUID_UNDASHED$lambda$12(OmniCodecs::UUID_UNDASHED$lambda$11, arg_0), arg_0 -> OmniCodecs.UUID_UNDASHED$lambda$13((Function1)new Function1<UUID, String>((Object)OmniUuid.INSTANCE){

            public final String invoke(UUID p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OmniUuid.toUndashed(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"comapFlatMap(...)");
        UUID_UNDASHED = OmniCodecs.withAlternative(codec, UUID_INT_STREAM);
        UUID_LENIENT = OmniCodecs.withAlternative(UUID_STRICT, UUID_UNDASHED);
        Codec codec3 = BlockPos.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec3, (String)"CODEC");
        BLOCK_POS = codec3;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ISO_INSTANT");
        Codec codec4 = OmniCodecs.time(dateTimeFormatter).xmap(arg_0 -> OmniCodecs.INSTANT$lambda$14(INSTANT.1.INSTANCE, arg_0), Function.identity());
        Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"xmap(...)");
        INSTANT = codec4;
    }
}

