/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.deftu.omnicore.client.OmniClientCommandSource;
import dev.deftu.omnicore.common.OmniCommands;
import dev.deftu.omnicore.common.OmniProfiler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\t\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0007\u00a2\u0006\u0004\b\t\u0010\rJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0015\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u001c\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010 \u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u000eH\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001c\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Ldev/deftu/omnicore/client/OmniClientCommands;", "", "<init>", "()V", "", "initialize", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Ldev/deftu/omnicore/client/OmniClientCommandSource;", "node", "register", "(Lcom/mojang/brigadier/tree/LiteralCommandNode;)V", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "command", "(Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;)V", "", "name", "literal", "(Ljava/lang/String;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "T", "Lcom/mojang/brigadier/arguments/ArgumentType;", "type", "Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "argument", "(Ljava/lang/String;Lcom/mojang/brigadier/arguments/ArgumentType;)Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "Lcom/mojang/brigadier/CommandDispatcher;", "targetDispatcher", "copyClientCommands$OmniCore", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "copyClientCommands", "", "execute$OmniCore", "(Ljava/lang/String;)Z", "execute", "isInitialized", "Z", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "OmniCore"})
public final class OmniClientCommands {
    @NotNull
    public static final OmniClientCommands INSTANCE = new OmniClientCommands();
    private static boolean isInitialized;
    private static final Logger logger;
    @NotNull
    private static final CommandDispatcher<OmniClientCommandSource> dispatcher;

    private OmniClientCommands() {
    }

    @JvmStatic
    public static final void initialize() {
        if (isInitialized) {
            return;
        }
        NeoForge.EVENT_BUS.addListener(OmniClientCommands::initialize$lambda$0);
        isInitialized = true;
    }

    @JvmStatic
    public static final void register(@NotNull LiteralCommandNode<OmniClientCommandSource> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        dispatcher.getRoot().addChild((CommandNode)node);
    }

    @JvmStatic
    public static final void register(@NotNull LiteralArgumentBuilder<OmniClientCommandSource> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        LiteralCommandNode literalCommandNode = command.build();
        Intrinsics.checkNotNullExpressionValue((Object)literalCommandNode, (String)"build(...)");
        OmniClientCommands.register((LiteralCommandNode<OmniClientCommandSource>)literalCommandNode);
    }

    @JvmStatic
    @NotNull
    public static final LiteralArgumentBuilder<OmniClientCommandSource> literal(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LiteralArgumentBuilder literalArgumentBuilder = LiteralArgumentBuilder.literal((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        return literalArgumentBuilder;
    }

    @JvmStatic
    @NotNull
    public static final <T> RequiredArgumentBuilder<OmniClientCommandSource, T> argument(@NotNull String name, @NotNull ArgumentType<T> type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)name, type);
        Intrinsics.checkNotNullExpressionValue((Object)requiredArgumentBuilder, (String)"argument(...)");
        return requiredArgumentBuilder;
    }

    @JvmStatic
    public static final <T> void copyClientCommands$OmniCore(@NotNull CommandDispatcher<T> targetDispatcher) {
        Intrinsics.checkNotNullParameter(targetDispatcher, (String)"targetDispatcher");
        OmniCommands.copyCommands(targetDispatcher, dispatcher, OmniClientCommandSource.UNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean execute$OmniCore(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        ParseResults results = dispatcher.parse(command, (Object)OmniClientCommandSource.UNIT);
        OmniProfiler.start("omnicore_command___" + command);
        try {
            dispatcher.execute(results);
            boolean bl = true;
            return bl;
        }
        catch (CommandSyntaxException e) {
            CommandExceptionType commandExceptionType = e.getType();
            Intrinsics.checkNotNullExpressionValue((Object)commandExceptionType, (String)"getType(...)");
            boolean isIgnored = OmniCommands.isIgnoredException(commandExceptionType);
            String message = "Syntax exception for client-sided command '" + command + "'";
            if (!isIgnored) {
                logger.warn(message, (Throwable)e);
                OmniClientCommandSource.displayError$default(OmniClientCommandSource.UNIT, e, null, 2, null);
            } else {
                logger.debug(message, (Throwable)e);
            }
            boolean bl = !isIgnored;
            return bl;
        }
        finally {
            OmniProfiler.end();
        }
    }

    private static final void initialize$lambda$0(RegisterClientCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        OmniClientCommands.copyClientCommands$OmniCore(commandDispatcher);
    }

    static {
        logger = LogManager.getLogger();
        dispatcher = new CommandDispatcher();
    }
}

