/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.pipeline;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.pipeline.DefaultShaders;
import dev.deftu.omnicore.client.render.pipeline.DrawModes;
import dev.deftu.omnicore.client.render.pipeline.LegacyShaderSource;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipelineBuilder;
import dev.deftu.omnicore.client.render.pipeline.ShaderSource;
import dev.deftu.omnicore.client.render.pipeline.VanillaShaderSource;
import dev.deftu.omnicore.client.render.pipeline.VertexFormats;
import dev.deftu.omnicore.client.render.state.OmniManagedRenderState;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import dev.deftu.omnicore.client.shaders.IntUniform;
import dev.deftu.omnicore.client.shaders.MatrixUniform;
import dev.deftu.omnicore.client.shaders.OmniShader;
import dev.deftu.omnicore.client.shaders.SamplerUniform;
import dev.deftu.omnicore.client.shaders.Vec2Uniform;
import dev.deftu.omnicore.client.shaders.Vec3Uniform;
import dev.deftu.omnicore.client.shaders.Vec4Uniform;
import dev.deftu.omnicore.client.shaders.VecUniform;
import java.util.Arrays;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0010\u0018\u0000 32\u00020\u0001:\u00013B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u001d\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001eJ!\u0010\"\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00172\n\u0010!\u001a\u00020\u001f\"\u00020 \u00a2\u0006\u0004\b\"\u0010#J!\u0010\"\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00172\n\u0010!\u001a\u00020$\"\u00020\u0019\u00a2\u0006\u0004\b\"\u0010%R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010,\u001a\u0004\b-\u0010.R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010/R\u001a\u0010\u000b\u001a\u00020\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u000b\u00100\u001a\u0004\b1\u00102\u00a8\u00064"}, d2={"Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "vertexFormat", "Ldev/deftu/omnicore/client/render/pipeline/DrawModes;", "mode", "Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;", "shaderSource", "Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;", "activeRenderState", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;)V", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "builtBuffer", "", "draw$OmniCore", "(Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;)V", "draw", "bind", "()V", "unbind", "", "name", "", "glId", "texture", "(Ljava/lang/String;I)V", "index", "(II)V", "", "", "values", "uniform", "(Ljava/lang/String;[F)V", "", "(Ljava/lang/String;[I)V", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "getVertexFormat", "()Lcom/mojang/blaze3d/vertex/VertexFormat;", "Ldev/deftu/omnicore/client/render/pipeline/DrawModes;", "getMode", "()Ldev/deftu/omnicore/client/render/pipeline/DrawModes;", "Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;", "Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;", "getActiveRenderState$OmniCore", "()Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;", "Companion", "OmniCore"})
public final class OmniRenderPipeline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation identifier;
    @NotNull
    private final VertexFormat vertexFormat;
    @NotNull
    private final DrawModes mode;
    @Nullable
    private final ShaderSource shaderSource;
    @NotNull
    private final OmniManagedRenderState activeRenderState;

    public OmniRenderPipeline(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @Nullable ShaderSource shaderSource, @NotNull OmniManagedRenderState activeRenderState) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)activeRenderState, (String)"activeRenderState");
        this.identifier = identifier;
        this.vertexFormat = vertexFormat;
        this.mode = mode;
        this.shaderSource = shaderSource;
        this.activeRenderState = activeRenderState;
    }

    @NotNull
    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @NotNull
    public final DrawModes getMode() {
        return this.mode;
    }

    @NotNull
    public final OmniManagedRenderState getActiveRenderState$OmniCore() {
        return this.activeRenderState;
    }

    public final void draw$OmniCore(@NotNull OmniBuiltBuffer builtBuffer) {
        Intrinsics.checkNotNullParameter((Object)builtBuffer, (String)"builtBuffer");
        BufferBuilder.RenderedBuffer vanillaBuiltBuffer = builtBuffer.getVanilla();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)vanillaBuiltBuffer);
        builtBuffer.forceClose();
    }

    public final void bind() {
        block0: {
            ShaderSource shaderSource = this.shaderSource;
            if (shaderSource == null) break block0;
            shaderSource.bind(this.activeRenderState.getBlendState());
        }
    }

    public final void unbind() {
        block0: {
            ShaderSource shaderSource = this.shaderSource;
            if (shaderSource == null) break block0;
            shaderSource.unbind();
        }
    }

    public final void texture(@NotNull String name, int glId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShaderSource shaderSource = this.shaderSource;
        if (shaderSource instanceof LegacyShaderSource) {
            SamplerUniform samplerUniform = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore().getSamplerUniformOrNull(name);
            if (samplerUniform != null) {
                samplerUniform.setValue(glId);
            }
        } else {
            if (shaderSource instanceof VanillaShaderSource) {
                Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)name, (CharSequence)"Sampler"));
                if (n == null) {
                    return;
                }
                int index = n;
                RenderSystem.setShaderTexture((int)index, (int)glId);
                return;
            }
            throw new IllegalArgumentException("Invalid shader source type");
        }
    }

    public final void texture(int index, int glId) {
        ShaderSource shaderSource = this.shaderSource;
        if (shaderSource instanceof LegacyShaderSource) {
            SamplerUniform samplerUniform = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore().getSamplerUniformOrNull("Sampler" + index);
            if (samplerUniform != null) {
                samplerUniform.setValue(glId);
            }
        } else if (shaderSource instanceof VanillaShaderSource) {
            RenderSystem.setShaderTexture((int)index, (int)glId);
        } else {
            OmniTextureManager.Companion.bindTexture(index, glId);
        }
    }

    public final void uniform(@NotNull String name, float ... values) {
        block16: {
            ShaderSource shaderSource;
            block15: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                shaderSource = this.shaderSource;
                if (!(shaderSource instanceof LegacyShaderSource)) break block15;
                OmniShader shader = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore();
                switch (values.length) {
                    case 1: {
                        VecUniform vecUniform = shader.getVecUniformOrNull(name);
                        if (vecUniform != null) {
                            vecUniform.setValue(values[0]);
                        }
                        break block16;
                    }
                    case 2: {
                        Vec2Uniform vec2Uniform = shader.getVec2UniformOrNull(name);
                        if (vec2Uniform != null) {
                            vec2Uniform.setValue(values[0], values[1]);
                        }
                        break block16;
                    }
                    case 3: {
                        Vec3Uniform vec3Uniform = shader.getVec3UniformOrNull(name);
                        if (vec3Uniform != null) {
                            vec3Uniform.setValue(values[0], values[1], values[2]);
                        }
                        break block16;
                    }
                    case 4: {
                        Vec4Uniform vec4Uniform = shader.getVec4UniformOrNull(name);
                        if (vec4Uniform != null) {
                            vec4Uniform.setValue(values[0], values[1], values[2], values[3]);
                        }
                        break block16;
                    }
                    case 9: 
                    case 16: {
                        MatrixUniform matrixUniform = shader.getMatrixUniformOrNull(name);
                        if (matrixUniform != null) {
                            matrixUniform.setValue(values);
                        }
                        break block16;
                    }
                    default: {
                        String string = Arrays.toString(values);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        throw new UnsupportedOperationException("Provides too many values when defining a uniform: " + string);
                    }
                }
            }
            if (shaderSource instanceof VanillaShaderSource) {
                Uniform uniform = ((VanillaShaderSource)this.shaderSource).getSupplier().get().getUniform(name);
                if (uniform != null) {
                    uniform.set(values);
                }
            } else {
                throw new IllegalArgumentException("Invalid shader source type");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void uniform(@NotNull String name, int ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        ShaderSource shaderSource = this.shaderSource;
        if (!(shaderSource instanceof LegacyShaderSource)) {
            if (!(shaderSource instanceof VanillaShaderSource)) throw new IllegalArgumentException("Invalid shader source type");
            Uniform uniform = ((VanillaShaderSource)this.shaderSource).getSupplier().get().getUniform(name);
            if (uniform == null) return;
            uniform.set(values[0]);
            return;
        }
        OmniShader shader = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore();
        if (values.length == 1) {
            IntUniform intUniform = shader.getIntUniformOrNull(name);
            if (intUniform == null) return;
            intUniform.setValue(values[0]);
            return;
        }
        String string = Arrays.toString(values);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        throw new UnsupportedOperationException("Provides too many values when defining a uniform: " + string);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builder(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @Nullable Supplier<ShaderInstance> shader) {
        return Companion.builder(identifier, vertexFormat, mode, shader);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode) {
        return Companion.builderWithDefaultShader(identifier, vertexFormat, mode);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode) {
        return Companion.builderWithDefaultShader(identifier, vertexFormat, mode);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
        return Companion.builderWithLegacyShader(identifier, vertexFormat, mode, vertexSource, fragmentSource);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
        return Companion.builderWithLegacyShader(identifier, vertexFormat, mode, vertexSource, fragmentSource);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0013J7\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J7\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "vertexFormat", "Ldev/deftu/omnicore/client/render/pipeline/DrawModes;", "mode", "Ljava/util/function/Supplier;", "Lnet/minecraft/client/renderer/ShaderInstance;", "shader", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "builder", "(Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;Ljava/util/function/Supplier;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "builderWithDefaultShader", "(Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "Ldev/deftu/omnicore/client/render/pipeline/VertexFormats;", "(Lnet/minecraft/resources/ResourceLocation;Ldev/deftu/omnicore/client/render/pipeline/VertexFormats;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "", "vertexSource", "fragmentSource", "builderWithLegacyShader", "(Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;Ljava/lang/String;Ljava/lang/String;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "(Lnet/minecraft/resources/ResourceLocation;Ldev/deftu/omnicore/client/render/pipeline/VertexFormats;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;Ljava/lang/String;Ljava/lang/String;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "OmniCore"})
    @SourceDebugExtension(value={"SMAP\nOmniRenderPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniRenderPipeline.kt\ndev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1#2:287\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builder(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @Nullable Supplier<ShaderInstance> shader) {
            VanillaShaderSource vanillaShaderSource;
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            ResourceLocation resourceLocation = identifier;
            VertexFormat vertexFormat2 = vertexFormat;
            DrawModes drawModes = mode;
            Supplier<ShaderInstance> supplier = shader;
            if (supplier != null) {
                void p0;
                Supplier<ShaderInstance> supplier2 = supplier;
                DrawModes drawModes2 = drawModes;
                VertexFormat vertexFormat3 = vertexFormat2;
                ResourceLocation resourceLocation2 = resourceLocation;
                boolean $i$f$builder$stub_for_inlining = false;
                boolean bl = false;
                VanillaShaderSource vanillaShaderSource2 = new VanillaShaderSource((Supplier<ShaderInstance>)p0);
                resourceLocation = resourceLocation2;
                vertexFormat2 = vertexFormat3;
                drawModes = drawModes2;
                vanillaShaderSource = vanillaShaderSource2;
            } else {
                vanillaShaderSource = null;
            }
            ShaderSource shaderSource = vanillaShaderSource;
            DrawModes drawModes3 = drawModes;
            VertexFormat vertexFormat4 = vertexFormat2;
            ResourceLocation resourceLocation3 = resourceLocation;
            return new OmniRenderPipelineBuilder(resourceLocation3, vertexFormat4, drawModes3, shaderSource);
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Supplier<ShaderInstance> shader = DefaultShaders.get(vertexFormat);
            return this.builder(identifier, vertexFormat, mode, shader);
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)((Object)vertexFormat), (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            return this.builderWithDefaultShader(identifier, vertexFormat.getVanilla(), mode);
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)vertexSource, (String)"vertexSource");
            Intrinsics.checkNotNullParameter((Object)fragmentSource, (String)"fragmentSource");
            return new OmniRenderPipelineBuilder(identifier, vertexFormat, mode, new LegacyShaderSource(vertexFormat, vertexSource, fragmentSource));
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)((Object)vertexFormat), (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)vertexSource, (String)"vertexSource");
            Intrinsics.checkNotNullParameter((Object)fragmentSource, (String)"fragmentSource");
            return this.builderWithLegacyShader(identifier, vertexFormat.getVanilla(), mode, vertexSource, fragmentSource);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

