/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.pipeline;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.deftu.omnicore.client.OmniClient;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPass;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipeline;
import dev.deftu.omnicore.client.render.state.OmniManagedScissorState;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_276;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u0011J!\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\n\u0010\u0014\u001a\u00020\u0012\"\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\n\u0010\u0014\u001a\u00020\u0017\"\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0018J-\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u001a\u0010(\u001a\u00020'8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0018\u0010-\u001a\u0004\u0018\u00010,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;", "renderPass", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "pipeline", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "builtBuffer", "<init>", "(Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;)V", "", "name", "", "glId", "texture", "(Ljava/lang/String;I)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "index", "(II)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "", "values", "uniform", "(Ljava/lang/String;[F)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "(Ljava/lang/String;[I)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "x", "y", "width", "height", "enableScissor", "(IIII)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "disableScissor", "()Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "activate", "()V", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "Lcom/mojang/blaze3d/systems/RenderPass;", "vanilla", "Lcom/mojang/blaze3d/systems/RenderPass;", "getVanilla$OmniCore", "()Lcom/mojang/blaze3d/systems/RenderPass;", "Ldev/deftu/omnicore/client/render/state/OmniManagedScissorState;", "scissorState", "Ldev/deftu/omnicore/client/render/state/OmniManagedScissorState;", "OmniCore"})
public final class RenderPassBuilder {
    @NotNull
    private final OmniRenderPass renderPass;
    @NotNull
    private final OmniRenderPipeline pipeline;
    @NotNull
    private final OmniBuiltBuffer builtBuffer;
    @NotNull
    private final RenderPass vanilla;
    @Nullable
    private OmniManagedScissorState scissorState;

    /*
     * WARNING - void declaration
     */
    public RenderPassBuilder(@NotNull OmniRenderPass renderPass, @NotNull OmniRenderPipeline pipeline, @NotNull OmniBuiltBuffer builtBuffer) {
        void $this$_init__u24lambda_u240;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)renderPass, (String)"renderPass");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)builtBuffer, (String)"builtBuffer");
        this.renderPass = renderPass;
        this.pipeline = pipeline;
        this.builtBuffer = builtBuffer;
        class_9801 builtBuffer2 = this.builtBuffer.getVanilla();
        GpuBuffer vertexBuffer = this.pipeline.getVertexFormat().uploadImmediateVertexBuffer(builtBuffer2.method_60818());
        ByteBuffer indexBuffer = builtBuffer2.method_60821();
        if (indexBuffer == null) {
            RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)builtBuffer2.method_60822().comp_752());
            pair = TuplesKt.to((Object)shapeIndexBuffer.method_68274(builtBuffer2.method_60822().comp_751()), (Object)shapeIndexBuffer.method_31924());
        } else {
            pair = TuplesKt.to((Object)this.pipeline.getVertexFormat().uploadImmediateIndexBuffer(indexBuffer), (Object)builtBuffer2.method_60822().comp_753());
        }
        Pair pair2 = pair;
        GpuBuffer uploadedIndexBuffer = (GpuBuffer)pair2.component1();
        VertexFormat.class_5595 indexType = (VertexFormat.class_5595)pair2.component2();
        class_276 class_2762 = OmniClient.getInstance().method_1522();
        RenderPassBuilder renderPassBuilder = this;
        boolean bl = false;
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        GpuTexture gpuTexture = $this$_init__u24lambda_u240.method_30277();
        Intrinsics.checkNotNull((Object)gpuTexture);
        RenderPass renderPass2 = commandEncoder.createRenderPass(gpuTexture, OptionalInt.empty(), $this$_init__u24lambda_u240.method_30278(), OptionalDouble.empty());
        Intrinsics.checkNotNullExpressionValue((Object)renderPass2, (String)"with(...)");
        renderPassBuilder.vanilla = renderPass2;
        this.vanilla.setVertexBuffer(0, vertexBuffer);
        this.vanilla.setIndexBuffer(uploadedIndexBuffer, indexType);
    }

    @NotNull
    public final RenderPass getVanilla$OmniCore() {
        return this.vanilla;
    }

    @NotNull
    public final RenderPassBuilder texture(@NotNull String name, int glId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.vanilla.bindSampler(name, (GpuTexture)new OmniTextureManager.VanillaWrappedGlTexture(glId));
        return this;
    }

    @NotNull
    public final RenderPassBuilder texture(int index, int glId) {
        String samplerName = (String)this.pipeline.getVanilla().getSamplers().get(index);
        Intrinsics.checkNotNull((Object)samplerName);
        this.texture(samplerName, glId);
        return this;
    }

    @NotNull
    public final RenderPassBuilder uniform(@NotNull String name, float ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.vanilla.setUniform(name, Arrays.copyOf(values, values.length));
        return this;
    }

    @NotNull
    public final RenderPassBuilder uniform(@NotNull String name, int ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.vanilla.setUniform(name, Arrays.copyOf(values, values.length));
        return this;
    }

    @NotNull
    public final RenderPassBuilder enableScissor(int x, int y, int width, int height) {
        this.scissorState = OmniManagedScissorState.Companion.asEnabled(x, y, width, height);
        return this;
    }

    @NotNull
    public final RenderPassBuilder disableScissor() {
        this.scissorState = OmniManagedScissorState.DISABLED;
        return this;
    }

    public final void activate() {
        OmniManagedScissorState omniManagedScissorState = this.scissorState;
        if (omniManagedScissorState == null) {
            omniManagedScissorState = OmniManagedScissorState.Companion.active();
        }
        OmniManagedScissorState scissorState = omniManagedScissorState;
        scissorState.applyTo(this.vanilla);
        this.pipeline.draw$OmniCore(this.vanilla, this.builtBuffer.getVanilla());
        this.vanilla.close();
    }
}

