/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common.resources;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/deftu/omnicore/common/resources/OmniResourceManager;", "", "<init>", "()V", "Lnet/minecraft/resources/IResourceManager;", "resourceManager", "Lnet/minecraft/util/ResourceLocation;", "identifier", "Ljava/util/Optional;", "Lnet/minecraft/resources/IResource;", "findFirst", "(Lnet/minecraft/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;)Ljava/util/Optional;", "findFirstOrThrow", "(Lnet/minecraft/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/resources/IResource;", "", "findAll", "(Lnet/minecraft/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;)Ljava/util/List;", "OmniCore"})
public final class OmniResourceManager {
    @NotNull
    public static final OmniResourceManager INSTANCE = new OmniResourceManager();

    private OmniResourceManager() {
    }

    @JvmStatic
    @NotNull
    public static final Optional<IResource> findFirst(@NotNull IResourceManager resourceManager, @NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        try {
            Optional<IResource> optional = Optional.ofNullable(resourceManager.func_199002_a(identifier));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }
        catch (Exception e) {
            Optional<IResource> optional = Optional.empty();
            return optional;
        }
    }

    @JvmStatic
    @NotNull
    public static final IResource findFirstOrThrow(@NotNull IResourceManager resourceManager, @NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        IResource iResource = resourceManager.func_199002_a(identifier);
        if (iResource == null) {
            throw new IllegalArgumentException("Resource not found: " + identifier);
        }
        return iResource;
    }

    @JvmStatic
    @NotNull
    public static final List<IResource> findAll(@NotNull IResourceManager resourceManager, @NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        List list = resourceManager.func_199004_b(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResources(...)");
        return CollectionsKt.toList((Iterable)list);
    }
}

