/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.shaders;

import dev.deftu.omnicore.client.shaders.IntUniform;
import dev.deftu.omnicore.client.shaders.MatrixUniform;
import dev.deftu.omnicore.client.shaders.OmniShader;
import dev.deftu.omnicore.client.shaders.ShaderUniform;
import dev.deftu.omnicore.client.shaders.Vec2Uniform;
import dev.deftu.omnicore.client.shaders.Vec3Uniform;
import dev.deftu.omnicore.client.shaders.Vec4Uniform;
import dev.deftu.omnicore.client.shaders.VecUniform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0013J'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0015J/\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0017J\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u001aR\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Ldev/deftu/omnicore/client/shaders/DirectUniform;", "Ldev/deftu/omnicore/client/shaders/ShaderUniform;", "Ldev/deftu/omnicore/client/shaders/IntUniform;", "Ldev/deftu/omnicore/client/shaders/VecUniform;", "Ldev/deftu/omnicore/client/shaders/Vec2Uniform;", "Ldev/deftu/omnicore/client/shaders/Vec3Uniform;", "Ldev/deftu/omnicore/client/shaders/Vec4Uniform;", "Ldev/deftu/omnicore/client/shaders/MatrixUniform;", "", "location", "<init>", "(I)V", "value", "", "setValue", "", "a", "(F)V", "b", "(FF)V", "c", "(FFF)V", "d", "(FFFF)V", "", "matrix", "([F)V", "I", "getLocation", "()I", "OmniCore"})
public final class DirectUniform
implements ShaderUniform,
IntUniform,
VecUniform,
Vec2Uniform,
Vec3Uniform,
Vec4Uniform,
MatrixUniform {
    private final int location;

    public DirectUniform(int location) {
        this.location = location;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public void setValue(int value) {
        OmniShader.Companion.uniform1i(this.getLocation(), value);
    }

    @Override
    public void setValue(float a) {
        OmniShader.Companion.uniform1f(this.getLocation(), a);
    }

    @Override
    public void setValue(float a, float b) {
        OmniShader.Companion.uniform2f(this.getLocation(), a, b);
    }

    @Override
    public void setValue(float a, float b, float c) {
        OmniShader.Companion.uniform3f(this.getLocation(), a, b, c);
    }

    @Override
    public void setValue(float a, float b, float c, float d) {
        OmniShader.Companion.uniform4f(this.getLocation(), a, b, c, d);
    }

    @Override
    public void setValue(@NotNull float[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        int size = matrix.length;
        switch (size) {
            case 4: {
                OmniShader.Companion.uniformMatrix2(this.getLocation(), false, matrix);
                break;
            }
            case 9: {
                OmniShader.Companion.uniformMatrix3(this.getLocation(), false, matrix);
                break;
            }
            case 16: {
                OmniShader.Companion.uniformMatrix4(this.getLocation(), false, matrix);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid matrix size: " + size);
            }
        }
    }
}

