/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common;

import com.mojang.brigadier.StringReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002 !B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001d\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0011R\u0014\u0010\u001e\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0011R\u0014\u0010\u001f\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0011\u00a8\u0006\""}, d2={"Ldev/deftu/omnicore/common/OmniNbt;", "", "<init>", "()V", "", "value", "Lnet/minecraft/nbt/CompoundNBT;", "parseCompound", "(Ljava/lang/String;)Lnet/minecraft/nbt/CompoundNBT;", "Lnet/minecraft/nbt/INBT;", "parseElement", "(Ljava/lang/String;)Lnet/minecraft/nbt/INBT;", "", "type", "getTypeName", "(I)Ljava/lang/String;", "TYPE_END", "I", "TYPE_BYTE", "TYPE_SHORT", "TYPE_INT", "TYPE_LONG", "TYPE_FLOAT", "TYPE_DOUBLE", "TYPE_BYTE_ARRAY", "TYPE_STRING", "TYPE_LIST", "TYPE_COMPOUND", "TYPE_INT_ARRAY", "TYPE_LONG_ARRAY", "TYPE_NUMBER", "MAX_DEPTH", "Compound", "List", "OmniCore"})
public final class OmniNbt {
    @NotNull
    public static final OmniNbt INSTANCE = new OmniNbt();
    public static final int TYPE_END = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_BYTE_ARRAY = 7;
    public static final int TYPE_STRING = 8;
    public static final int TYPE_LIST = 9;
    public static final int TYPE_COMPOUND = 10;
    public static final int TYPE_INT_ARRAY = 11;
    public static final int TYPE_LONG_ARRAY = 12;
    public static final int TYPE_NUMBER = 99;
    public static final int MAX_DEPTH = 512;

    private OmniNbt() {
    }

    @JvmStatic
    @NotNull
    public static final CompoundNBT parseCompound(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CompoundNBT compoundNBT = new JsonToNBT(new StringReader(value)).func_193593_f();
        Intrinsics.checkNotNullExpressionValue((Object)compoundNBT, (String)"readStruct(...)");
        return compoundNBT;
    }

    @JvmStatic
    @NotNull
    public static final INBT parseElement(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        INBT iNBT = new JsonToNBT(new StringReader(value)).func_193610_d();
        Intrinsics.checkNotNullExpressionValue((Object)iNBT, (String)"readValue(...)");
        return iNBT;
    }

    @JvmStatic
    @NotNull
    public static final String getTypeName(int type) {
        String string;
        switch (type) {
            case 0: {
                string = "End";
                break;
            }
            case 1: {
                string = "Byte";
                break;
            }
            case 2: {
                string = "Short";
                break;
            }
            case 3: {
                string = "Int";
                break;
            }
            case 4: {
                string = "Long";
                break;
            }
            case 5: {
                string = "Float";
                break;
            }
            case 6: {
                string = "Double";
                break;
            }
            case 7: {
                string = "ByteArray";
                break;
            }
            case 8: {
                string = "String";
                break;
            }
            case 9: {
                string = "List";
                break;
            }
            case 10: {
                string = "Compound";
                break;
            }
            case 11: {
                string = "IntArray";
                break;
            }
            case 12: {
                string = "LongArray";
                break;
            }
            default: {
                string = "Unknown(" + type + ')';
            }
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010!\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J'\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b#\u0010$J'\u0010&\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J'\u0010)\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*J-\u0010,\u001a\u00028\u0000\"\u0004\b\u0000\u0010+2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b,\u0010-J'\u00101\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010/\u001a\u00020.H\u0007\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b3\u00104J\u001f\u00106\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b6\u00107J!\u00109\u001a\u0004\u0018\u00010.2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b9\u0010:J\u001f\u0010<\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010>\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b>\u0010=J\u0017\u0010?\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010B\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\bB\u0010CJ\u001f\u0010F\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010E\u001a\u00020DH\u0007\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010J\u001a\u00020\u00042\u0006\u0010I\u001a\u00020HH\u0007\u00a2\u0006\u0004\bJ\u0010KJ\u0017\u0010L\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010O\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\bO\u0010PJ!\u0010R\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010Q\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\bR\u0010SJ+\u0010V\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0TH\u0007\u00a2\u0006\u0004\bV\u0010W\u00a8\u0006X"}, d2={"Ldev/deftu/omnicore/common/OmniNbt$Compound;", "", "<init>", "()V", "Lnet/minecraft/nbt/CompoundNBT;", "compound", "", "key", "", "default", "getByteOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;B)B", "", "getShortOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;S)S", "", "getIntOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;I)I", "", "getLongOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;J)J", "", "getFloatOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;F)F", "", "getDoubleOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;D)D", "", "getByteArrayOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;[B)[B", "getStringOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Lnet/minecraft/nbt/ListNBT;", "getListOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;Lnet/minecraft/nbt/ListNBT;)Lnet/minecraft/nbt/ListNBT;", "getCompoundOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;", "", "getIntArrayOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;[I)[I", "", "getLongArrayOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;[J)[J", "T", "getOrDefault", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "Lnet/minecraft/nbt/INBT;", "value", "", "putIfAbsent", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;Lnet/minecraft/nbt/INBT;)V", "deepCopy", "(Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;", "other", "merge", "(Lnet/minecraft/nbt/CompoundNBT;Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;", "path", "getByPath", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;)Lnet/minecraft/nbt/INBT;", "", "containsPath", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/lang/String;)Z", "removeByPath", "toByteArray", "(Lnet/minecraft/nbt/CompoundNBT;)[B", "bytes", "fromByteArray", "([B)Lnet/minecraft/nbt/CompoundNBT;", "Ljava/io/OutputStream;", "out", "writeToStream", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/io/OutputStream;)V", "Ljava/io/InputStream;", "input", "fromStream", "(Ljava/io/InputStream;)Lnet/minecraft/nbt/CompoundNBT;", "toBase64", "(Lnet/minecraft/nbt/CompoundNBT;)Ljava/lang/String;", "base64", "fromBase64", "(Ljava/lang/String;)Lnet/minecraft/nbt/CompoundNBT;", "indent", "prettify", "(Lnet/minecraft/nbt/CompoundNBT;I)Ljava/lang/String;", "", "requiredKeys", "validate", "(Lnet/minecraft/nbt/CompoundNBT;Ljava/util/Map;)Z", "OmniCore"})
    public static final class Compound {
        @NotNull
        public static final Compound INSTANCE = new Compound();

        private Compound() {
        }

        @JvmStatic
        public static final byte getByteOrDefault(@NotNull CompoundNBT compound, @NotNull String key, byte by) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.func_150297_b(key, 1) ? compound.func_74771_c(key) : by;
        }

        @JvmStatic
        public static final short getShortOrDefault(@NotNull CompoundNBT compound, @NotNull String key, short s) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.func_150297_b(key, 2) ? compound.func_74765_d(key) : s;
        }

        @JvmStatic
        public static final int getIntOrDefault(@NotNull CompoundNBT compound, @NotNull String key, int n) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.func_150297_b(key, 3) ? compound.func_74762_e(key) : n;
        }

        @JvmStatic
        public static final long getLongOrDefault(@NotNull CompoundNBT compound, @NotNull String key, long l) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.func_150297_b(key, 4) ? compound.func_74763_f(key) : l;
        }

        @JvmStatic
        public static final float getFloatOrDefault(@NotNull CompoundNBT compound, @NotNull String key, float f) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.func_150297_b(key, 5) ? compound.func_74760_g(key) : f;
        }

        @JvmStatic
        public static final double getDoubleOrDefault(@NotNull CompoundNBT compound, @NotNull String key, double d) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.func_150297_b(key, 6) ? compound.func_74769_h(key) : d;
        }

        @JvmStatic
        @NotNull
        public static final byte[] getByteArrayOrDefault(@NotNull CompoundNBT compound, @NotNull String key, @NotNull byte[] byArray) {
            byte[] byArray2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"default");
            if (compound.func_150297_b(key, 7)) {
                byte[] byArray3 = compound.func_74770_j(key);
                Intrinsics.checkNotNull((Object)byArray3);
                byArray2 = byArray3;
            } else {
                byArray2 = byArray;
            }
            return byArray2;
        }

        @JvmStatic
        @NotNull
        public static final String getStringOrDefault(@NotNull CompoundNBT compound, @NotNull String key, @NotNull String string) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)string, (String)"default");
            if (compound.func_150297_b(key, 8)) {
                String string3 = compound.func_74779_i(key);
                Intrinsics.checkNotNull((Object)string3);
                string2 = string3;
            } else {
                string2 = string;
            }
            return string2;
        }

        @JvmStatic
        @NotNull
        public static final ListNBT getListOrDefault(@NotNull CompoundNBT compound, @NotNull String key, @NotNull ListNBT listNBT) {
            ListNBT listNBT2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)listNBT, (String)"default");
            if (compound.func_150297_b(key, 9)) {
                ListNBT listNBT3 = compound.func_150295_c(key, 10);
                Intrinsics.checkNotNull((Object)listNBT3);
                listNBT2 = listNBT3;
            } else {
                listNBT2 = listNBT;
            }
            return listNBT2;
        }

        @JvmStatic
        @NotNull
        public static final CompoundNBT getCompoundOrDefault(@NotNull CompoundNBT compound, @NotNull String key, @NotNull CompoundNBT compoundNBT) {
            CompoundNBT compoundNBT2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)compoundNBT, (String)"default");
            if (compound.func_150297_b(key, 10)) {
                CompoundNBT compoundNBT3 = compound.func_74775_l(key);
                Intrinsics.checkNotNull((Object)compoundNBT3);
                compoundNBT2 = compoundNBT3;
            } else {
                compoundNBT2 = compoundNBT;
            }
            return compoundNBT2;
        }

        @JvmStatic
        @NotNull
        public static final int[] getIntArrayOrDefault(@NotNull CompoundNBT compound, @NotNull String key, @NotNull int[] nArray) {
            int[] nArray2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"default");
            if (compound.func_150297_b(key, 11)) {
                int[] nArray3 = compound.func_74759_k(key);
                Intrinsics.checkNotNull((Object)nArray3);
                nArray2 = nArray3;
            } else {
                nArray2 = nArray;
            }
            return nArray2;
        }

        @JvmStatic
        @NotNull
        public static final long[] getLongArrayOrDefault(@NotNull CompoundNBT compound, @NotNull String key, @NotNull long[] lArray) {
            long[] lArray2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"default");
            if (compound.func_150297_b(key, 12)) {
                long[] lArray3 = compound.func_197645_o(key);
                Intrinsics.checkNotNull((Object)lArray3);
                lArray2 = lArray3;
            } else {
                lArray2 = lArray;
            }
            return lArray2;
        }

        @JvmStatic
        public static final <T> T getOrDefault(@NotNull CompoundNBT compound, @NotNull String key, T t) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            T t2 = t;
            if (t2 instanceof Byte) {
                object = Compound.getByteOrDefault(compound, key, ((Number)t).byteValue());
            } else if (t2 instanceof Short) {
                object = Compound.getShortOrDefault(compound, key, ((Number)t).shortValue());
            } else if (t2 instanceof Integer) {
                object = Compound.getIntOrDefault(compound, key, ((Number)t).intValue());
            } else if (t2 instanceof Long) {
                object = Compound.getLongOrDefault(compound, key, ((Number)t).longValue());
            } else if (t2 instanceof Float) {
                object = Float.valueOf(Compound.getFloatOrDefault(compound, key, ((Number)t).floatValue()));
            } else if (t2 instanceof Double) {
                object = Compound.getDoubleOrDefault(compound, key, ((Number)t).doubleValue());
            } else if (t2 instanceof byte[]) {
                object = Compound.getByteArrayOrDefault(compound, key, (byte[])t);
            } else if (t2 instanceof String) {
                object = Compound.getStringOrDefault(compound, key, (String)t);
            } else if (t2 instanceof ListNBT) {
                object = Compound.getListOrDefault(compound, key, (ListNBT)t);
            } else if (t2 instanceof CompoundNBT) {
                object = Compound.getCompoundOrDefault(compound, key, (CompoundNBT)t);
            } else if (t2 instanceof int[]) {
                object = Compound.getIntArrayOrDefault(compound, key, (int[])t);
            } else if (t2 instanceof long[]) {
                object = Compound.getLongArrayOrDefault(compound, key, (long[])t);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Unsupported type: ");
                T t3 = t;
                Intrinsics.checkNotNull(t3);
                throw new IllegalArgumentException(stringBuilder.append(t3.getClass()).toString());
            }
            return (T)object;
        }

        @JvmStatic
        public static final void putIfAbsent(@NotNull CompoundNBT compound, @NotNull String key, @NotNull INBT value) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!compound.func_74764_b(key)) {
                compound.func_218657_a(key, value);
            }
        }

        @JvmStatic
        @NotNull
        public static final CompoundNBT deepCopy(@NotNull CompoundNBT compound) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            CompoundNBT compoundNBT = compound.func_74737_b();
            Intrinsics.checkNotNull((Object)compoundNBT, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            return compoundNBT;
        }

        @JvmStatic
        @NotNull
        public static final CompoundNBT merge(@NotNull CompoundNBT compound, @NotNull CompoundNBT other) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            for (String key : other.func_150296_c()) {
                INBT otherValue = other.func_74781_a(key);
                INBT thisValue = compound.func_74781_a(key);
                if (thisValue instanceof CompoundNBT && otherValue instanceof CompoundNBT) {
                    Compound.merge((CompoundNBT)thisValue, (CompoundNBT)otherValue);
                    continue;
                }
                if (otherValue == null) continue;
                compound.func_218657_a(key, otherValue);
            }
            return compound;
        }

        @JvmStatic
        @Nullable
        public static final INBT getByPath(@NotNull CompoundNBT compound, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            INBT current = (INBT)compound;
            char[] cArray = new char[]{'.'};
            for (String part : StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                if (!(current instanceof CompoundNBT)) {
                    return null;
                }
                current = ((CompoundNBT)current).func_74781_a(part);
            }
            return current;
        }

        @JvmStatic
        public static final boolean containsPath(@NotNull CompoundNBT compound, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Compound.getByPath(compound, path) != null;
        }

        @JvmStatic
        public static final boolean removeByPath(@NotNull CompoundNBT compound, @NotNull String path) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            char[] cArray = new char[]{'.'};
            java.util.List parts = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            String last = (String)CollectionsKt.last((java.util.List)parts);
            INBT parent = Compound.getByPath(compound, CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((java.util.List)parts, (int)1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            if (parent instanceof CompoundNBT && ((CompoundNBT)parent).func_74764_b(last)) {
                ((CompoundNBT)parent).func_82580_o(last);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public static final byte[] toByteArray(@NotNull CompoundNBT compound) {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            ByteArrayOutputStream $this$toByteArray_u24lambda_u240 = byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            CompressedStreamTools.func_74799_a((CompoundNBT)compound, (OutputStream)$this$toByteArray_u24lambda_u240);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return byArray;
        }

        @JvmStatic
        @NotNull
        public static final CompoundNBT fromByteArray(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
            Intrinsics.checkNotNullExpressionValue((Object)compoundNBT, (String)"readCompressed(...)");
            return compoundNBT;
        }

        @JvmStatic
        public static final void writeToStream(@NotNull CompoundNBT compound, @NotNull OutputStream out) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            CompressedStreamTools.func_74799_a((CompoundNBT)compound, (OutputStream)out);
        }

        @JvmStatic
        @NotNull
        public static final CompoundNBT fromStream(@NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a((InputStream)input);
            Intrinsics.checkNotNullExpressionValue((Object)compoundNBT, (String)"readCompressed(...)");
            return compoundNBT;
        }

        @JvmStatic
        @NotNull
        public static final String toBase64(@NotNull CompoundNBT compound) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            String string = Base64.getEncoder().encodeToString(Compound.toByteArray(compound));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public static final CompoundNBT fromBase64(@NotNull String base64) {
            Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
            byte[] bytes = Base64.getDecoder().decode(base64);
            Intrinsics.checkNotNull((Object)bytes);
            return Compound.fromByteArray(bytes);
        }

        @JvmStatic
        @NotNull
        public static final String prettify(@NotNull CompoundNBT compound, int indent) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            String indentStr = StringsKt.repeat((CharSequence)" ", (int)indent);
            StringBuilder sb = new StringBuilder("{\n");
            for (String key : compound.func_150296_c()) {
                INBT value = compound.func_74781_a(key);
                sb.append(indentStr).append("  ").append(key).append(": ");
                StringBuilder stringBuilder = value instanceof CompoundNBT ? sb.append(Compound.prettify((CompoundNBT)value, indent + 2)) : sb.append(String.valueOf(value));
                sb.append("\n");
            }
            sb.append(indentStr).append("}");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static /* synthetic */ String prettify$default(CompoundNBT compoundNBT, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return Compound.prettify(compoundNBT, n);
        }

        @JvmStatic
        public static final boolean validate(@NotNull CompoundNBT compound, @NotNull Map<String, Integer> requiredKeys) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter(requiredKeys, (String)"requiredKeys");
            for (Map.Entry<String, Integer> entry : requiredKeys.entrySet()) {
                int expectedType;
                String key = entry.getKey();
                if (compound.func_150297_b(key, expectedType = ((Number)entry.getValue()).intValue())) continue;
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J+\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u000eH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0018J-\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u000eH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Ldev/deftu/omnicore/common/OmniNbt$List;", "", "<init>", "()V", "Lnet/minecraft/nbt/ListNBT;", "list", "Lnet/minecraft/nbt/INBT;", "element", "", "add", "(Lnet/minecraft/nbt/ListNBT;Lnet/minecraft/nbt/INBT;)V", "", "size", "(Lnet/minecraft/nbt/ListNBT;)I", "Lkotlin/Function1;", "Lnet/minecraft/nbt/CompoundNBT;", "action", "forEachCompound", "(Lnet/minecraft/nbt/ListNBT;Lkotlin/jvm/functions/Function1;)V", "index", "getCompoundOrNull", "(Lnet/minecraft/nbt/ListNBT;I)Lnet/minecraft/nbt/CompoundNBT;", "transform", "mapCompounds", "(Lnet/minecraft/nbt/ListNBT;Lkotlin/jvm/functions/Function1;)Lnet/minecraft/nbt/ListNBT;", "", "predicate", "filterCompounds", "findCompound", "(Lnet/minecraft/nbt/ListNBT;Lkotlin/jvm/functions/Function1;)Lnet/minecraft/nbt/CompoundNBT;", "OmniCore"})
    public static final class List {
        @NotNull
        public static final List INSTANCE = new List();

        private List() {
        }

        @JvmStatic
        public static final void add(@NotNull ListNBT list, @NotNull INBT element) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            list.add((Object)element);
        }

        @JvmStatic
        public static final int size(@NotNull ListNBT list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            return list.size();
        }

        @JvmStatic
        public static final void forEachCompound(@NotNull ListNBT list, @NotNull Function1<? super CompoundNBT, Unit> action) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            int n = List.size(list);
            for (int i = 0; i < n; ++i) {
                INBT element = list.get(i);
                if (!(element instanceof CompoundNBT)) continue;
                action.invoke((Object)element);
            }
        }

        @JvmStatic
        @Nullable
        public static final CompoundNBT getCompoundOrNull(@NotNull ListNBT list, int index) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            INBT element = list.get(index);
            return element instanceof CompoundNBT ? (CompoundNBT)element : null;
        }

        @JvmStatic
        @NotNull
        public static final ListNBT mapCompounds(@NotNull ListNBT list, @NotNull Function1<? super CompoundNBT, ? extends INBT> transform) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            ListNBT result = new ListNBT();
            List.forEachCompound(list, (Function1<? super CompoundNBT, Unit>)((Function1)arg_0 -> List.mapCompounds$lambda$0(result, transform, arg_0)));
            return result;
        }

        @JvmStatic
        @NotNull
        public static final ListNBT filterCompounds(@NotNull ListNBT list, @NotNull Function1<? super CompoundNBT, Boolean> predicate) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            ListNBT result = new ListNBT();
            List.forEachCompound(list, (Function1<? super CompoundNBT, Unit>)((Function1)arg_0 -> List.filterCompounds$lambda$1(predicate, result, arg_0)));
            return result;
        }

        @JvmStatic
        @Nullable
        public static final CompoundNBT findCompound(@NotNull ListNBT list, @NotNull Function1<? super CompoundNBT, Boolean> predicate) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            int n = List.size(list);
            for (int i = 0; i < n; ++i) {
                INBT element = list.get(i);
                if (!(element instanceof CompoundNBT) || !((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
                return (CompoundNBT)element;
            }
            return null;
        }

        private static final Unit mapCompounds$lambda$0(ListNBT $result, Function1 $transform, CompoundNBT it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            List.add($result, (INBT)$transform.invoke((Object)it));
            return Unit.INSTANCE;
        }

        private static final Unit filterCompounds$lambda$1(Function1 $predicate, ListNBT $result, CompoundNBT it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (((Boolean)$predicate.invoke((Object)it)).booleanValue()) {
                List.add($result, (INBT)it);
            }
            return Unit.INSTANCE;
        }
    }
}

