/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.deftu.omnicore.client.render.TextureAllocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Ldev/deftu/omnicore/client/render/TemporaryTextureAllocator;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lkotlin/Function0;", "", "onClose", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "", "width", "height", "Ldev/deftu/omnicore/client/render/TextureAllocation;", "allocate", "(II)Ldev/deftu/omnicore/client/render/TextureAllocation;", "tick", "()V", "close", "Lkotlin/jvm/functions/Function0;", "", "usedAllocations", "Ljava/util/List;", "reusableAllocations", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nTemporaryTextureAllocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryTextureAllocator.kt\ndev/deftu/omnicore/client/render/TemporaryTextureAllocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1863#2,2:52\n*S KotlinDebug\n*F\n+ 1 TemporaryTextureAllocator.kt\ndev/deftu/omnicore/client/render/TemporaryTextureAllocator\n*L\n31#1:52,2\n*E\n"})
public final class TemporaryTextureAllocator
implements AutoCloseable {
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final List<TextureAllocation> usedAllocations;
    @NotNull
    private final List<TextureAllocation> reusableAllocations;

    public TemporaryTextureAllocator(@NotNull Function0<Unit> onClose) {
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        this.onClose = onClose;
        this.usedAllocations = new ArrayList();
        this.reusableAllocations = new ArrayList();
    }

    public /* synthetic */ TemporaryTextureAllocator(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = TemporaryTextureAllocator::_init_$lambda$0;
        }
        this((Function0<Unit>)function0);
    }

    @NotNull
    public final TextureAllocation allocate(int width, int height) {
        TextureAllocation lastTexture = (TextureAllocation)CollectionsKt.removeLastOrNull(this.reusableAllocations);
        if (lastTexture != null && (lastTexture.getWidth() != width || lastTexture.getHeight() != height)) {
            lastTexture.close();
            lastTexture = null;
        }
        if (lastTexture == null) {
            lastTexture = new TextureAllocation(width, height);
        }
        GpuDevice device = RenderSystem.getDevice();
        device.createCommandEncoder().clearColorAndDepthTextures(lastTexture.getColorTexture(), 0, lastTexture.getDepthTexture(), 1.0);
        this.usedAllocations.add(lastTexture);
        return lastTexture;
    }

    public final void tick() {
        Iterable $this$forEach$iv = this.reusableAllocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureAllocation p0 = (TextureAllocation)element$iv;
            boolean $i$f$tick$stub_for_inlining = false;
            boolean bl = false;
            p0.close();
        }
        this.reusableAllocations.clear();
        this.reusableAllocations.addAll((Collection<TextureAllocation>)this.usedAllocations);
        this.usedAllocations.clear();
        if (this.reusableAllocations.isEmpty()) {
            this.onClose.invoke();
        }
    }

    @Override
    public void close() {
        this.tick();
        this.tick();
        boolean bl = this.usedAllocations.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = this.reusableAllocations.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    public TemporaryTextureAllocator() {
        this(null, 1, null);
    }
}

