/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.server;

import dev.deftu.omnicore.common.OmniIdentifier;
import dev.deftu.omnicore.common.OmniPacketHandler;
import dev.deftu.omnicore.common.OmniPacketReceiverContext;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B[\u0012*\u0010\t\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00050\u00030\u0002\u0012\u001e\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00050\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R8\u0010\t\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00050\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0015R,\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00050\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0015R\u0014\u0010\u000b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/deftu/omnicore/server/OmniServerPacketHandler;", "Ldev/deftu/omnicore/common/OmniPacketHandler;", "Lkotlin/Function0;", "", "Lnet/minecraft/util/ResourceLocation;", "", "Ljava/util/function/BiPredicate;", "Lnet/minecraft/entity/player/EntityPlayerMP;", "Ldev/deftu/omnicore/common/OmniPacketReceiverContext;", "channeledPacketReceiverProvider", "globalPacketReceiverProvider", "player", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lnet/minecraft/entity/player/EntityPlayerMP;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "Lnet/minecraft/network/Packet;", "packet", "", "handleRead", "(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/Packet;)Z", "Lkotlin/jvm/functions/Function0;", "Lnet/minecraft/entity/player/EntityPlayerMP;", "OmniCore"})
public final class OmniServerPacketHandler
extends OmniPacketHandler {
    @NotNull
    private final Function0<Map<ResourceLocation, Set<BiPredicate<EntityPlayerMP, OmniPacketReceiverContext>>>> channeledPacketReceiverProvider;
    @NotNull
    private final Function0<Set<BiPredicate<EntityPlayerMP, OmniPacketReceiverContext>>> globalPacketReceiverProvider;
    @NotNull
    private final EntityPlayerMP player;

    public OmniServerPacketHandler(@NotNull Function0<? extends Map<ResourceLocation, ? extends Set<? extends BiPredicate<EntityPlayerMP, OmniPacketReceiverContext>>>> channeledPacketReceiverProvider, @NotNull Function0<? extends Set<? extends BiPredicate<EntityPlayerMP, OmniPacketReceiverContext>>> globalPacketReceiverProvider, @NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter(channeledPacketReceiverProvider, (String)"channeledPacketReceiverProvider");
        Intrinsics.checkNotNullParameter(globalPacketReceiverProvider, (String)"globalPacketReceiverProvider");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.channeledPacketReceiverProvider = channeledPacketReceiverProvider;
        this.globalPacketReceiverProvider = globalPacketReceiverProvider;
        this.player = player;
    }

    @Override
    public boolean handleRead(@NotNull ChannelHandlerContext ctx, @Nullable Packet<?> packet) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Map channeledPacketReceivers = (Map)this.channeledPacketReceiverProvider.invoke();
        Set globalPacketReceivers = (Set)this.globalPacketReceiverProvider.invoke();
        C17PacketCustomPayload c17PacketCustomPayload = packet instanceof C17PacketCustomPayload ? (C17PacketCustomPayload)packet : null;
        if (c17PacketCustomPayload == null) {
            return false;
        }
        C17PacketCustomPayload customPayloadPacket = c17PacketCustomPayload;
        String channelName = customPayloadPacket.func_149559_c();
        PacketBuffer buf = customPayloadPacket.func_180760_b();
        Intrinsics.checkNotNull((Object)channelName);
        ResourceLocation channel = OmniIdentifier.create(channelName);
        Set set = (Set)channeledPacketReceivers.get(channel);
        Collection channeledReceivers = set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
        List receivers = CollectionsKt.plus((Collection)channeledReceivers, (Iterable)globalPacketReceivers);
        Intrinsics.checkNotNull((Object)buf);
        OmniPacketReceiverContext context = new OmniPacketReceiverContext(channel, buf);
        for (BiPredicate receiver : receivers) {
            if (!receiver.test(this.player, context)) continue;
            return true;
        }
        return false;
    }
}

