/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.mixins.server;

import dev.deftu.omnicore.common.OmniCustomPayloadDataHolder;
import dev.deftu.omnicore.common.OmniPacketReceiverContext;
import dev.deftu.omnicore.server.OmniServerPackets;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class Mixin_ServerPlayNetworkHandler_CaptureOverridenCustomPayloads {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handleCustomPayload(Lnet/minecraft/network/protocol/common/ServerboundCustomPayloadPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void omnicore$captureCustomPayloads(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        CustomPacketPayload payload = packet.payload();
        if (!(payload instanceof DiscardedPayload)) {
            return;
        }
        DiscardedPayload discardedPayload = (DiscardedPayload)payload;
        if (!(payload instanceof OmniCustomPayloadDataHolder)) {
            return;
        }
        OmniCustomPayloadDataHolder holder = (OmniCustomPayloadDataHolder)payload;
        ResourceLocation channel = discardedPayload.id();
        FriendlyByteBuf buf = holder.omnicore$getData();
        Set<BiPredicate<ServerPlayer, OmniPacketReceiverContext>> receivers = OmniServerPackets.getAllPacketReceivers$OmniCore(channel);
        OmniPacketReceiverContext context = new OmniPacketReceiverContext(channel, buf);
        boolean anyHandled = receivers.stream().anyMatch(receiver -> receiver.test(this.player, context));
        if (anyHandled) {
            ci.cancel();
        }
    }
}

