/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.pipeline;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.deftu.omnicore.client.OmniClient;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPass;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipeline;
import dev.deftu.omnicore.client.render.state.OmniManagedScissorState;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_276;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryStack;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u0011J!\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\n\u0010\u0014\u001a\u00020\u0012\"\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\n\u0010\u0014\u001a\u00020\u0017\"\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0018J-\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u0018\u00101\u001a\u0004\u0018\u0001008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00063"}, d2={"Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;", "renderPass", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "pipeline", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "builtBuffer", "<init>", "(Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;)V", "", "name", "", "glId", "texture", "(Ljava/lang/String;I)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "index", "(II)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "", "values", "uniform", "(Ljava/lang/String;[F)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "(Ljava/lang/String;[I)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "x", "y", "width", "height", "enableScissor", "(IIII)Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "disableScissor", "()Ldev/deftu/omnicore/client/render/pipeline/RenderPassBuilder;", "", "activate", "()V", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPass;", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "internalBuffers", "Ljava/util/Set;", "Lcom/mojang/blaze3d/systems/RenderPass;", "vanilla", "Lcom/mojang/blaze3d/systems/RenderPass;", "getVanilla$OmniCore", "()Lcom/mojang/blaze3d/systems/RenderPass;", "Ldev/deftu/omnicore/client/render/state/OmniManagedScissorState;", "scissorState", "Ldev/deftu/omnicore/client/render/state/OmniManagedScissorState;", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nRenderPassBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderPassBuilder.kt\ndev/deftu/omnicore/client/render/pipeline/RenderPassBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1#2:186\n1863#3,2:187\n*S KotlinDebug\n*F\n+ 1 RenderPassBuilder.kt\ndev/deftu/omnicore/client/render/pipeline/RenderPassBuilder\n*L\n164#1:187,2\n*E\n"})
public final class RenderPassBuilder {
    @NotNull
    private final OmniRenderPass renderPass;
    @NotNull
    private final OmniRenderPipeline pipeline;
    @NotNull
    private final OmniBuiltBuffer builtBuffer;
    @NotNull
    private final Set<GpuBuffer> internalBuffers;
    @NotNull
    private final RenderPass vanilla;
    @Nullable
    private OmniManagedScissorState scissorState;

    /*
     * WARNING - void declaration
     */
    public RenderPassBuilder(@NotNull OmniRenderPass renderPass, @NotNull OmniRenderPipeline pipeline, @NotNull OmniBuiltBuffer builtBuffer) {
        void $this$_init__u24lambda_u241;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)renderPass, (String)"renderPass");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)builtBuffer, (String)"builtBuffer");
        this.renderPass = renderPass;
        this.pipeline = pipeline;
        this.builtBuffer = builtBuffer;
        this.internalBuffers = new LinkedHashSet();
        GpuBufferSlice dynamicUniforms = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)RenderSystem.getModelOffset(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
        class_9801 builtBuffer2 = this.builtBuffer.getVanilla();
        GpuBuffer vertexBuffer = this.pipeline.getVertexFormat().uploadImmediateVertexBuffer(builtBuffer2.method_60818());
        ByteBuffer indexBuffer = builtBuffer2.method_60821();
        if (indexBuffer == null) {
            RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)builtBuffer2.method_60822().comp_752());
            pair = TuplesKt.to((Object)shapeIndexBuffer.method_68274(builtBuffer2.method_60822().comp_751()), (Object)shapeIndexBuffer.method_31924());
        } else {
            pair = TuplesKt.to((Object)this.pipeline.getVertexFormat().uploadImmediateIndexBuffer(indexBuffer), (Object)builtBuffer2.method_60822().comp_753());
        }
        Pair pair2 = pair;
        GpuBuffer uploadedIndexBuffer = (GpuBuffer)pair2.component1();
        VertexFormat.class_5595 indexType = (VertexFormat.class_5595)pair2.component2();
        class_276 class_2762 = OmniClient.getInstance().method_1522();
        RenderPassBuilder renderPassBuilder = this;
        boolean bl = false;
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        Supplier<String> supplier = () -> RenderPassBuilder.lambda$1$lambda$0(this);
        GpuTextureView gpuTextureView = RenderSystem.outputColorTextureOverride;
        if (gpuTextureView == null) {
            GpuTextureView gpuTextureView2 = $this$_init__u24lambda_u241.method_71639();
            gpuTextureView = gpuTextureView2;
            Intrinsics.checkNotNull((Object)gpuTextureView2);
        }
        OptionalInt optionalInt = OptionalInt.empty();
        GpuTextureView gpuTextureView3 = RenderSystem.outputDepthTextureOverride;
        if (gpuTextureView3 == null) {
            gpuTextureView3 = $this$_init__u24lambda_u241.method_71640();
        }
        renderPassBuilder.vanilla = commandEncoder.createRenderPass(supplier, gpuTextureView, optionalInt, gpuTextureView3, OptionalDouble.empty());
        this.vanilla.setVertexBuffer(0, vertexBuffer);
        this.vanilla.setIndexBuffer(uploadedIndexBuffer, indexType);
        RenderSystem.bindDefaultUniforms((RenderPass)this.vanilla);
        this.vanilla.setUniform("DynamicTransforms", dynamicUniforms);
    }

    @NotNull
    public final RenderPass getVanilla$OmniCore() {
        return this.vanilla;
    }

    @NotNull
    public final RenderPassBuilder texture(@NotNull String name, int glId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.vanilla.bindSampler(name, RenderSystem.getDevice().createTextureView((GpuTexture)new OmniTextureManager.VanillaWrappedGlTexture(glId)));
        return this;
    }

    @NotNull
    public final RenderPassBuilder texture(int index, int glId) {
        String samplerName = (String)this.pipeline.getVanilla().getSamplers().get(index);
        Intrinsics.checkNotNull((Object)samplerName);
        this.texture(samplerName, glId);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final RenderPassBuilder uniform(@NotNull String name, float ... values) {
        void p0;
        Object memoryStack2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        String string = name;
        RenderPass renderPass = this.vanilla;
        Object object = null;
        try {
            memoryStack2 = (MemoryStack)autoCloseable;
            boolean bl = false;
            ByteBuffer buffer = memoryStack2.malloc(values.length * 4);
            for (float value : values) {
                buffer.putFloat(value);
            }
            buffer.flip();
            memoryStack2 = RenderSystem.getDevice().createBuffer(() -> RenderPassBuilder.uniform$lambda$3$lambda$2(name), 128, buffer);
        }
        catch (Throwable memoryStack2) {
            object = memoryStack2;
            throw memoryStack2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
        MemoryStack memoryStack3 = memoryStack2;
        autoCloseable = memoryStack3;
        object = this.internalBuffers;
        memoryStack2 = autoCloseable;
        boolean bl = false;
        object.add(p0);
        memoryStack3 = Unit.INSTANCE;
        renderPass.setUniform(string, (GpuBuffer)autoCloseable);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final RenderPassBuilder uniform(@NotNull String name, int ... values) {
        void p0;
        Object memoryStack2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        String string = name;
        RenderPass renderPass = this.vanilla;
        Object object = null;
        try {
            memoryStack2 = (MemoryStack)autoCloseable;
            boolean bl = false;
            ByteBuffer buffer = memoryStack2.malloc(values.length * 4);
            for (int value : values) {
                buffer.putInt(value);
            }
            buffer.flip();
            memoryStack2 = RenderSystem.getDevice().createBuffer(() -> RenderPassBuilder.uniform$lambda$5$lambda$4(name), 128, buffer);
        }
        catch (Throwable memoryStack2) {
            object = memoryStack2;
            throw memoryStack2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
        MemoryStack memoryStack3 = memoryStack2;
        autoCloseable = memoryStack3;
        object = this.internalBuffers;
        memoryStack2 = autoCloseable;
        boolean bl = false;
        object.add(p0);
        memoryStack3 = Unit.INSTANCE;
        renderPass.setUniform(string, (GpuBuffer)autoCloseable);
        return this;
    }

    @NotNull
    public final RenderPassBuilder enableScissor(int x, int y, int width, int height) {
        this.scissorState = OmniManagedScissorState.Companion.asEnabled(x, y, width, height);
        return this;
    }

    @NotNull
    public final RenderPassBuilder disableScissor() {
        this.scissorState = OmniManagedScissorState.DISABLED;
        return this;
    }

    public final void activate() {
        OmniManagedScissorState omniManagedScissorState = this.scissorState;
        if (omniManagedScissorState == null) {
            omniManagedScissorState = OmniManagedScissorState.Companion.active();
        }
        OmniManagedScissorState scissorState = omniManagedScissorState;
        scissorState.applyTo(this.vanilla);
        this.pipeline.draw$OmniCore(this.vanilla, this.builtBuffer.getVanilla());
        this.vanilla.close();
        Iterable $this$forEach$iv = this.internalBuffers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GpuBuffer p0 = (GpuBuffer)element$iv;
            boolean $i$f$activate$stub_for_inlining = false;
            boolean bl = false;
            p0.close();
        }
    }

    private static final String lambda$1$lambda$0(RenderPassBuilder this$0) {
        return this$0.pipeline + " render pass";
    }

    private static final String uniform$lambda$3$lambda$2(String $name) {
        return $name + " UBO";
    }

    private static final String uniform$lambda$5$lambda$4(String $name) {
        return $name + " UBO";
    }
}

