/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import dev.deftu.eventbus.EventBus;
import dev.deftu.eventbus.EventPriority;
import dev.deftu.eventbus.EventSubscriber;
import dev.deftu.eventbus.collection.ConcurrentSubscriberArrayList;
import dev.deftu.eventbus.collection.SubscriberArrayList;
import dev.deftu.eventbus.invokers.Invoker;
import dev.deftu.omnicore.OmniCore;
import dev.deftu.omnicore.client.events.RenderTickEvent;
import dev.deftu.omnicore.client.events.ScreenEvent;
import dev.deftu.omnicore.client.render.OmniMatrixStack;
import dev.deftu.omnicore.client.render.OmniResolution;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.TemporaryTextureAllocator;
import dev.deftu.omnicore.client.render.TextureAllocation;
import dev.deftu.omnicore.common.OmniIdentifier;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J+\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Ldev/deftu/omnicore/client/render/ImmediateScreenRenderer;", "", "<init>", "()V", "", "initialize", "Lnet/minecraft/client/gui/GuiGraphics;", "ctx", "Lkotlin/Function1;", "Ldev/deftu/omnicore/client/render/OmniMatrixStack;", "block", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lkotlin/jvm/functions/Function1;)V", "Ldev/deftu/omnicore/client/events/ScreenEvent$Render;", "event", "(Ldev/deftu/omnicore/client/events/ScreenEvent$Render;Lkotlin/jvm/functions/Function1;)V", "", "isInitialized", "Z", "Lnet/minecraft/client/renderer/CachedOrthoProjectionMatrixBuffer;", "cachedProjectionMatrix", "Lnet/minecraft/client/renderer/CachedOrthoProjectionMatrixBuffer;", "Ldev/deftu/omnicore/client/render/TemporaryTextureAllocator;", "textureAllocator", "Ldev/deftu/omnicore/client/render/TemporaryTextureAllocator;", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nImmediateScreenRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateScreenRenderer.kt\ndev/deftu/omnicore/client/render/ImmediateScreenRenderer\n+ 2 eventbus.kt\ndev/deftu/eventbus/EventbusKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n151#2,11:118\n1#3:129\n*S KotlinDebug\n*F\n+ 1 ImmediateScreenRenderer.kt\ndev/deftu/omnicore/client/render/ImmediateScreenRenderer\n*L\n42#1:118,11\n*E\n"})
public final class ImmediateScreenRenderer {
    @NotNull
    public static final ImmediateScreenRenderer INSTANCE = new ImmediateScreenRenderer();
    private static boolean isInitialized;
    @Nullable
    private static CachedOrthoProjectionMatrixBuffer cachedProjectionMatrix;
    @NotNull
    private static TemporaryTextureAllocator textureAllocator;

    private ImmediateScreenRenderer() {
    }

    public final void initialize() {
        if (isInitialized) {
            return;
        }
        EventBus $this$on_u24default$iv = OmniCore.getEventBus();
        EventPriority priority$iv = EventPriority.NORMAL;
        boolean $i$f$on = false;
        Invoker.SubscriberMethod method$iv = new Invoker.SubscriberMethod(){

            public final void invoke(Object arg) {
                Object object = arg;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type dev.deftu.omnicore.client.events.RenderTickEvent.Pre");
                }
                RenderTickEvent.Pre $this$initialize_u24lambda_u241 = (RenderTickEvent.Pre)object;
                boolean bl = false;
                ImmediateScreenRenderer.access$getTextureAllocator$p().tick();
            }
        };
        EventSubscriber subscriber$iv = new EventSubscriber((Object)$this$on_u24default$iv, priority$iv, method$iv);
        ((List)$this$on_u24default$iv.getSubscribers().computeIfAbsent(RenderTickEvent.Pre.class, new Function($this$on_u24default$iv){
            final /* synthetic */ EventBus $this_on;
            {
                this.$this_on = $receiver;
            }

            public final List<EventSubscriber> apply(Class<?> it) {
                return this.$this_on.getThreadSafety() ? (List)new ConcurrentSubscriberArrayList() : (List)new SubscriberArrayList();
            }
        })).add(subscriber$iv);
        Function0 cfr_ignored_0 = (Function0)new Function0<Unit>($this$on_u24default$iv, subscriber$iv){
            final /* synthetic */ EventBus $this_on;
            final /* synthetic */ EventSubscriber $subscriber;
            {
                this.$this_on = $receiver;
                this.$subscriber = $subscriber;
                super(0);
            }

            public final void invoke() {
                block0: {
                    List list = (List)this.$this_on.getSubscribers().get(RenderTickEvent.Pre.class);
                    if (list == null) break block0;
                    list.remove(this.$subscriber);
                }
            }
        };
        isInitialized = true;
    }

    @JvmStatic
    public static final void render(@NotNull GuiGraphics ctx, @NotNull Function1<? super OmniMatrixStack, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        float scaleFactor = (float)OmniResolution.getScaleFactor();
        int width = OmniResolution.getViewportWidth();
        int height = OmniResolution.getViewportHeight();
        TextureAllocation textureAllocation = textureAllocator.allocate(width, height);
        CachedOrthoProjectionMatrixBuffer cachedOrthoProjectionMatrixBuffer = cachedProjectionMatrix;
        if (cachedOrthoProjectionMatrixBuffer == null) {
            CachedOrthoProjectionMatrixBuffer cachedOrthoProjectionMatrixBuffer2;
            CachedOrthoProjectionMatrixBuffer it = cachedOrthoProjectionMatrixBuffer2 = new CachedOrthoProjectionMatrixBuffer("Immediately rendered screen", 1000.0f, 21000.0f, true);
            boolean bl = false;
            cachedProjectionMatrix = it;
            cachedOrthoProjectionMatrixBuffer = cachedOrthoProjectionMatrixBuffer2;
        }
        CachedOrthoProjectionMatrixBuffer projectionMatrix = cachedOrthoProjectionMatrixBuffer;
        GpuBufferSlice prevProjectionBuffer = RenderSystem.getProjectionMatrixBuffer();
        ProjectionType prevProjectionType = RenderSystem.getProjectionType();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)projectionMatrix.getBuffer((float)width / scaleFactor, (float)height / scaleFactor), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        GpuTextureView prevColorOverride = RenderSystem.outputColorTextureOverride;
        GpuTextureView prevDepthOverride = RenderSystem.outputDepthTextureOverride;
        RenderSystem.outputColorTextureOverride = textureAllocation.getColorTextureView();
        RenderSystem.outputDepthTextureOverride = textureAllocation.getDepthTextureView();
        OmniMatrixStack stack = new OmniMatrixStack();
        stack.translate(0.0f, 0.0f, -10000.0f);
        stack.scale(1.0f / scaleFactor, 1.0f / scaleFactor, 0.0f);
        block.invoke((Object)stack);
        RenderSystem.outputColorTextureOverride = prevColorOverride;
        RenderSystem.outputDepthTextureOverride = prevDepthOverride;
        RenderSystem.setProjectionMatrix((GpuBufferSlice)prevProjectionBuffer, (ProjectionType)prevProjectionType);
        ResourceLocation identifier = OmniIdentifier.create("omnicore", "__temporary_screen_render__");
        OmniTextureManager.Companion.getINSTANCE().registerTexture(identifier, new AbstractTexture(textureAllocation){
            {
                this.textureView = $textureAllocation.getColorTextureView();
            }

            public void close() {
            }
        });
        ctx.pose().pushMatrix();
        ctx.blit(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, identifier, 0, 0, 0.0f, (float)height, width, height, width, -height, width, height);
        ctx.pose().popMatrix();
        OmniTextureManager.Companion.getINSTANCE().destroyTexture(identifier);
    }

    @JvmStatic
    public static final void render(@NotNull ScreenEvent.Render event, @NotNull Function1<? super OmniMatrixStack, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ImmediateScreenRenderer.render(event.getContext(), block);
    }

    private static final Unit textureAllocator$lambda$0() {
        CachedOrthoProjectionMatrixBuffer cachedOrthoProjectionMatrixBuffer = cachedProjectionMatrix;
        if (cachedOrthoProjectionMatrixBuffer != null) {
            cachedOrthoProjectionMatrixBuffer.close();
        }
        cachedProjectionMatrix = null;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TemporaryTextureAllocator access$getTextureAllocator$p() {
        return textureAllocator;
    }

    static {
        textureAllocator = new TemporaryTextureAllocator((Function0<Unit>)((Function0)ImmediateScreenRenderer::textureAllocator$lambda$0));
    }
}

