/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import dev.deftu.omnicore.client.render.OmniImage;
import dev.deftu.omnicore.client.render.OmniMatrixStack;
import dev.deftu.omnicore.client.render.OmniRenderEnv;
import dev.deftu.omnicore.client.render.OmniRenderState;
import dev.deftu.omnicore.client.render.OmniResolution;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.pipeline.DrawModes;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipeline;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipelineBuilder;
import dev.deftu.omnicore.client.render.pipeline.RenderPassBuilder;
import dev.deftu.omnicore.client.render.pipeline.VertexFormats;
import dev.deftu.omnicore.client.render.state.BlendEquation;
import dev.deftu.omnicore.client.render.state.BlendFunction;
import dev.deftu.omnicore.client.render.state.OmniManagedBlendState;
import dev.deftu.omnicore.client.render.state.OmniManagedDepthState;
import dev.deftu.omnicore.client.render.vertex.OmniBufferBuilder;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import dev.deftu.omnicore.common.OmniIdentifier;
import java.awt.Color;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0006\n\u0002\b\n\u0018\u0000 ?2\u00020\u0001:\u0001?B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0007J\u001d\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0007J\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u0003J-\u0010\u0010\u001a\u00028\u0000\"\u0004\b\u0000\u0010\f2\b\b\u0002\u0010\r\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J=\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u0003J\r\u0010\u001c\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\u0003J\r\u0010\u001d\u001a\u00020\b\u00a2\u0006\u0004\b\u001d\u0010\u0003J\r\u0010\u001e\u001a\u00020\b\u00a2\u0006\u0004\b\u001e\u0010\u0003J%\u0010 \u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!J\u0015\u0010 \u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0000\u00a2\u0006\u0004\b \u0010#J\u0015\u0010&\u001a\u00020\b2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b(\u0010\u0003R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0005\u0010*\u001a\u0004\b+\u0010,R$\u0010\u0006\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0006\u0010*\u001a\u0004\b-\u0010,R\u0016\u0010.\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010*R\u0016\u0010/\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010*R\u0016\u00100\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010*R\"\u0010\u001c\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\"\u0010\u001d\u001a\u0002068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010\u001e\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010*\u001a\u0004\b<\u0010,\"\u0004\b=\u0010>\u00a8\u0006@"}, d2={"Ldev/deftu/omnicore/client/render/OmniFramebuffer;", "", "<init>", "()V", "", "width", "height", "(II)V", "", "initialize", "resize", "delete", "T", "target", "Lkotlin/Function0;", "block", "withBound", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Ldev/deftu/omnicore/client/render/OmniMatrixStack;", "stack", "", "x", "y", "Ljava/awt/Color;", "color", "draw", "(Ldev/deftu/omnicore/client/render/OmniMatrixStack;FFFFLjava/awt/Color;)V", "clear", "clearColor", "clearDepth", "clearStencil", "otherFbo", "copyFrom", "(III)V", "other", "(Ldev/deftu/omnicore/client/render/OmniFramebuffer;)V", "Ljava/io/File;", "file", "writeToFile", "(Ljava/io/File;)V", "checkStatus", "value", "I", "getWidth", "()I", "getHeight", "fbo", "colorAttachment", "depthStencilAttachment", "Ljava/awt/Color;", "getClearColor", "()Ljava/awt/Color;", "setClearColor", "(Ljava/awt/Color;)V", "", "D", "getClearDepth", "()D", "setClearDepth", "(D)V", "getClearStencil", "setClearStencil", "(I)V", "Companion", "OmniCore"})
public final class OmniFramebuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int width;
    private int height;
    private int fbo = -1;
    private int colorAttachment = -1;
    private int depthStencilAttachment = -1;
    @NotNull
    private Color clearColor = new Color(0, 0, 0, 0);
    private double clearDepth = 1.0;
    private int clearStencil;
    @NotNull
    private static final Lazy<OmniRenderPipeline> PIPELINE$delegate = LazyKt.lazy(OmniFramebuffer::PIPELINE_delegate$lambda$27);

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Color getClearColor() {
        return this.clearColor;
    }

    public final void setClearColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.clearColor = color;
    }

    public final double getClearDepth() {
        return this.clearDepth;
    }

    public final void setClearDepth(double d) {
        this.clearDepth = d;
    }

    public final int getClearStencil() {
        return this.clearStencil;
    }

    public final void setClearStencil(int n) {
        this.clearStencil = n;
    }

    public OmniFramebuffer() {
        this(OmniResolution.getViewportWidth(), OmniResolution.getViewportHeight());
    }

    public OmniFramebuffer(int width, int height) {
        this.resize(width, height);
    }

    public final void initialize(int width, int height) {
        this.width = width;
        this.height = height;
        this.colorAttachment = OmniTextureManager.Companion.generateTexture();
        OmniTextureManager.Companion.configureTexture(this.colorAttachment, () -> OmniFramebuffer.initialize$lambda$0(width, height));
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::initialize$lambda$1));
        this.depthStencilAttachment = OmniTextureManager.Companion.generateTexture();
        OmniTextureManager.Companion.configureTexture(this.depthStencilAttachment, () -> OmniFramebuffer.initialize$lambda$2(width, height));
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::initialize$lambda$3));
        this.fbo = Companion.genFramebuffer();
        Companion.withFramebuffer(this.fbo, () -> OmniFramebuffer.initialize$lambda$4(this));
        this.checkStatus();
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::initialize$lambda$5));
    }

    public final void resize(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.delete();
        this.initialize(width, height);
    }

    public final void delete() {
        if (this.depthStencilAttachment != -1) {
            OmniTextureManager.Companion.deleteTexture(this.depthStencilAttachment);
            this.depthStencilAttachment = -1;
            OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::delete$lambda$6));
        }
        if (this.colorAttachment != -1) {
            OmniTextureManager.Companion.deleteTexture(this.colorAttachment);
            this.colorAttachment = -1;
            OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::delete$lambda$7));
        }
        if (this.fbo != -1) {
            Companion.deleteFramebuffer(this.fbo);
            this.fbo = -1;
            OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::delete$lambda$8));
        }
    }

    @JvmOverloads
    public final <T> T withBound(int target, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return Companion.withFramebuffer(target, this.fbo, block);
    }

    public static /* synthetic */ Object withBound$default(OmniFramebuffer omniFramebuffer, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 36160;
        }
        return omniFramebuffer.withBound(n, function0);
    }

    public final void draw(@NotNull OmniMatrixStack stack, float x, float y, float width, float height, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        stack.push();
        stack.scale(1.0f, 1.0f, 50.0f);
        OmniBufferBuilder buffer = OmniBufferBuilder.Companion.create(DrawModes.QUADS, VertexFormats.POSITION_TEXTURE_COLOR);
        buffer.vertex(stack, x, y + height, 0.0).texture(0.0, 0.0).color(color).next();
        buffer.vertex(stack, x + width, y + height, 0.0).texture(1.0, 0.0).color(color).next();
        buffer.vertex(stack, x + width, y, 0.0).texture(1.0, 1.0).color(color).next();
        buffer.vertex(stack, x, y, 0.0).texture(0.0, 1.0).color(color).next();
        OmniBuiltBuffer omniBuiltBuffer = buffer.build();
        if (omniBuiltBuffer != null) {
            omniBuiltBuffer.drawWithCleanup(OmniFramebuffer.Companion.getPIPELINE(), (Function1<? super RenderPassBuilder, Unit>)((Function1)arg_0 -> OmniFramebuffer.draw$lambda$9(this, arg_0)));
        }
        stack.pop();
    }

    public final void clear() {
        OmniFramebuffer.withBound$default(this, 0, () -> OmniFramebuffer.clear$lambda$11(this), 1, null);
    }

    public final void clearColor() {
        OmniFramebuffer.withBound$default(this, 0, () -> OmniFramebuffer.clearColor$lambda$13(this), 1, null);
    }

    public final void clearDepth() {
        OmniFramebuffer.withBound$default(this, 0, () -> OmniFramebuffer.clearDepth$lambda$15(this), 1, null);
    }

    public final void clearStencil() {
        OmniFramebuffer.withBound$default(this, 0, () -> OmniFramebuffer.clearStencil$lambda$17(this), 1, null);
    }

    public final void copyFrom(int width, int height, int otherFbo) {
        if (this.width != width || this.height != height) {
            this.resize(width, height);
        }
        Companion.withFramebuffer(36008, otherFbo, () -> OmniFramebuffer.copyFrom$lambda$20(this, width, height));
    }

    public final void copyFrom(@NotNull OmniFramebuffer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.width != other.width || this.height != other.height) {
            this.resize(other.width, other.height);
        }
        other.withBound(36008, () -> OmniFramebuffer.copyFrom$lambda$23(this, other));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OmniTextureManager.Companion.bindTexture(this.colorAttachment);
        AutoCloseable autoCloseable = new OmniImage(this.width, this.height);
        Throwable throwable = null;
        try {
            OmniImage image = (OmniImage)autoCloseable;
            boolean bl = false;
            OmniImage.loadFromBoundTexture$default(image, 0, 1, null);
            image.flipY();
            image.saveTo(file);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        OmniTextureManager.Companion.bindTexture(0);
    }

    private final void checkStatus() {
        OmniFramebuffer.withBound$default(this, 0, OmniFramebuffer::checkStatus$lambda$25, 1, null);
    }

    @JvmOverloads
    public final <T> T withBound(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)OmniFramebuffer.withBound$default(this, 0, block, 1, null);
    }

    private static final void initialize$lambda$0(int $width, int $height) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)$width, (int)$height, (int)0, (int)6408, (int)5121, null);
    }

    private static final Unit initialize$lambda$1(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to set up color attachment: " + it).toString());
    }

    private static final void initialize$lambda$2(int $width, int $height) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)34892, (int)0);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)35056, (int)$width, (int)$height, (int)0, (int)34041, (int)34042, null);
    }

    private static final Unit initialize$lambda$3(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to set up depth attachment: " + it).toString());
    }

    private static final Unit initialize$lambda$4(OmniFramebuffer this$0) {
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this$0.colorAttachment, (int)0);
        GL30.glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)this$0.depthStencilAttachment, (int)0);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$5(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to set up framebuffer: " + it).toString());
    }

    private static final Unit delete$lambda$6(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to delete depth attachment: " + it).toString());
    }

    private static final Unit delete$lambda$7(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to delete color attachment: " + it).toString());
    }

    private static final Unit delete$lambda$8(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to delete framebuffer: " + it).toString());
    }

    private static final Unit draw$lambda$9(OmniFramebuffer this$0, RenderPassBuilder $this$drawWithCleanup) {
        Intrinsics.checkNotNullParameter((Object)$this$drawWithCleanup, (String)"$this$drawWithCleanup");
        $this$drawWithCleanup.texture(0, this$0.colorAttachment);
        return Unit.INSTANCE;
    }

    private static final Unit clear$lambda$11$lambda$10(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to clear framebuffer: " + it).toString());
    }

    private static final Unit clear$lambda$11(OmniFramebuffer this$0) {
        OmniRenderState.setClearColor((float)this$0.clearColor.getRed() / 255.0f, (float)this$0.clearColor.getGreen() / 255.0f, (float)this$0.clearColor.getBlue() / 255.0f, (float)this$0.clearColor.getAlpha() / 255.0f);
        OmniRenderState.setClearDepth(this$0.clearDepth);
        OmniRenderState.setClearStencil(this$0.clearStencil);
        OmniRenderState.ClearMask[] clearMaskArray = new OmniRenderState.ClearMask[]{OmniRenderState.ClearMask.COLOR, OmniRenderState.ClearMask.DEPTH, OmniRenderState.ClearMask.STENCIL};
        OmniRenderState.clear(clearMaskArray);
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::clear$lambda$11$lambda$10));
        return Unit.INSTANCE;
    }

    private static final Unit clearColor$lambda$13$lambda$12(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to clear color buffer: " + it).toString());
    }

    private static final Unit clearColor$lambda$13(OmniFramebuffer this$0) {
        OmniRenderState.setClearColor((float)this$0.clearColor.getRed() / 255.0f, (float)this$0.clearColor.getGreen() / 255.0f, (float)this$0.clearColor.getBlue() / 255.0f, (float)this$0.clearColor.getAlpha() / 255.0f);
        OmniRenderState.ClearMask[] clearMaskArray = new OmniRenderState.ClearMask[]{OmniRenderState.ClearMask.COLOR};
        OmniRenderState.clear(clearMaskArray);
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::clearColor$lambda$13$lambda$12));
        return Unit.INSTANCE;
    }

    private static final Unit clearDepth$lambda$15$lambda$14(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to clear depth buffer: " + it).toString());
    }

    private static final Unit clearDepth$lambda$15(OmniFramebuffer this$0) {
        OmniRenderState.setClearDepth(this$0.clearDepth);
        OmniRenderState.ClearMask[] clearMaskArray = new OmniRenderState.ClearMask[]{OmniRenderState.ClearMask.DEPTH};
        OmniRenderState.clear(clearMaskArray);
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::clearDepth$lambda$15$lambda$14));
        return Unit.INSTANCE;
    }

    private static final Unit clearStencil$lambda$17$lambda$16(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to clear stencil buffer: " + it).toString());
    }

    private static final Unit clearStencil$lambda$17(OmniFramebuffer this$0) {
        OmniRenderState.setClearStencil(this$0.clearStencil);
        OmniRenderState.ClearMask[] clearMaskArray = new OmniRenderState.ClearMask[]{OmniRenderState.ClearMask.STENCIL};
        OmniRenderState.clear(clearMaskArray);
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::clearStencil$lambda$17$lambda$16));
        return Unit.INSTANCE;
    }

    private static final Unit copyFrom$lambda$20$lambda$19$lambda$18(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to copy (blit) framebuffer: " + it).toString());
    }

    private static final Unit copyFrom$lambda$20$lambda$19(int $width, int $height, OmniFramebuffer this$0) {
        GL30.glBlitFramebuffer((int)0, (int)0, (int)$width, (int)$height, (int)0, (int)0, (int)this$0.width, (int)this$0.height, (int)17664, (int)9728);
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::copyFrom$lambda$20$lambda$19$lambda$18));
        return Unit.INSTANCE;
    }

    private static final Unit copyFrom$lambda$20(OmniFramebuffer this$0, int $width, int $height) {
        this$0.withBound(36009, () -> OmniFramebuffer.copyFrom$lambda$20$lambda$19($width, $height, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit copyFrom$lambda$23$lambda$22$lambda$21(OmniRenderEnv.GlError it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        throw new IllegalStateException(("Failed to copy (blit) framebuffer: " + it).toString());
    }

    private static final Unit copyFrom$lambda$23$lambda$22(OmniFramebuffer $other, OmniFramebuffer this$0) {
        GL30.glBlitFramebuffer((int)0, (int)0, (int)$other.width, (int)$other.height, (int)0, (int)0, (int)this$0.width, (int)this$0.height, (int)17664, (int)9728);
        OmniRenderEnv.getError().ifPresent((Function1<? super OmniRenderEnv.GlError, Unit>)((Function1)OmniFramebuffer::copyFrom$lambda$23$lambda$22$lambda$21));
        return Unit.INSTANCE;
    }

    private static final Unit copyFrom$lambda$23(OmniFramebuffer this$0, OmniFramebuffer $other) {
        this$0.withBound(36009, () -> OmniFramebuffer.copyFrom$lambda$23$lambda$22($other, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit checkStatus$lambda$25() {
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            String message = switch (status) {
                case 36054 -> "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 36055 -> "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 36059 -> "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
                case 36060 -> "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
                case 36061 -> "GL_FRAMEBUFFER_UNSUPPORTED";
                case 36182 -> "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                default -> "Unknown error";
            };
            String string = Integer.toString(status, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new IllegalStateException(("Framebuffer is not complete: " + message + " (" + string + ")").toString());
        }
        return Unit.INSTANCE;
    }

    private static final OmniRenderPipeline PIPELINE_delegate$lambda$27() {
        OmniRenderPipelineBuilder omniRenderPipelineBuilder;
        OmniRenderPipelineBuilder $this$PIPELINE_delegate_u24lambda_u2427_u24lambda_u2426 = omniRenderPipelineBuilder = OmniRenderPipeline.Companion.builderWithDefaultShader(OmniIdentifier.create("omnicore", "omniframebuffer"), VertexFormats.POSITION_TEXTURE_COLOR, DrawModes.QUADS);
        boolean bl = false;
        $this$PIPELINE_delegate_u24lambda_u2427_u24lambda_u2426.blendState = OmniManagedBlendState.Companion.asEnabled(BlendEquation.Companion.active(), BlendFunction.LIGHTMAP);
        $this$PIPELINE_delegate_u24lambda_u2427_u24lambda_u2426.depthState = OmniManagedDepthState.DISABLED;
        return omniRenderPipelineBuilder.build();
    }

    @JvmStatic
    public static final <T> T withFramebuffer(int target, int fbo, @NotNull Function0<? extends T> block) {
        return Companion.withFramebuffer(target, fbo, block);
    }

    @JvmStatic
    public static final <T> T withFramebuffer(int fbo, @NotNull Function0<? extends T> block) {
        return Companion.withFramebuffer(fbo, block);
    }

    @JvmStatic
    public static final int genFramebuffer() {
        return Companion.genFramebuffer();
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindFramebuffer(int target, int fbo) {
        return Companion.bindFramebuffer(target, fbo);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindFramebuffer(int fbo) {
        return Companion.bindFramebuffer(fbo);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindReadFramebuffer(int fbo) {
        return Companion.bindReadFramebuffer(fbo);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindDrawFramebuffer(int fbo) {
        return Companion.bindDrawFramebuffer(fbo);
    }

    @JvmStatic
    public static final void deleteFramebuffer(int fbo) {
        Companion.deleteFramebuffer(fbo);
    }

    @JvmStatic
    @NotNull
    public static final OmniFramebuffer createFrom(@NotNull OmniFramebuffer other) {
        return Companion.createFrom(other);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\n\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0007\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\u000f\u0010\r\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001b\u0010 \u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Ldev/deftu/omnicore/client/render/OmniFramebuffer$Companion;", "", "<init>", "()V", "T", "", "target", "fbo", "Lkotlin/Function0;", "block", "withFramebuffer", "(IILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "genFramebuffer", "()I", "", "bindFramebuffer", "(II)Lkotlin/jvm/functions/Function0;", "(I)Lkotlin/jvm/functions/Function0;", "bindReadFramebuffer", "bindDrawFramebuffer", "deleteFramebuffer", "(I)V", "Ldev/deftu/omnicore/client/render/OmniFramebuffer;", "other", "createFrom", "(Ldev/deftu/omnicore/client/render/OmniFramebuffer;)Ldev/deftu/omnicore/client/render/OmniFramebuffer;", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "PIPELINE$delegate", "Lkotlin/Lazy;", "getPIPELINE", "()Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "PIPELINE", "OmniCore"})
    public static final class Companion {
        private Companion() {
        }

        private final OmniRenderPipeline getPIPELINE() {
            Lazy lazy = PIPELINE$delegate;
            return (OmniRenderPipeline)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T withFramebuffer(int target, int fbo, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Function0<Unit> unbind = this.bindFramebuffer(target, fbo);
            try {
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                unbind.invoke();
            }
        }

        @JvmStatic
        public final <T> T withFramebuffer(int fbo, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.withFramebuffer(36160, fbo, block);
        }

        @JvmStatic
        public final int genFramebuffer() {
            return GL30.glGenFramebuffers();
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindFramebuffer(int target, int fbo) {
            int prevReadFramebuffer = GL11.glGetInteger((int)36010);
            int prevDrawFramebuffer = GL11.glGetInteger((int)36006);
            GL30.glBindFramebuffer((int)target, (int)fbo);
            return () -> Companion.bindFramebuffer$lambda$0(prevReadFramebuffer, prevDrawFramebuffer);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindFramebuffer(int fbo) {
            return this.bindFramebuffer(36160, fbo);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindReadFramebuffer(int fbo) {
            return this.bindFramebuffer(36008, fbo);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindDrawFramebuffer(int fbo) {
            return this.bindFramebuffer(36009, fbo);
        }

        @JvmStatic
        public final void deleteFramebuffer(int fbo) {
            GL30.glDeleteFramebuffers((int)fbo);
        }

        @JvmStatic
        @NotNull
        public final OmniFramebuffer createFrom(@NotNull OmniFramebuffer other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            OmniFramebuffer result = new OmniFramebuffer(other.getWidth(), other.getHeight());
            result.copyFrom(other);
            return result;
        }

        private static final Unit bindFramebuffer$lambda$0(int $prevReadFramebuffer, int $prevDrawFramebuffer) {
            Companion.bindReadFramebuffer($prevReadFramebuffer);
            Companion.bindDrawFramebuffer($prevDrawFramebuffer);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

