/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import dev.deftu.omnicore.common.OmniJsonKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/deftu/omnicore/common/OmniJson;", "", "<init>", "()V", "", "json", "Lcom/google/gson/JsonElement;", "parse", "(Ljava/lang/String;)Lcom/google/gson/JsonElement;", "parseSafe", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/GsonBuilder;", "newGsonBuilder", "(Lcom/google/gson/Gson;)Lcom/google/gson/GsonBuilder;", "withPrettyPrinting", "(Lcom/google/gson/Gson;)Lcom/google/gson/Gson;", "OmniCore"})
public final class OmniJson {
    @NotNull
    public static final OmniJson INSTANCE = new OmniJson();

    private OmniJson() {
    }

    @JvmStatic
    @NotNull
    public static final JsonElement parse(@NotNull String json) throws JsonSyntaxException {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonElement jsonElement = JsonParser.parseString((String)json);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseString(...)");
        return jsonElement;
    }

    @JvmStatic
    @Nullable
    public static final JsonElement parseSafe(@NotNull String json) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            jsonElement = OmniJson.parse(json);
        }
        catch (JsonSyntaxException e) {
            jsonElement = null;
        }
        return jsonElement;
    }

    @JvmStatic
    @NotNull
    public static final GsonBuilder newGsonBuilder(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        GsonBuilder gsonBuilder = gson.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)gsonBuilder, (String)"newBuilder(...)");
        return gsonBuilder;
    }

    @JvmStatic
    @NotNull
    public static final Gson withPrettyPrinting(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Gson gson2 = OmniJsonKt.newGsonBuilder(gson).setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"create(...)");
        return gson2;
    }
}

