/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.shaders;

import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.state.OmniManagedBlendState;
import dev.deftu.omnicore.client.shaders.DirectSamplerUniform;
import dev.deftu.omnicore.client.shaders.DirectUniform;
import dev.deftu.omnicore.client.shaders.IntUniform;
import dev.deftu.omnicore.client.shaders.MatrixUniform;
import dev.deftu.omnicore.client.shaders.OmniShader;
import dev.deftu.omnicore.client.shaders.SamplerUniform;
import dev.deftu.omnicore.client.shaders.Vec2Uniform;
import dev.deftu.omnicore.client.shaders.Vec3Uniform;
import dev.deftu.omnicore.client.shaders.Vec4Uniform;
import dev.deftu.omnicore.client.shaders.VecUniform;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b$\u0010%J!\u0010*\u001a\u00020\t2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0&H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010/\u001a\u00020\t2\u0006\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020#H\u0000\u00a2\u0006\u0004\b-\u0010.J\u000f\u00100\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b0\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00101\u001a\u0004\b2\u00103R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00101\u001a\u0004\b4\u00103R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00105\u001a\u0004\b6\u00107R\u0016\u00108\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010:\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u00109R\u0016\u0010;\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00109R\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020=0<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\"\u0010A\u001a\u00020@8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR$\u0010H\u001a\u00020@2\u0006\u0010G\u001a\u00020@8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bH\u0010B\u001a\u0004\bI\u0010DR\u0016\u0010J\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u00109R\"\u0010K\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010?R\u0018\u0010L\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u00105\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006M"}, d2={"Ldev/deftu/omnicore/client/shaders/GlShader;", "Ldev/deftu/omnicore/client/shaders/OmniShader;", "", "vert", "frag", "Ldev/deftu/omnicore/client/render/state/OmniManagedBlendState;", "blend", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ldev/deftu/omnicore/client/render/state/OmniManagedBlendState;)V", "", "bind", "()V", "unbind", "name", "Ldev/deftu/omnicore/client/shaders/IntUniform;", "getIntUniformOrNull", "(Ljava/lang/String;)Ldev/deftu/omnicore/client/shaders/IntUniform;", "Ldev/deftu/omnicore/client/shaders/VecUniform;", "getVecUniformOrNull", "(Ljava/lang/String;)Ldev/deftu/omnicore/client/shaders/VecUniform;", "Ldev/deftu/omnicore/client/shaders/Vec2Uniform;", "getVec2UniformOrNull", "(Ljava/lang/String;)Ldev/deftu/omnicore/client/shaders/Vec2Uniform;", "Ldev/deftu/omnicore/client/shaders/Vec3Uniform;", "getVec3UniformOrNull", "(Ljava/lang/String;)Ldev/deftu/omnicore/client/shaders/Vec3Uniform;", "Ldev/deftu/omnicore/client/shaders/Vec4Uniform;", "getVec4UniformOrNull", "(Ljava/lang/String;)Ldev/deftu/omnicore/client/shaders/Vec4Uniform;", "Ldev/deftu/omnicore/client/shaders/MatrixUniform;", "getMatrixUniformOrNull", "(Ljava/lang/String;)Ldev/deftu/omnicore/client/shaders/MatrixUniform;", "Ldev/deftu/omnicore/client/shaders/SamplerUniform;", "getSamplerUniformOrNull", "(Ljava/lang/String;)Ldev/deftu/omnicore/client/shaders/SamplerUniform;", "", "getUniformLocation", "(Ljava/lang/String;)Ljava/lang/Integer;", "Lkotlin/Function0;", "block", "withProgram$OmniCore", "(Lkotlin/jvm/functions/Function0;)V", "withProgram", "textureUnit", "texture", "bindTexture$OmniCore", "(II)V", "bindTexture", "setupShader", "Ljava/lang/String;", "getVert", "()Ljava/lang/String;", "getFrag", "Ldev/deftu/omnicore/client/render/state/OmniManagedBlendState;", "getBlend", "()Ldev/deftu/omnicore/client/render/state/OmniManagedBlendState;", "program", "I", "vertShader", "fragShader", "", "Ldev/deftu/omnicore/client/shaders/DirectSamplerUniform;", "samplers", "Ljava/util/Map;", "", "usable", "Z", "getUsable", "()Z", "setUsable", "(Z)V", "value", "bound", "getBound", "prevActiveTexture", "prevTextureBindings", "prevBlendState", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nGlShader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlShader.kt\ndev/deftu/omnicore/client/shaders/GlShader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class GlShader
implements OmniShader {
    @NotNull
    private final String vert;
    @NotNull
    private final String frag;
    @NotNull
    private final OmniManagedBlendState blend;
    private int program;
    private int vertShader;
    private int fragShader;
    @NotNull
    private Map<String, DirectSamplerUniform> samplers;
    private boolean usable;
    private boolean bound;
    private int prevActiveTexture;
    @NotNull
    private Map<Integer, Integer> prevTextureBindings;
    @Nullable
    private OmniManagedBlendState prevBlendState;

    public GlShader(@NotNull String vert, @NotNull String frag, @NotNull OmniManagedBlendState blend) {
        Intrinsics.checkNotNullParameter((Object)vert, (String)"vert");
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        Intrinsics.checkNotNullParameter((Object)blend, (String)"blend");
        this.vert = vert;
        this.frag = frag;
        this.blend = blend;
        this.program = OmniShader.Companion.createProgram();
        this.vertShader = OmniShader.Companion.createShader(35633);
        this.fragShader = OmniShader.Companion.createShader(35632);
        this.samplers = new LinkedHashMap();
        this.prevTextureBindings = new LinkedHashMap();
        this.setupShader();
    }

    @NotNull
    public final String getVert() {
        return this.vert;
    }

    @NotNull
    public final String getFrag() {
        return this.frag;
    }

    @NotNull
    public final OmniManagedBlendState getBlend() {
        return this.blend;
    }

    @Override
    public boolean getUsable() {
        return this.usable;
    }

    public void setUsable(boolean bl) {
        this.usable = bl;
    }

    public final boolean getBound() {
        return this.bound;
    }

    @Override
    public void bind() {
        this.prevActiveTexture = GL11.glGetInteger((int)34016);
        for (DirectSamplerUniform sampler : this.samplers.values()) {
            this.bindTexture$OmniCore(sampler.getTextureUnit(), sampler.getTexture());
        }
        this.prevBlendState = OmniManagedBlendState.Companion.active();
        this.blend.activate();
        OmniShader.Companion.useProgram(this.program);
        this.bound = true;
    }

    @Override
    public void unbind() {
        for (Map.Entry<Integer, Integer> entry : this.prevTextureBindings.entrySet()) {
            int textureUnit = ((Number)entry.getKey()).intValue();
            int texture = ((Number)entry.getValue()).intValue();
            OmniTextureManager.Companion.setActiveTexture(33984 + textureUnit);
            OmniTextureManager.Companion.bindTexture(texture);
        }
        this.prevTextureBindings.clear();
        OmniTextureManager.Companion.setActiveTexture(this.prevActiveTexture);
        OmniManagedBlendState omniManagedBlendState = this.prevBlendState;
        if (omniManagedBlendState != null) {
            omniManagedBlendState.activate();
        }
        OmniShader.Companion.useProgram(0);
        this.bound = false;
    }

    @Override
    @Nullable
    public IntUniform getIntUniformOrNull(@NotNull String name) {
        DirectUniform directUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean $i$f$getIntUniformOrNull$stub_for_inlining = false;
            boolean bl = false;
            directUniform = new DirectUniform(p0);
        } else {
            directUniform = null;
        }
        return directUniform;
    }

    @Override
    @Nullable
    public VecUniform getVecUniformOrNull(@NotNull String name) {
        DirectUniform directUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean $i$f$getVecUniformOrNull$stub_for_inlining$0 = false;
            boolean bl = false;
            directUniform = new DirectUniform(p0);
        } else {
            directUniform = null;
        }
        return directUniform;
    }

    @Override
    @Nullable
    public Vec2Uniform getVec2UniformOrNull(@NotNull String name) {
        DirectUniform directUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean $i$f$getVec2UniformOrNull$stub_for_inlining$1 = false;
            boolean bl = false;
            directUniform = new DirectUniform(p0);
        } else {
            directUniform = null;
        }
        return directUniform;
    }

    @Override
    @Nullable
    public Vec3Uniform getVec3UniformOrNull(@NotNull String name) {
        DirectUniform directUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean $i$f$getVec3UniformOrNull$stub_for_inlining$2 = false;
            boolean bl = false;
            directUniform = new DirectUniform(p0);
        } else {
            directUniform = null;
        }
        return directUniform;
    }

    @Override
    @Nullable
    public Vec4Uniform getVec4UniformOrNull(@NotNull String name) {
        DirectUniform directUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean $i$f$getVec4UniformOrNull$stub_for_inlining$3 = false;
            boolean bl = false;
            directUniform = new DirectUniform(p0);
        } else {
            directUniform = null;
        }
        return directUniform;
    }

    @Override
    @Nullable
    public MatrixUniform getMatrixUniformOrNull(@NotNull String name) {
        DirectUniform directUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean $i$f$getMatrixUniformOrNull$stub_for_inlining$4 = false;
            boolean bl = false;
            directUniform = new DirectUniform(p0);
        } else {
            directUniform = null;
        }
        return directUniform;
    }

    @Override
    @Nullable
    public SamplerUniform getSamplerUniformOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DirectSamplerUniform directSamplerUniform = this.samplers.get(name);
        if (directSamplerUniform != null) {
            DirectSamplerUniform it = directSamplerUniform;
            boolean bl = false;
            return it;
        }
        Integer n = this.getUniformLocation(name);
        if (n == null) {
            return null;
        }
        int location = n;
        DirectSamplerUniform uniform = new DirectSamplerUniform(location, this.samplers.size(), this);
        this.samplers.put(name, uniform);
        return uniform;
    }

    private final Integer getUniformLocation(String name) {
        int location = OmniShader.Companion.getUniformLocation(this.program, name);
        return location == -1 ? null : Integer.valueOf(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withProgram$OmniCore(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withProgram$OmniCore = false;
        if (!this.getBound()) {
            int previousProgram = OmniShader.Companion.getCurrentProgram();
            try {
                OmniShader.Companion.useProgram(this.program);
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                OmniShader.Companion.useProgram(previousProgram);
                InlineMarker.finallyEnd((int)1);
            }
        } else {
            block.invoke();
        }
    }

    public final void bindTexture$OmniCore(int textureUnit, int texture) {
        OmniTextureManager.Companion.setActiveTexture(33984 + textureUnit);
        this.prevTextureBindings.computeIfAbsent(textureUnit, arg_0 -> GlShader.bindTexture$lambda$7(GlShader::bindTexture$lambda$6, arg_0));
        OmniTextureManager.Companion.bindTexture(texture);
    }

    private final void setupShader() {
        String log;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)this.vertShader, (Object)this.vert), TuplesKt.to((Object)this.fragShader, (Object)this.frag)};
        for (Pair[] pairArray2 : CollectionsKt.listOf((Object[])pairArray2)) {
            int shader = ((Number)pairArray2.component1()).intValue();
            String source = (String)pairArray2.component2();
            OmniShader.Companion.shaderSource(shader, source);
            OmniShader.Companion.compileShader(shader);
            if (OmniShader.Companion.getShader(shader, 35713) != 1) {
                String log2 = OmniShader.Companion.getShaderInfoLog(shader, Short.MAX_VALUE);
                throw new IllegalStateException("Shader failed to compile: " + log2);
            }
            OmniShader.Companion.attachShader(this.program, shader);
        }
        OmniShader.Companion.linkProgram(this.program);
        OmniShader.Companion.detachShader(this.program, this.vertShader);
        OmniShader.Companion.detachShader(this.program, this.fragShader);
        OmniShader.Companion.deleteShader(this.vertShader);
        OmniShader.Companion.deleteShader(this.fragShader);
        if (OmniShader.Companion.getProgram(this.program, 35714) != 1) {
            log = OmniShader.Companion.getProgramInfoLog(this.program, Short.MAX_VALUE);
            throw new IllegalStateException("Shader failed to link: " + log);
        }
        OmniShader.Companion.validateProgram(this.program);
        if (OmniShader.Companion.getProgramValidateStatus(this.program) != 1) {
            log = OmniShader.Companion.getProgramInfoLog(this.program, Short.MAX_VALUE);
            throw new IllegalStateException("Shader failed to validate: " + log);
        }
        this.setUsable(true);
    }

    @Override
    @NotNull
    public IntUniform getIntUniform(@NotNull String name) {
        return OmniShader.DefaultImpls.getIntUniform(this, name);
    }

    @Override
    @NotNull
    public VecUniform getVecUniform(@NotNull String name) {
        return OmniShader.DefaultImpls.getVecUniform(this, name);
    }

    @Override
    @NotNull
    public Vec2Uniform getVec2Uniform(@NotNull String name) {
        return OmniShader.DefaultImpls.getVec2Uniform(this, name);
    }

    @Override
    @NotNull
    public Vec3Uniform getVec3Uniform(@NotNull String name) {
        return OmniShader.DefaultImpls.getVec3Uniform(this, name);
    }

    @Override
    @NotNull
    public Vec4Uniform getVec4Uniform(@NotNull String name) {
        return OmniShader.DefaultImpls.getVec4Uniform(this, name);
    }

    @Override
    @NotNull
    public MatrixUniform getMatrixUniform(@NotNull String name) {
        return OmniShader.DefaultImpls.getMatrixUniform(this, name);
    }

    @Override
    @NotNull
    public SamplerUniform getSamplerUniform(@NotNull String name) {
        return OmniShader.DefaultImpls.getSamplerUniform(this, name);
    }

    private static final Integer bindTexture$lambda$6(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GL11.glGetInteger((int)32873);
    }

    private static final Integer bindTexture$lambda$7(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }
}

