/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render;

import dev.deftu.omnicore.client.render.OmniImage;
import dev.deftu.omnicore.client.render.OmniMatrixStack;
import dev.deftu.omnicore.client.render.OmniResolution;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.pipeline.DrawModes;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipeline;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipelineBuilder;
import dev.deftu.omnicore.client.render.pipeline.RenderPassBuilder;
import dev.deftu.omnicore.client.render.pipeline.VertexFormats;
import dev.deftu.omnicore.client.render.state.OmniManagedBlendState;
import dev.deftu.omnicore.client.render.state.OmniManagedScissorState;
import dev.deftu.omnicore.client.render.texture.GlGpuTexture;
import dev.deftu.omnicore.client.render.texture.GpuTexture;
import dev.deftu.omnicore.client.render.texture.ManagedGpuTexture;
import dev.deftu.omnicore.client.render.vertex.OmniBufferBuilder;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import dev.deftu.omnicore.common.OmniIdentifier;
import java.awt.Color;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 @2\u00060\u0001j\u0002`\u0002:\u0001@B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\u0012\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013JZ\u0010\u0019\u001a\u00020\u000b2K\u0010\u0011\u001aG\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ=\u0010!\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J%\u0010'\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0003\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010+\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010/\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b/\u0010\rJ\u000f\u00100\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b0\u0010.R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00101R\u0014\u0010\b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00101R$\u0010\u0004\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00038\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0004\u00103\u001a\u0004\b4\u00105R$\u0010\u0005\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00038\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0005\u00103\u001a\u0004\b6\u00105R$\u00107\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00038\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b7\u00103\u001a\u0004\b8\u00105R$\u0010:\u001a\u0002092\u0006\u00102\u001a\u0002098\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R$\u0010>\u001a\u0002092\u0006\u00102\u001a\u0002098\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b>\u0010;\u001a\u0004\b?\u0010=\u00a8\u0006A"}, d2={"Ldev/deftu/omnicore/client/render/OmniFramebuffer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "width", "height", "Ldev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;", "colorFormat", "depthFormat", "<init>", "(IILdev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;Ldev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;)V", "", "resize", "(II)V", "T", "target", "Lkotlin/Function0;", "block", "withBound", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlin/Function3;", "Ldev/deftu/omnicore/client/render/OmniMatrixStack;", "Lkotlin/ParameterName;", "name", "matrixStack", "withBoundForRender", "(Lkotlin/jvm/functions/Function3;)V", "stack", "", "x", "y", "Ljava/awt/Color;", "color", "draw", "(Ldev/deftu/omnicore/client/render/OmniMatrixStack;FFFFLjava/awt/Color;)V", "clearColor", "", "clearDepth", "clearStencil", "clear", "(Ljava/awt/Color;DI)V", "Ljava/io/File;", "file", "writeToFile", "(Ljava/io/File;)V", "close", "()V", "initialize", "checkStatus", "Ldev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;", "value", "I", "getWidth", "()I", "getHeight", "id", "getId", "Ldev/deftu/omnicore/client/render/texture/GlGpuTexture;", "colorTexture", "Ldev/deftu/omnicore/client/render/texture/GlGpuTexture;", "getColorTexture", "()Ldev/deftu/omnicore/client/render/texture/GlGpuTexture;", "depthStencilTexture", "getDepthStencilTexture", "Companion", "OmniCore"})
public final class OmniFramebuffer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GpuTexture.TextureFormat colorFormat;
    @NotNull
    private final GpuTexture.TextureFormat depthFormat;
    private int width;
    private int height;
    private int id;
    private GlGpuTexture colorTexture;
    private GlGpuTexture depthStencilTexture;
    @NotNull
    private static final Lazy<OmniRenderPipeline> PIPELINE$delegate = LazyKt.lazy(OmniFramebuffer::PIPELINE_delegate$lambda$7);

    public OmniFramebuffer(int width, int height, @NotNull GpuTexture.TextureFormat colorFormat, @NotNull GpuTexture.TextureFormat depthFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorFormat), (String)"colorFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)depthFormat), (String)"depthFormat");
        this.colorFormat = colorFormat;
        this.depthFormat = depthFormat;
        this.id = -1;
        this.resize(width, height);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final GlGpuTexture getColorTexture() {
        GlGpuTexture glGpuTexture = this.colorTexture;
        if (glGpuTexture != null) {
            return glGpuTexture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"colorTexture");
        return null;
    }

    @NotNull
    public final GlGpuTexture getDepthStencilTexture() {
        GlGpuTexture glGpuTexture = this.depthStencilTexture;
        if (glGpuTexture != null) {
            return glGpuTexture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"depthStencilTexture");
        return null;
    }

    public final void resize(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.close();
        this.initialize(width, height);
    }

    @JvmOverloads
    public final <T> T withBound(int target, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.id == -1) {
            this.resize(this.width, this.height);
        }
        return Companion.withFramebuffer(target, this.id, block);
    }

    public static /* synthetic */ Object withBound$default(OmniFramebuffer omniFramebuffer, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 36160;
        }
        return omniFramebuffer.withBound(n, function0);
    }

    public final void withBoundForRender(@NotNull Function3<? super OmniMatrixStack, ? super Integer, ? super Integer, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OmniFramebuffer.withBound$default(this, 0, () -> OmniFramebuffer.withBoundForRender$lambda$0(this, block), 1, null);
    }

    public final void draw(@NotNull OmniMatrixStack stack, float x, float y, float width, float height, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        stack.push();
        stack.scale(1.0f, 1.0f, 50.0f);
        OmniBufferBuilder buffer = OmniBufferBuilder.Companion.create(DrawModes.QUADS, VertexFormats.POSITION_TEXTURE_COLOR);
        buffer.vertex(stack, x, y + height, 0.0).texture(0.0, 0.0).color(color).next();
        buffer.vertex(stack, x + width, y + height, 0.0).texture(1.0, 0.0).color(color).next();
        buffer.vertex(stack, x + width, y, 0.0).texture(1.0, 1.0).color(color).next();
        buffer.vertex(stack, x, y, 0.0).texture(0.0, 1.0).color(color).next();
        OmniBuiltBuffer omniBuiltBuffer = buffer.build();
        if (omniBuiltBuffer != null) {
            omniBuiltBuffer.drawWithCleanup(OmniFramebuffer.Companion.getPIPELINE(), (Function1<? super RenderPassBuilder, Unit>)((Function1)arg_0 -> OmniFramebuffer.draw$lambda$1(this, arg_0)));
        }
        stack.pop();
    }

    public final void clear(@NotNull Color clearColor, double clearDepth, int clearStencil) {
        Intrinsics.checkNotNullParameter((Object)clearColor, (String)"clearColor");
        OmniFramebuffer.withBound$default(this, 0, () -> OmniFramebuffer.clear$lambda$2(clearColor, clearDepth, clearStencil), 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OmniTextureManager.Companion.bindTexture(this.getColorTexture().getId());
        AutoCloseable autoCloseable = new OmniImage(this.width, this.height);
        Throwable throwable = null;
        try {
            OmniImage image = (OmniImage)autoCloseable;
            boolean bl = false;
            OmniImage.loadFromBoundTexture$default(image, 0, 1, null);
            image.flipY();
            image.saveTo(file);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        OmniTextureManager.Companion.bindTexture(0);
    }

    @Override
    public void close() {
        if (this.depthStencilTexture != null) {
            this.getDepthStencilTexture().close();
        }
        if (this.colorTexture != null) {
            this.getColorTexture().close();
        }
        if (this.id != -1) {
            Companion.deleteFramebuffer(this.id);
            this.id = -1;
        }
    }

    private final void initialize(int width, int height) {
        this.width = width;
        this.height = height;
        this.id = Companion.genFramebuffer();
        this.colorTexture = new ManagedGpuTexture(width, height, this.colorFormat);
        this.depthStencilTexture = new ManagedGpuTexture(width, height, this.depthFormat);
        Companion.withFramebuffer(this.id, () -> OmniFramebuffer.initialize$lambda$4(this));
        this.checkStatus();
    }

    private final void checkStatus() {
        OmniFramebuffer.withBound$default(this, 0, OmniFramebuffer::checkStatus$lambda$5, 1, null);
    }

    @JvmOverloads
    public final <T> T withBound(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)OmniFramebuffer.withBound$default(this, 0, block, 1, null);
    }

    private static final Unit withBoundForRender$lambda$0(OmniFramebuffer this$0, Function3 $block) {
        OmniManagedScissorState prevScissorState = OmniManagedScissorState.Companion.active();
        OmniManagedScissorState.Companion.disable();
        GL11.glViewport((int)0, (int)0, (int)this$0.width, (int)this$0.height);
        OmniMatrixStack stack = new OmniMatrixStack();
        double scale = 1.0 / OmniResolution.getScaleFactor();
        stack.scale(scale * (double)OmniResolution.getViewportWidth() / (double)this$0.width, scale * (double)OmniResolution.getViewportHeight() / (double)this$0.height, 1.0);
        $block.invoke((Object)stack, (Object)this$0.width, (Object)this$0.height);
        GL11.glViewport((int)0, (int)0, (int)OmniResolution.getViewportWidth(), (int)OmniResolution.getViewportHeight());
        prevScissorState.activate();
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$1(OmniFramebuffer this$0, RenderPassBuilder $this$drawWithCleanup) {
        Intrinsics.checkNotNullParameter((Object)$this$drawWithCleanup, (String)"$this$drawWithCleanup");
        $this$drawWithCleanup.texture(0, this$0.getColorTexture().getId());
        return Unit.INSTANCE;
    }

    private static final Unit clear$lambda$2(Color $clearColor, double $clearDepth, int $clearStencil) {
        GL11.glClearColor((float)((float)$clearColor.getRed() / 255.0f), (float)((float)$clearColor.getGreen() / 255.0f), (float)((float)$clearColor.getBlue() / 255.0f), (float)((float)$clearColor.getAlpha() / 255.0f));
        GL11.glClearDepth((double)$clearDepth);
        GL11.glClearStencil((int)$clearStencil);
        GL11.glClear((int)17664);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$4(OmniFramebuffer this$0) {
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this$0.getColorTexture().getId(), (int)0);
        GL30.glFramebufferTexture2D((int)36160, (int)(switch (WhenMappings.$EnumSwitchMapping$0[this$0.depthFormat.ordinal()]) {
            case 1 -> throw new UnsupportedOperationException("RGBA8 is not a valid depth format");
            case 2 -> 33306;
            case 3 -> 36096;
            default -> throw new NoWhenBranchMatchedException();
        }), (int)3553, (int)this$0.getDepthStencilTexture().getId(), (int)0);
        return Unit.INSTANCE;
    }

    private static final Unit checkStatus$lambda$5() {
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            String message = switch (status) {
                case 36054 -> "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 36055 -> "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 36059 -> "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
                case 36060 -> "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
                case 36061 -> "GL_FRAMEBUFFER_UNSUPPORTED";
                case 36182 -> "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                default -> "Unknown error";
            };
            String string = Integer.toString(status, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new IllegalStateException(("Framebuffer is not complete: " + message + " (" + string + ")").toString());
        }
        return Unit.INSTANCE;
    }

    private static final OmniRenderPipeline PIPELINE_delegate$lambda$7() {
        OmniRenderPipelineBuilder omniRenderPipelineBuilder;
        OmniRenderPipelineBuilder $this$PIPELINE_delegate_u24lambda_u247_u24lambda_u246 = omniRenderPipelineBuilder = OmniRenderPipeline.Companion.builderWithDefaultShader(OmniIdentifier.create("omnicore", "omniframebuffer"), VertexFormats.POSITION_TEXTURE_COLOR, DrawModes.QUADS);
        boolean bl = false;
        $this$PIPELINE_delegate_u24lambda_u247_u24lambda_u246.blendState = OmniManagedBlendState.NORMAL;
        return omniRenderPipelineBuilder.build();
    }

    @JvmStatic
    public static final <T> T withFramebuffer(int target, int fbo, @NotNull Function0<? extends T> block) {
        return Companion.withFramebuffer(target, fbo, block);
    }

    @JvmStatic
    public static final <T> T withFramebuffer(int fbo, @NotNull Function0<? extends T> block) {
        return Companion.withFramebuffer(fbo, block);
    }

    @JvmStatic
    public static final int genFramebuffer() {
        return Companion.genFramebuffer();
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindFramebuffer(int target, int fbo) {
        return Companion.bindFramebuffer(target, fbo);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindFramebuffer(int fbo) {
        return Companion.bindFramebuffer(fbo);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindReadFramebuffer(int fbo) {
        return Companion.bindReadFramebuffer(fbo);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> bindDrawFramebuffer(int fbo) {
        return Companion.bindDrawFramebuffer(fbo);
    }

    @JvmStatic
    public static final void deleteFramebuffer(int fbo) {
        Companion.deleteFramebuffer(fbo);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\n\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0007\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\u000f\u0010\r\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001b\u0010\u001c\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Ldev/deftu/omnicore/client/render/OmniFramebuffer$Companion;", "", "<init>", "()V", "T", "", "target", "fbo", "Lkotlin/Function0;", "block", "withFramebuffer", "(IILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "genFramebuffer", "()I", "", "bindFramebuffer", "(II)Lkotlin/jvm/functions/Function0;", "(I)Lkotlin/jvm/functions/Function0;", "bindReadFramebuffer", "bindDrawFramebuffer", "deleteFramebuffer", "(I)V", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "PIPELINE$delegate", "Lkotlin/Lazy;", "getPIPELINE", "()Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "PIPELINE", "OmniCore"})
    public static final class Companion {
        private Companion() {
        }

        private final OmniRenderPipeline getPIPELINE() {
            Lazy lazy = PIPELINE$delegate;
            return (OmniRenderPipeline)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T withFramebuffer(int target, int fbo, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Function0<Unit> unbind = this.bindFramebuffer(target, fbo);
            try {
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                unbind.invoke();
            }
        }

        @JvmStatic
        public final <T> T withFramebuffer(int fbo, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.withFramebuffer(36160, fbo, block);
        }

        @JvmStatic
        public final int genFramebuffer() {
            return GL30.glGenFramebuffers();
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindFramebuffer(int target, int fbo) {
            int prevReadFramebuffer = GL11.glGetInteger((int)36010);
            int prevDrawFramebuffer = GL11.glGetInteger((int)36006);
            GL30.glBindFramebuffer((int)target, (int)fbo);
            return () -> Companion.bindFramebuffer$lambda$0(prevReadFramebuffer, prevDrawFramebuffer);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindFramebuffer(int fbo) {
            return this.bindFramebuffer(36160, fbo);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindReadFramebuffer(int fbo) {
            return this.bindFramebuffer(36008, fbo);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindDrawFramebuffer(int fbo) {
            return this.bindFramebuffer(36009, fbo);
        }

        @JvmStatic
        public final void deleteFramebuffer(int fbo) {
            GL30.glDeleteFramebuffers((int)fbo);
        }

        private static final Unit bindFramebuffer$lambda$0(int $prevReadFramebuffer, int $prevDrawFramebuffer) {
            Companion.bindReadFramebuffer($prevReadFramebuffer);
            Companion.bindDrawFramebuffer($prevDrawFramebuffer);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GpuTexture.TextureFormat.values().length];
            try {
                nArray[GpuTexture.TextureFormat.RGBA8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpuTexture.TextureFormat.DEPTH24_STENCIL8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpuTexture.TextureFormat.DEPTH32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

