/*
 * Decompiled with CFR 0.152.
 */
package com.fyxeinc.ffnutrition;

import com.fyxeinc.ffnutrition.FFNutritionDataAttachment;
import com.fyxeinc.ffnutrition.FFNutritionMod;
import com.fyxeinc.ffnutrition.NutritionData;
import com.fyxeinc.ffnutrition.config.FFNutritionConfigCommon;
import com.fyxeinc.ffnutrition.data.FFNutritionItemDataLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="ffnutrition")
public class FFNutritionEvents {
    private static final Map<Item, double[]> itemNutritionCache = new HashMap<Item, double[]>();
    private static double[] fallbackItemNutrition;
    private static boolean hasCachedItems;
    private static int HungerTickCurrent;

    public static void cacheItemNutritionInfo(boolean force) {
        if (hasCachedItems && !force) {
            return;
        }
        List<String> nutritionCategories = FFNutritionItemDataLoader.getNutritionCategories();
        double nutritionModifier = (Double)FFNutritionConfigCommon.NUTRITION_MODIFIER.get();
        double saturationModifier = (Double)FFNutritionConfigCommon.SATURATION_MODIFIER.get();
        for (Map.Entry<Item, double[]> entry : FFNutritionItemDataLoader.getItemNutritionMap().entrySet()) {
            FoodProperties foodProperties = null;
            if (entry.getKey() != null) {
                foodProperties = (FoodProperties)entry.getKey().getDefaultInstance().get(DataComponents.FOOD);
            }
            double[] nutritionValues = new double[entry.getValue().length];
            for (int i = 0; i < entry.getValue().length; ++i) {
                if (foodProperties != null) {
                    double nutritionPart = entry.getValue()[i] * (double)foodProperties.nutrition() * nutritionModifier;
                    double saturationPart = entry.getValue()[i] * (double)foodProperties.saturation() * saturationModifier;
                    nutritionValues[i] = nutritionPart + saturationPart;
                    continue;
                }
                nutritionValues[i] = entry.getValue()[i];
            }
            itemNutritionCache.put(entry.getKey(), nutritionValues);
        }
        String[] values = ((String)FFNutritionConfigCommon.ITEM_NUTRITION_FALLBACK.get()).split(",");
        double[] fallbackNutrition = new double[nutritionCategories.size()];
        try {
            for (int i = 0; i < nutritionCategories.size(); ++i) {
                fallbackNutrition[i] = values.length > i ? Double.parseDouble(values[i]) : 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        fallbackItemNutrition = fallbackNutrition;
        hasCachedItems = true;
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)FFNutritionItemDataLoader.INSTANCE);
    }

    @SubscribeEvent
    private static void server_OnServerSetup(FMLDedicatedServerSetupEvent event) {
        FFNutritionEvents.cacheItemNutritionInfo(false);
    }

    @SubscribeEvent
    private static void server_OnLevelTickPost(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        boolean reduceHunger = false;
        if (++HungerTickCurrent > (Integer)FFNutritionConfigCommon.HUNGER_DECAY_TICKS.get()) {
            HungerTickCurrent = 0;
            reduceHunger = true;
        }
        if (!((Boolean)FFNutritionConfigCommon.USE_HUNGER_DECAY.get()).booleanValue()) {
            reduceHunger = false;
        }
        int hungerDecayAmount = (Integer)FFNutritionConfigCommon.HUNGER_DECAY_AMOUNT.get();
        int saturationDecayAmount = (Integer)FFNutritionConfigCommon.SATURATION_DECAY_AMOUNT.get();
        for (Player player : event.getLevel().players()) {
            if (!player.isCreative() || ((Boolean)FFNutritionConfigCommon.CREATIVE_DECAY_NUTRITION.get()).booleanValue()) {
                FFNutritionMod.server_DecayNutrition(player);
            }
            if (!reduceHunger || player.isCreative() && !((Boolean)FFNutritionConfigCommon.CREATIVE_DECAY_HUNGER.get()).booleanValue()) continue;
            FFNutritionMod.server_ReducePlayerHunger(player, hungerDecayAmount, saturationDecayAmount);
        }
    }

    @SubscribeEvent
    private static void server_OnDatapackSyncEvent(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        FFNutritionMod.server_LoadPlayerData((Player)player);
    }

    @SubscribeEvent
    private static void server_OnPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        FFNutritionMod.server_SavePlayerData(player);
    }

    @SubscribeEvent
    private static void server_OnLivingEntityUseItemEventFinish(LivingEntityUseItemEvent.Finish event) {
        Player player = null;
        if (event.getEntity() instanceof Player) {
            player = (Player)event.getEntity();
        }
        if (player == null || !(player instanceof ServerPlayer)) {
            return;
        }
        FFNutritionEvents.cacheItemNutritionInfo(false);
        ItemStack itemStack = event.getItem();
        Item item = itemStack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        String idString = id.toString();
        NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)player);
        if (itemNutritionCache.containsKey(item)) {
            double[] orderedNutritionInfo = itemNutritionCache.get(item);
            data.addValuesToOrderedCategories(orderedNutritionInfo);
        } else if (((Boolean)FFNutritionConfigCommon.USE_ITEM_NUTRITION_FALLBACK.get()).booleanValue()) {
            data.addValuesToOrderedCategories(fallbackItemNutrition);
        }
    }

    @SubscribeEvent
    public static void server_OnEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.getData(FFNutritionDataAttachment.NUTRITION_DATA);
    }

    static {
        hasCachedItems = false;
        HungerTickCurrent = 0;
    }
}

