/*
 * Decompiled with CFR 0.152.
 */
package com.fyxeinc.ffnutrition;

import com.fyxeinc.ffnutrition.FFNutritionMod;
import com.fyxeinc.ffnutrition.NutritionData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="ffnutrition")
public class FFNutritionCommands {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ffnutrition").then(Commands.literal((String)"getNutritionDataVague").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)target);
            Object line = "";
            line = data.getNutritionScore() >= 0.8 ? (String)line + "You're quite satiated." : (data.getNutritionScore() >= 0.5 ? (String)line + "You're decently satiated." : (String)line + "You should diversify your diet.");
            boolean hasNeeded = false;
            int index = 0;
            for (Map.Entry<String, Double> entry : data.getNutritionValueCollection().entrySet()) {
                String key = entry.getKey();
                Double value = entry.getValue();
                if (value <= 40.0) {
                    if (!hasNeeded) {
                        hasNeeded = true;
                        line = (String)line + " You're lacking ";
                    }
                    line = index == data.getNutritionValueCollection().size() - 1 ? (String)line + key + "." : (String)line + key + ", ";
                }
                ++index;
            }
            Object message = line;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> FFNutritionCommands.lambda$registerCommands$0((String)message), false);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ffnutrition").then(Commands.literal((String)"getNutritionData").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(context -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)target);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Score: " + String.format("%.6f", data.getNutritionScore()))), false);
            int index = 0;
            for (Map.Entry<String, Double> entry : data.getNutritionValueCollection().entrySet()) {
                String key = entry.getKey();
                Double value = entry.getValue();
                int newIndex = ++index;
                System.out.println(key + " = " + value);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(newIndex + ") " + key + ": " + String.format("%.6f", value))), false);
            }
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ffnutrition").then(Commands.literal((String)"maxAllNutrients").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(context -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)target);
            data.setAllCategories(100.0);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Fully satiated player: " + target.getName().getString())), false);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ffnutrition").then(Commands.literal((String)"minAllNutrients").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(context -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)target);
            data.setAllCategories(0.0);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Fully unsatiated player: " + target.getName().getString())), false);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ffnutrition").then(Commands.literal((String)"setAllNutrients").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).requires(source -> source.hasPermission(2))).executes(context -> {
            double value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)target);
            data.setAllCategories(value);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set stationation of player: " + target.getName().getString() + " to : " + String.format("%.6f", value))), false);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ffnutrition").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"addToCategory").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"category", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).requires(source -> source.hasPermission(2))).executes(context -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            String category = StringArgumentType.getString((CommandContext)context, (String)"category");
            double value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)target);
            data.addToCategory(category, value, true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Added " + String.format("%.6f", value) + " to category '" + category + "' for player " + target.getName().getString() + ". New total: " + String.format("%.6f", data.getCategoryValue(category)))), false);
            return 1;
        }))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ffnutrition").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"setCategory").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"category", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).requires(source -> source.hasPermission(2))).executes(context -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            String category = StringArgumentType.getString((CommandContext)context, (String)"category");
            double value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)target);
            data.addToCategory(category, value, true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set category " + category + " to '" + String.format("%.6f", value) + "' for player " + target.getName().getString() + ". New total: " + String.format("%.6f", data.getCategoryValue(category)))), false);
            return 1;
        }))))));
    }

    private static /* synthetic */ Component lambda$registerCommands$0(String message) {
        return Component.literal((String)message);
    }
}

