/*
 * Decompiled with CFR 0.152.
 */
package com.fyxeinc.ffnutrition;

import com.fyxeinc.ffnutrition.config.FFNutritionConfigCommon;
import com.fyxeinc.ffnutrition.data.FFNutritionItemDataLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class NutritionData
implements INBTSerializable<CompoundTag> {
    private static final double NUTRITION_CATEGORY_VALUE_MAX = 100.0;
    private double nutritionScore;
    private Map<String, Double> nutritionValueCollection = new HashMap<String, Double>();
    private boolean isInitialized = false;
    public static final StreamCodec<FriendlyByteBuf, NutritionData> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        Map<String, Double> map = data.getNutritionValueCollection();
        buf.writeInt(map.size());
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            buf.writeUtf(entry.getKey());
            buf.writeDouble(entry.getValue().doubleValue());
        }
    }, buf -> {
        int size = buf.readInt();
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (int i = 0; i < size; ++i) {
            String key = buf.readUtf();
            double value = buf.readDouble();
            map.put(key, value);
        }
        NutritionData data = new NutritionData();
        data.setNutritionValueCollection(map);
        return data;
    });

    public NutritionData() {
        this.Init();
    }

    public void Init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.nutritionValueCollection = new HashMap<String, Double>();
        double currentScore = 0.0;
        int maxEntries = FFNutritionItemDataLoader.getNutritionCategories().size();
        for (String entry : FFNutritionItemDataLoader.getNutritionCategories()) {
            double categoryScore = (Double)FFNutritionConfigCommon.INITIAL_DEFAULT.get();
            this.nutritionValueCollection.put(entry, categoryScore);
            currentScore += categoryScore;
        }
        this.nutritionScore = currentScore / (100.0 * (double)maxEntries);
    }

    public Map<String, Double> getNutritionValueCollection() {
        return this.nutritionValueCollection;
    }

    public double getNutritionScore() {
        return this.nutritionScore;
    }

    public double getCategoryValue(String category) {
        return this.nutritionValueCollection.getOrDefault(category, 0.0);
    }

    public void addValuesToOrderedCategories(double[] nutritionInfo) {
        ArrayList<String> nutritionCategories = new ArrayList<String>(FFNutritionItemDataLoader.getNutritionCategories());
        for (int i = 0; i < nutritionCategories.size(); ++i) {
            if (i >= nutritionInfo.length) {
                return;
            }
            String entry = (String)nutritionCategories.get(i);
            this.addToCategory(entry, nutritionInfo[i], false);
        }
        this.nutritionScore = this.computeNutritionScore();
    }

    public void addToAllCategories(double amount) {
        if (amount == 0.0) {
            return;
        }
        for (String entry : this.nutritionValueCollection.keySet()) {
            this.addToCategory(entry, amount, false);
        }
        this.nutritionScore = this.computeNutritionScore();
    }

    public void addToCategory(String category, double amount, boolean computeScore) {
        if (amount == 0.0) {
            return;
        }
        if (this.nutritionValueCollection.containsKey(category)) {
            double newValue = this.nutritionValueCollection.getOrDefault(category, 0.0) + amount;
            newValue = Math.clamp(newValue, 0.0, 100.0);
            this.nutritionValueCollection.put(category, newValue);
        }
        if (computeScore) {
            this.nutritionScore = this.computeNutritionScore();
        }
    }

    public void setCategory(String category, double amount) {
        if (this.nutritionValueCollection.containsKey(category)) {
            amount = Math.clamp(amount, 0.0, 100.0);
            this.nutritionValueCollection.put(category, amount);
        }
        this.nutritionScore = this.computeNutritionScore();
    }

    public void setAllCategories(double amount) {
        for (String entry : this.nutritionValueCollection.keySet()) {
            this.nutritionValueCollection.put(entry, amount);
        }
        this.nutritionScore = this.computeNutritionScore();
    }

    public double computeNutritionScore() {
        double currentScore = 0.0;
        int maxEntries = 0;
        for (String entry : this.nutritionValueCollection.keySet()) {
            double categoryScore = this.nutritionValueCollection.getOrDefault(entry, 0.0);
            currentScore += categoryScore;
            ++maxEntries;
        }
        return currentScore / (100.0 * (double)maxEntries);
    }

    public void saveToNBT(CompoundTag tag) {
        for (String entry : this.nutritionValueCollection.keySet()) {
            double categoryScore = this.nutritionValueCollection.getOrDefault(entry, 0.0);
            tag.putDouble(entry, categoryScore);
        }
    }

    public void loadFromNBT(CompoundTag tag) {
        for (String entry : this.nutritionValueCollection.keySet()) {
            double categoryScore = tag.getDouble(entry);
            this.nutritionValueCollection.put(entry, categoryScore);
        }
    }

    public void setNutritionValueCollection(Map<String, Double> map) {
        if (map == null) {
            this.nutritionValueCollection.clear();
            return;
        }
        this.nutritionValueCollection.clear();
        this.nutritionValueCollection.putAll(map);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, Double> entry : this.nutritionValueCollection.entrySet()) {
            tag.putDouble(entry.getKey(), entry.getValue().doubleValue());
        }
        tag.putDouble("NutritionScore", this.nutritionScore);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.nutritionValueCollection.clear();
        for (String category : FFNutritionItemDataLoader.getNutritionCategories()) {
            double value = tag.contains(category) ? tag.getDouble(category) : ((Double)FFNutritionConfigCommon.INITIAL_DEFAULT.get()).doubleValue();
            value = Math.clamp(value, 0.0, 100.0);
            this.nutritionValueCollection.put(category, value);
        }
        this.nutritionScore = tag.contains("NutritionScore") ? tag.getDouble("NutritionScore") : this.computeNutritionScore();
    }
}

