/*
 * Decompiled with CFR 0.152.
 */
package com.fyxeinc.ffnutrition;

import com.fyxeinc.ffnutrition.FFNutritionDataAttachment;
import com.fyxeinc.ffnutrition.NutritionData;
import com.fyxeinc.ffnutrition.config.FFNutritionConfigCommon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="ffnutrition")
public class FFNutritionMod {
    public static final String MODID = "ffnutrition";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ffnutrition");

    public FFNutritionMod(IEventBus modEventBus, ModContainer container) {
        LOGGER.info("FFNutrition: Initialize - Start.");
        LOGGER.info("FFNutrition: register attachment types.");
        FFNutritionDataAttachment.ATTACHMENT_TYPES.register(modEventBus);
        LOGGER.info("FFNutrition: register config - common.");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FFNutritionConfigCommon.SPEC);
        LOGGER.info("FFNutrition: Initialize - End");
    }

    public static NutritionData getNutritionData(LivingEntity entity) {
        return (NutritionData)entity.getData(FFNutritionDataAttachment.NUTRITION_DATA);
    }

    public static void server_DecayNutrition(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NutritionData data = FFNutritionMod.getNutritionData((LivingEntity)player);
        double defaultDecay = (Double)FFNutritionConfigCommon.DECAY_DEFAULT.get();
        data.addToAllCategories(-defaultDecay);
        double score = data.getNutritionScore();
        double maxHealth = score * (double)((Integer)FFNutritionConfigCommon.MAX_HEALTH.get()).intValue();
        double minHealth = (Double)FFNutritionConfigCommon.MIN_HEALTH.get();
        if (minHealth <= 0.0) {
            minHealth = 1.0;
        }
        if (maxHealth < minHealth) {
            maxHealth = minHealth;
        }
        maxHealth = (double)Math.round(maxHealth / 2.0) * 2.0;
        player.getAttributes().getInstance(Attributes.MAX_HEALTH).setBaseValue(maxHealth);
        if ((double)player.getHealth() > maxHealth) {
            player.setHealth((float)maxHealth);
        }
    }

    public static void server_ReducePlayerHunger(Player player, int amountHunger, int amountSaturation) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        LOGGER.info("Hunger was reduced by 1.");
        serverPlayer.getFoodData().setFoodLevel(Math.max(0, serverPlayer.getFoodData().getFoodLevel() - amountHunger));
        serverPlayer.getFoodData().setSaturation(Math.max(0.0f, serverPlayer.getFoodData().getSaturationLevel() - (float)amountSaturation));
    }

    public static void server_SavePlayerData(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player == null) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        FFNutritionMod.getNutritionData((LivingEntity)player).saveToNBT(tag);
        player.getPersistentData().put("ffnutrition_data", (Tag)tag);
    }

    public static void server_LoadPlayerData(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player == null) {
            return;
        }
        if (player.getPersistentData().contains("ffnutrition_data")) {
            CompoundTag tag = player.getPersistentData().getCompound("ffnutrition_data");
            FFNutritionMod.getNutritionData((LivingEntity)player).loadFromNBT(tag);
        }
    }
}

