/*
 * Decompiled with CFR 0.152.
 */
package com.fyxeinc.ffnutrition;

import com.fyxeinc.ffnutrition.data.FFNutritionItemDataLoader;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@Mod(value="ffnutrition", dist={Dist.CLIENT})
@EventBusSubscriber(modid="ffnutrition", value={Dist.CLIENT})
public class FFNutritionModClient {
    public FFNutritionModClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    private static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        Item item = stack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        String idString = id.toString();
        if (!FFNutritionItemDataLoader.getHasNutritionValues(item)) {
            return;
        }
        if (!Screen.hasShiftDown()) {
            tooltip.add(Component.literal((String)"Hold SHIFT for nutrition info").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))));
            return;
        }
        double[] nutrition = FFNutritionItemDataLoader.getNutritionValues(item);
        if (nutrition != null) {
            for (int i = 0; i < nutrition.length; ++i) {
                String categoryName = FFNutritionItemDataLoader.getNutritionCategoryAtIndex(i);
                Object line = "";
                if (nutrition[i] >= 1.1) {
                    line = "Overwhelmingly " + categoryName;
                } else if (nutrition[i] >= 1.0) {
                    line = "Entirely " + categoryName;
                } else if (nutrition[i] >= 0.8) {
                    line = "Mostly " + categoryName;
                } else if (nutrition[i] >= 0.7) {
                    line = "Largely " + categoryName;
                } else if (nutrition[i] >= 0.6) {
                    line = "Mainly " + categoryName;
                } else if (nutrition[i] >= 0.5) {
                    line = "Partly " + categoryName;
                } else if (nutrition[i] >= 0.4) {
                    line = "Some " + categoryName;
                } else if (nutrition[i] >= 0.3) {
                    line = "A bit of " + categoryName;
                } else if (nutrition[i] >= 0.2) {
                    line = "Barely any " + categoryName;
                } else if (nutrition[i] >= 0.1) {
                    line = "Trace " + categoryName;
                } else if (nutrition[i] >= 0.01) {
                    line = "A pinch of " + categoryName;
                } else if (nutrition[i] >= 0.001) {
                    line = "A molecule of " + categoryName;
                }
                if (((String)line).isEmpty()) continue;
                tooltip.add(Component.literal((String)line).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
            }
        }
    }
}

