/*
 * Decompiled with CFR 0.152.
 */
package com.fyxeinc.ffnutrition.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class FFNutritionConfigCommon {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.BooleanValue USE_HUNGER_DECAY = BUILDER.comment("Should hunger decay by HungerDecayAmount, and saturation by SaturationDecayAmount every DecayTicks?").define("useHungerDecay", true);
    public static final ModConfigSpec.IntValue HUNGER_DECAY_TICKS = BUILDER.comment("The amount of ticks it takes to reduce hunger and saturation by their decay amounts.").defineInRange("hungerDecayTicks", 1200, 0, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue HUNGER_DECAY_AMOUNT = BUILDER.comment("The amount of hunger to reduce every delay ticks.").defineInRange("hungerDecayAmount", 1, 0, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue SATURATION_DECAY_AMOUNT = BUILDER.comment("The amount of saturation to reduce every delay ticks.").defineInRange("saturationDecayAmount", 1, 0, Integer.MAX_VALUE);
    public static final ModConfigSpec.BooleanValue CREATIVE_DECAY_HUNGER = BUILDER.comment("Should hunger decay in creative mode?").define("creativeDecayHunger", false);
    public static final ModConfigSpec.BooleanValue CREATIVE_DECAY_NUTRITION = BUILDER.comment("Should nutrition decay in creative mode?").define("creativeDecayNutrition", false);
    public static final ModConfigSpec.DoubleValue INITIAL_DEFAULT = BUILDER.comment("Initial value for non specified category.").defineInRange("initialDefault", 50.0, 0.0, 100.0);
    public static final ModConfigSpec.DoubleValue DECAY_DEFAULT = BUILDER.comment("Decay per tick for non specified category.").defineInRange("decayDefault", 8.3E-4, 0.0, Double.MAX_VALUE);
    public static final ModConfigSpec.IntValue MAX_HEALTH = BUILDER.comment("Max health.").defineInRange("maxHealth", 20, 1, 1024);
    public static final ModConfigSpec.DoubleValue MIN_HEALTH = BUILDER.comment("Minimum max health even when nutrition score is low.").defineInRange("minHealth", 6.0, 1.0, Double.MAX_VALUE);
    public static final ModConfigSpec.DoubleValue NUTRITION_MODIFIER = BUILDER.comment("The amount that minecraft's nutrition effects FFnutrition.").defineInRange("nutritionModifier", 4.0, 0.0, Double.MAX_VALUE);
    public static final ModConfigSpec.DoubleValue SATURATION_MODIFIER = BUILDER.comment("The amount that minecraft's saturation effects FFnutrition.").defineInRange("saturationModifier", 2.0, 0.0, Double.MAX_VALUE);
    public static final ModConfigSpec.BooleanValue USE_ITEM_NUTRITION_FALLBACK = BUILDER.comment("Should items with no nutrition value use the fallback? Non specific Items will give no nutrition if this is false. However, if this is true, items that can be used may cause unintended nutrition gain.").define("useItemNutritionFallback", false);
    public static final ModConfigSpec.ConfigValue<String> ITEM_NUTRITION_FALLBACK = BUILDER.comment("The default nutrition amounts to use for unspecified items.").define("defaultNutritionFallback", (Object)"10.0,10.0,10.0,10.0,10.0");
    public static final ModConfigSpec SPEC = BUILDER.build();
}

