/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysUtilityTweaks;

import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.Plugin;

public class EnchantmentTweakEvents
implements Listener {
    Plugin plugin;

    public EnchantmentTweakEvents(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLootGenerate(LootGenerateEvent event) {
        event.getLoot().forEach(item -> {
            if (item.getEnchantments().containsKey(Enchantment.PROTECTION) && (Integer)item.getEnchantments().get(Enchantment.PROTECTION) > this.plugin.getConfig().getInt("enchantmentTweaks.prot.maxLevel")) {
                item.getEnchantments().put(Enchantment.PROTECTION, this.plugin.getConfig().getInt("enchantmentTweaks.prot.maxLevel"));
            }
            if (item.getEnchantments().containsKey(Enchantment.SHARPNESS) && (Integer)item.getEnchantments().get(Enchantment.SHARPNESS) > this.plugin.getConfig().getInt("enchantmentTweaks.sharp.maxLevel")) {
                item.getEnchantments().put(Enchantment.SHARPNESS, this.plugin.getConfig().getInt("enchantmentTweaks.sharp.maxLevel"));
            }
            if (item.getEnchantments().containsKey(Enchantment.POWER) && (Integer)item.getEnchantments().get(Enchantment.POWER) > this.plugin.getConfig().getInt("enchantmentTweaks.power.maxLevel")) {
                item.getEnchantments().put(Enchantment.POWER, this.plugin.getConfig().getInt("enchantmentTweaks.power.maxLevel"));
            }
        });
    }

    @EventHandler
    public void onPrepareEnchant(PrepareItemEnchantEvent event) {
        for (EnchantmentOffer offer : event.getOffers()) {
            assert (offer != null);
            if (offer.getEnchantment() == Enchantment.PROTECTION && offer.getEnchantmentLevel() > this.plugin.getConfig().getInt("enchantmentTweaks.prot.maxLevel")) {
                offer.setEnchantmentLevel(this.plugin.getConfig().getInt("enchantmentTweaks.prot.maxLevel"));
            }
            if (offer.getEnchantment() == Enchantment.SHARPNESS && offer.getEnchantmentLevel() > this.plugin.getConfig().getInt("enchantmentTweaks.sharp.maxLevel")) {
                offer.setEnchantmentLevel(this.plugin.getConfig().getInt("enchantmentTweaks.sharp.maxLevel"));
            }
            if (offer.getEnchantment() != Enchantment.POWER || offer.getEnchantmentLevel() <= this.plugin.getConfig().getInt("enchantmentTweaks.power.maxLevel")) continue;
            offer.setEnchantmentLevel(this.plugin.getConfig().getInt("enchantmentTweaks.power.maxLevel"));
        }
    }

    @EventHandler
    public void onVillagerAcquireTrade(VillagerAcquireTradeEvent event) {
        if (event.getRecipe().getResult().getEnchantments().containsKey(Enchantment.PROTECTION)) {
            MerchantRecipe newRecipe;
            if ((Integer)event.getRecipe().getResult().getEnchantments().get(Enchantment.PROTECTION) > this.plugin.getConfig().getInt("enchantmentTweaks.prot.maxLevel")) {
                newRecipe = event.getRecipe();
                newRecipe.getResult().getEnchantments().put(Enchantment.PROTECTION, this.plugin.getConfig().getInt("enchantmentTweaks.prot.maxLevel"));
            }
            if ((Integer)event.getRecipe().getResult().getEnchantments().get(Enchantment.SHARPNESS) > this.plugin.getConfig().getInt("enchantmentTweaks.sharp.maxLevel")) {
                newRecipe = event.getRecipe();
                newRecipe.getResult().getEnchantments().put(Enchantment.SHARPNESS, this.plugin.getConfig().getInt("enchantmentTweaks.sharp.maxLevel"));
            }
            if ((Integer)event.getRecipe().getResult().getEnchantments().get(Enchantment.POWER) > this.plugin.getConfig().getInt("enchantmentTweaks.power.maxLevel")) {
                newRecipe = event.getRecipe();
                newRecipe.getResult().getEnchantments().put(Enchantment.POWER, this.plugin.getConfig().getInt("enchantmentTweaks.power.maxLevel"));
            }
        }
    }
}

