/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.hemalurgy.common.eventHandlers;

import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.hemalurgy.common.items.HemalurgicSpikeItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hemalurgy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HemalurgyEntityEventHandler {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Item item;
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        ItemStack stack = event.getEntity().m_21205_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof HemalurgicSpikeItem) {
            HemalurgicSpikeItem spike = (HemalurgicSpikeItem)item;
            Entity entity2 = event.getTarget();
            if (!(entity2 instanceof Cat)) {
                return;
            }
            Cat cat = (Cat)entity2;
            if (!spike.hemalurgicIdentityExists(stack)) {
                return;
            }
            target.m_6593_((Component)TextHelper.createTranslatedText((String)"Catquisitor", (Object[])new Object[0]));
            boolean spikeApplied = false;
            try {
                for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
                    Attribute regAttribute;
                    double hemalurgicStrength = spike.getHemalurgicStrength(stack, manifestation);
                    if (!(hemalurgicStrength > 0.0) || (regAttribute = manifestation.getAttribute()) == null) continue;
                    spikeApplied = true;
                    AttributeMap catAttributes = cat.m_21204_();
                    AttributeInstance instance = catAttributes.m_22146_(regAttribute);
                    if (instance == null) continue;
                    instance.m_22100_(hemalurgicStrength);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (spikeApplied && !event.getEntity().m_7500_()) {
                stack.m_41774_(1);
            }
        }
    }
}

