/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.hemalurgy.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.hemalurgy.common.items.HemalurgicSpikeItem;
import leaf.cosmere.hemalurgy.common.registries.HemalurgyLootFunctions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class InvestSpikeLootFunction
extends LootItemConditionalFunction {
    protected InvestSpikeLootFunction(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)HemalurgyLootFunctions.INVEST_SPIKE.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext lootContext) {
        Optional stealType;
        Item item = stack.m_41720_();
        if (!(item instanceof HemalurgicSpikeItem)) {
            return stack;
        }
        HemalurgicSpikeItem item2 = (HemalurgicSpikeItem)item;
        Metals.MetalType spikeMetalType = item2.getMetalType();
        if (!spikeMetalType.hasHemalurgicEffect()) {
            return stack;
        }
        Collection hemalurgyStealWhitelist = spikeMetalType.getHemalurgyStealWhitelist();
        Optional<Object> optional = stealType = hemalurgyStealWhitelist == null ? Optional.empty() : hemalurgyStealWhitelist.stream().filter(Metals.MetalType::hasAssociatedManifestation).skip(lootContext.m_230907_().m_188503_(hemalurgyStealWhitelist.size())).findFirst();
        if (stealType.isEmpty()) {
            CosmereAPI.logger.error(spikeMetalType + " has empty Stealtype on trying to invest spike loot");
            return stack;
        }
        float strengthLevel = Mth.m_14036_((float)(5.0f + lootContext.m_78945_()), (float)1.0f, (float)10.0f);
        Manifestation allomancyMani = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("allomancy", ((Metals.MetalType)stealType.get()).m_6082_()));
        Manifestation feruchemyMani = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("feruchemy", ((Metals.MetalType)stealType.get()).m_6082_()));
        switch (spikeMetalType) {
            case STEEL: 
            case BRONZE: 
            case CADMIUM: 
            case ELECTRUM: {
                if (!stealType.isPresent()) {
                    return stack;
                }
                item2.Invest(stack, allomancyMani, strengthLevel, UUID.randomUUID());
                break;
            }
            case PEWTER: 
            case BRASS: 
            case BENDALLOY: 
            case GOLD: {
                if (!stealType.isPresent()) {
                    return stack;
                }
                item2.Invest(stack, feruchemyMani, strengthLevel, UUID.randomUUID());
                break;
            }
            case ATIUM: {
                if (!stealType.isPresent()) {
                    return stack;
                }
                boolean isAllomancy = lootContext.m_230907_().m_188499_();
                Manifestation manifestation = isAllomancy ? allomancyMani : feruchemyMani;
                if (manifestation == null) break;
                item2.Invest(stack, manifestation, strengthLevel, UUID.randomUUID());
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<InvestSpikeLootFunction> {
        public InvestSpikeLootFunction deserialize(JsonObject jsonObject, JsonDeserializationContext deserializationContext, LootItemCondition[] lootConditions) {
            return new InvestSpikeLootFunction(lootConditions);
        }
    }
}

