/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.hemalurgy.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import javax.annotation.Nonnull;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class SpikeModel
extends HumanoidModel<LivingEntity> {
    private static final ResourceLocation TEXTURE = Cosmere.rl((String)"textures/block/metal_block.png");
    private static final String headID = "head";
    private static final String bodyID = "body";
    private static final String leftArmID = "left_arm";
    private static final String rightArmID = "right_arm";
    private static final String leftLegID = "left_leg";
    private static final String rightLegID = "right_leg";
    private static final String eyeRootID = "eyeRoot";
    private static final String eyesID = "eyes";
    private static final String linchpinID = "linchpin";
    private static final String physicalID = "physical";
    private static final String mentalID = "mental";
    private static final String spiritualID = "spiritual";
    private static final String temporalID = "temporal";
    private final ModelPart root;
    private final ModelPart eyeRoot;
    private final ModelPart eyeLeftFront;
    private final ModelPart eyeRightFront;
    private final ModelPart eyeLeftBack;
    private final ModelPart eyeRightBack;
    private final ModelPart linchpin;
    private final ModelPart upperBack;
    private final ModelPart upperMiddleBack;
    private final ModelPart lowerMiddleBack;
    private final ModelPart lowerBack;
    private final ModelPart upperChest;
    private final ModelPart lowerChest;
    private final ModelPart rightShoulderTop;
    private final ModelPart leftShoulderTop;
    private final ModelPart rightShoulderSide;
    private final ModelPart leftShoulderSide;
    private final ModelPart rightShoulderBack;
    private final ModelPart leftShoulderBack;
    private final ModelPart ribLeftTop;
    private final ModelPart ribLeftTopMiddle;
    private final ModelPart ribLeftBottomMiddle;
    private final ModelPart ribLeftBottom;
    private final ModelPart ribRightTop;
    private final ModelPart ribRightTopMiddle;
    private final ModelPart ribRightBottomMiddle;
    private final ModelPart ribRightBottom;
    private final ModelPart rightArmUpper;
    private final ModelPart rightArmUpperBack;
    private final ModelPart rightArmMiddle;
    private final ModelPart rightArmLower;
    private final ModelPart leftArmUpper;
    private final ModelPart leftArmUpperBack;
    private final ModelPart leftArmMiddle;
    private final ModelPart leftArmLower;
    private final ModelPart rightHand;
    private final ModelPart leftHand;
    private final ModelPart rightLegUpper;
    private final ModelPart rightLegUpperMiddle;
    private final ModelPart rightLegLowerMiddle;
    private final ModelPart rightLegLower;
    private final ModelPart leftLegUpper;
    private final ModelPart leftLegUpperMiddle;
    private final ModelPart leftLegLowerMiddle;
    private final ModelPart leftLegLower;

    public SpikeModel(ModelPart part) {
        super(part, RenderType::m_110458_);
        this.root = part;
        ModelPart find = this.root.m_171324_(headID);
        this.eyeRoot = find.m_171324_(eyeRootID);
        this.eyeLeftFront = this.eyeRoot.m_171324_("left_eye_front");
        this.eyeRightFront = this.eyeRoot.m_171324_("right_eye_front");
        this.eyeLeftBack = this.eyeRoot.m_171324_("left_eye_back");
        this.eyeRightBack = this.eyeRoot.m_171324_("right_eye_back");
        find = part.m_171324_(bodyID);
        this.linchpin = find.m_171324_(linchpinID);
        this.upperBack = find.m_171324_("upper_back");
        this.upperMiddleBack = find.m_171324_("upper_middle_back");
        this.lowerMiddleBack = find.m_171324_("lower_middle_back");
        this.lowerBack = find.m_171324_("lower_back");
        this.upperChest = find.m_171324_("upper_chest");
        this.lowerChest = find.m_171324_("lower_chest");
        this.ribLeftTop = find.m_171324_("rib_left_top");
        this.ribLeftTopMiddle = find.m_171324_("rib_left_top_middle");
        this.ribLeftBottomMiddle = find.m_171324_("rib_left_bottom_middle");
        this.ribLeftBottom = find.m_171324_("rib_left_bottom");
        this.ribRightTop = find.m_171324_("rib_right_top");
        this.ribRightTopMiddle = find.m_171324_("rib_right_top_middle");
        this.ribRightBottomMiddle = find.m_171324_("rib_right_bottom_middle");
        this.ribRightBottom = find.m_171324_("rib_right_bottom");
        find = part.m_171324_(rightArmID);
        this.rightShoulderTop = find.m_171324_("shoulder_top");
        this.rightShoulderSide = find.m_171324_("shoulder_side");
        this.rightShoulderBack = find.m_171324_("shoulder_back");
        this.rightArmUpper = find.m_171324_("upper");
        this.rightArmUpperBack = find.m_171324_("back");
        this.rightArmMiddle = find.m_171324_("middle");
        this.rightArmLower = find.m_171324_("lower");
        this.rightHand = find.m_171324_("hand");
        find = part.m_171324_(leftArmID);
        this.leftShoulderTop = find.m_171324_("shoulder_top");
        this.leftShoulderSide = find.m_171324_("shoulder_side");
        this.leftShoulderBack = find.m_171324_("shoulder_back");
        this.leftArmUpper = find.m_171324_("upper");
        this.leftArmUpperBack = find.m_171324_("back");
        this.leftArmMiddle = find.m_171324_("middle");
        this.leftArmLower = find.m_171324_("lower");
        this.leftHand = find.m_171324_("hand");
        find = part.m_171324_(rightLegID);
        this.rightLegUpper = find.m_171324_("upper");
        this.rightLegUpperMiddle = find.m_171324_("upper_middle");
        this.rightLegLowerMiddle = find.m_171324_("lower_middle");
        this.rightLegLower = find.m_171324_("lower");
        this.leftLegUpper = find.m_171324_("upper");
        this.leftLegUpperMiddle = find.m_171324_("upper_middle");
        this.leftLegLowerMiddle = find.m_171324_("lower_middle");
        this.leftLegLower = find.m_171324_("lower");
    }

    public static LayerDefinition createLayer() {
        CubeDeformation cube = new CubeDeformation(0.4f);
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)cube, (float)0.0f);
        PartDefinition part = mesh.m_171576_();
        PartDefinition head = part.m_171599_(headID, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition eyeRoot = head.m_171599_(eyeRootID, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        eyeRoot.m_171599_("right_eye_front", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -4.25f, 2.0f, 2.0f, 5.0f, cube), PartPose.f_171404_);
        eyeRoot.m_171599_("right_eye_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.25f, -2.25f, 3.0f, 0.5f, 0.5f, 1.0f, cube), PartPose.f_171404_);
        eyeRoot.m_171599_("left_eye_front", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, -3.0f, -4.25f, 2.0f, 2.0f, 5.0f, cube), PartPose.f_171404_);
        eyeRoot.m_171599_("left_eye_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.75f, -2.25f, 3.0f, 0.5f, 0.5f, 1.0f, cube), PartPose.f_171404_);
        PartDefinition body = part.m_171599_(bodyID, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        body.m_171599_(linchpinID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 1.0f, 1.5f, 0.5f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        body.m_171599_("upper_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 3.5f, 1.5f, 0.5f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        body.m_171599_("upper_middle_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 5.5f, 1.5f, 0.5f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        body.m_171599_("lower_middle_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 7.5f, 1.5f, 0.5f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        body.m_171599_("lower_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 9.5f, 1.5f, 0.5f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        body.m_171599_("upper_chest", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 5.5f, -2.03125f, 0.5f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        body.m_171599_("lower_chest", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 9.5f, -2.03125f, 0.5f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        body.m_171599_("rib_right_top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, 4.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        body.m_171599_("rib_right_top_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, 6.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        body.m_171599_("rib_right_bottom_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, 8.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        body.m_171599_("rib_right_bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, 10.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        body.m_171599_("rib_left_top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(2.0f, 4.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        body.m_171599_("rib_left_top_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(2.0f, 6.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        body.m_171599_("rib_left_bottom_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(2.0f, 8.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        body.m_171599_("rib_left_bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(2.0f, 10.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        PartDefinition rightArm = part.m_171599_(rightArmID, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        rightArm.m_171599_("shoulder_top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.25f, -2.0f, -0.25f, 0.5f, 1.0f, 0.5f, cube), PartPose.f_171404_);
        rightArm.m_171599_("shoulder_side", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 0.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        rightArm.m_171599_("shoulder_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.25f, 0.0f, 0.0625f, 0.5f, 0.5f, 2.0f, cube), PartPose.f_171404_);
        rightArm.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 2.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        rightArm.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.25f, 2.0f, 0.0625f, 0.5f, 0.5f, 2.0f, cube), PartPose.f_171404_);
        rightArm.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 4.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        rightArm.m_171599_("lower", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 6.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        rightArm.m_171599_("hand", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 8.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        PartDefinition leftArm = part.m_171599_(leftArmID, CubeListBuilder.m_171558_().m_171480_(), PartPose.f_171404_);
        leftArm.m_171599_("shoulder_top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.75f, -2.0f, -0.25f, 0.5f, 1.0f, 0.5f, cube), PartPose.f_171404_);
        leftArm.m_171599_("shoulder_side", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 0.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        leftArm.m_171599_("shoulder_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.75f, 0.0f, 0.0625f, 0.5f, 0.5f, 2.0f, cube), PartPose.f_171404_);
        leftArm.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 2.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        leftArm.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.75f, 2.0f, 0.0625f, 0.5f, 0.5f, 2.0f, cube), PartPose.f_171404_);
        leftArm.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 4.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        leftArm.m_171599_("lower", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 6.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        leftArm.m_171599_("hand", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 8.0f, -0.25f, 2.0f, 0.5f, 0.5f, cube), PartPose.f_171404_);
        PartDefinition rightLeg = part.m_171599_(rightLegID, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        rightLeg.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 2.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        rightLeg.m_171599_("upper_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 4.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        rightLeg.m_171599_("lower_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 6.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        rightLeg.m_171599_("lower", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 8.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        PartDefinition leftLeg = part.m_171599_(leftLegID, CubeListBuilder.m_171558_().m_171480_(), PartPose.f_171404_);
        leftLeg.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 2.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        leftLeg.m_171599_("upper_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 4.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        leftLeg.m_171599_("lower_middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 6.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        leftLeg.m_171599_("lower", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.25f, 8.0f, -2.03125f, 0.5f, 0.5f, 4.0625f, cube), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)16, (int)16);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_);
    }

    public void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        int slotIndex = slotContext.index() + 1;
        boolean leftHandSide = slotIndex % 2 != 0;
        ModelPart modelPartToRender = null;
        block8 : switch (slotContext.identifier()) {
            case "eyes": {
                this.eyeLeftFront.f_104207_ = leftHandSide;
                this.eyeLeftBack.f_104207_ = leftHandSide;
                this.eyeRightFront.f_104207_ = !leftHandSide;
                this.eyeRightBack.f_104207_ = !leftHandSide;
                SpiritwebCapability.get((LivingEntity)slotContext.entity()).ifPresent(data -> {
                    this.eyeRoot.f_104201_ = CompoundNBTHelper.getInt((CompoundTag)data.getCompoundTag(), (String)"eye_height", (int)0);
                });
                modelPartToRender = this.f_102808_;
                break;
            }
            case "linchpin": {
                modelPartToRender = this.linchpin;
                modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                break;
            }
            case "physical": {
                switch (slotIndex) {
                    case 1: 
                    case 2: {
                        modelPartToRender = leftHandSide ? this.upperChest : this.lowerChest;
                        modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                        break block8;
                    }
                    case 3: 
                    case 4: {
                        modelPartToRender = leftHandSide ? this.ribLeftTop : this.ribRightTop;
                        modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                        break block8;
                    }
                    case 5: 
                    case 6: {
                        modelPartToRender = leftHandSide ? this.leftShoulderTop : this.rightShoulderTop;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
                        break block8;
                    }
                    case 7: 
                    case 8: {
                        modelPartToRender = leftHandSide ? this.leftLegUpper : this.rightLegUpper;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftLegID : rightLegID));
                        break block8;
                    }
                }
                modelPartToRender = null;
                break;
            }
            case "mental": {
                switch (slotIndex) {
                    case 1: 
                    case 2: {
                        modelPartToRender = leftHandSide ? this.upperBack : this.upperMiddleBack;
                        modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                        break block8;
                    }
                    case 3: 
                    case 4: {
                        modelPartToRender = leftHandSide ? this.lowerMiddleBack : this.lowerBack;
                        modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                        break block8;
                    }
                    case 5: 
                    case 6: {
                        modelPartToRender = leftHandSide ? this.ribLeftTopMiddle : this.ribRightTopMiddle;
                        modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                        break block8;
                    }
                    case 7: 
                    case 8: {
                        modelPartToRender = leftHandSide ? this.leftArmUpper : this.rightArmUpper;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
                        break block8;
                    }
                    case 9: 
                    case 10: {
                        modelPartToRender = leftHandSide ? this.leftLegUpperMiddle : this.rightLegUpperMiddle;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftLegID : rightLegID));
                        break block8;
                    }
                }
                modelPartToRender = null;
                break;
            }
            case "spiritual": {
                switch (slotIndex) {
                    case 1: 
                    case 2: {
                        modelPartToRender = leftHandSide ? this.ribLeftBottom : this.ribRightBottom;
                        modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                        break block8;
                    }
                    case 3: 
                    case 4: {
                        modelPartToRender = leftHandSide ? this.leftShoulderSide : this.rightShoulderSide;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
                        break block8;
                    }
                }
                modelPartToRender = null;
                break;
            }
            case "temporal": {
                switch (slotIndex) {
                    case 1: 
                    case 2: {
                        modelPartToRender = leftHandSide ? this.ribLeftBottomMiddle : this.ribRightBottomMiddle;
                        modelPartToRender.m_104315_(this.root.m_171324_(bodyID));
                        break block8;
                    }
                    case 3: 
                    case 4: {
                        modelPartToRender = leftHandSide ? this.leftShoulderBack : this.rightShoulderBack;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
                        break block8;
                    }
                    case 5: 
                    case 6: {
                        modelPartToRender = leftHandSide ? this.leftArmUpperBack : this.rightArmUpperBack;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
                        break block8;
                    }
                    case 7: 
                    case 8: {
                        modelPartToRender = leftHandSide ? this.leftArmMiddle : this.rightArmMiddle;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftLegID : rightLegID));
                        break block8;
                    }
                    case 9: 
                    case 10: {
                        modelPartToRender = leftHandSide ? this.leftHand : this.rightHand;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
                        break block8;
                    }
                    case 11: 
                    case 12: {
                        modelPartToRender = leftHandSide ? this.leftLegLowerMiddle : this.rightLegLowerMiddle;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftLegID : rightLegID));
                        break block8;
                    }
                    case 13: 
                    case 14: {
                        modelPartToRender = leftHandSide ? this.leftArmLower : this.rightArmLower;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftArmID : rightArmID));
                        break block8;
                    }
                    case 15: 
                    case 16: {
                        modelPartToRender = leftHandSide ? this.leftLegLower : this.rightLegLower;
                        modelPartToRender.m_104315_(this.root.m_171324_(leftHandSide ? leftLegID : rightLegID));
                        break block8;
                    }
                }
                modelPartToRender = null;
            }
        }
        if (modelPartToRender == null) {
            return;
        }
        IHasMetalType item = (IHasMetalType)stack.m_41720_();
        Color color = item.getMetalType().getColor();
        VertexConsumer vertexBuilder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)this.m_103119_(TEXTURE), (boolean)false, (boolean)false);
        modelPartToRender.m_104306_(matrixStack, vertexBuilder, light, OverlayTexture.f_118083_, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
    }
}

