/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.hemalurgy.common.capabilities.world;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import leaf.cosmere.hemalurgy.common.capabilities.world.IHemalurgyWorldCap;
import leaf.cosmere.hemalurgy.common.capabilities.world.KolossPatrolSpawner;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class HemalurgyWorldCapability
implements IHemalurgyWorldCap {
    public static final Capability<IHemalurgyWorldCap> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IHemalurgyWorldCap>(){});
    private final Level level;
    private CompoundTag m_nbt = null;
    private final List<CustomSpawner> customSpawners;

    public HemalurgyWorldCapability(Level level) {
        this.level = level;
        this.customSpawners = ImmutableList.of((Object)new KolossPatrolSpawner());
    }

    @Nonnull
    public static LazyOptional<IHemalurgyWorldCap> get(Level level) {
        return level != null ? level.getCapability(CAPABILITY, null) : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        if (this.m_nbt == null) {
            this.m_nbt = new CompoundTag();
        }
        return this.m_nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.m_nbt = nbt;
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer server = serverLevel.m_7654_();
            for (CustomSpawner customSpawner : this.customSpawners) {
                customSpawner.m_7995_(serverLevel, server.m_7004_(), server.m_6998_());
            }
        }
    }
}

