/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.hemalurgy.common.eventHandlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import leaf.cosmere.api.Constants;
import leaf.cosmere.hemalurgy.common.capabilities.world.HemalurgyWorldCapability;
import leaf.cosmere.hemalurgy.common.capabilities.world.IHemalurgyWorldCap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hemalurgy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HemalurgyCapabilitiesHandler {
    @SubscribeEvent
    public static void attachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        final Level level = (Level)event.getObject();
        ResourceLocation location = ((Level)event.getObject()).m_46472_().m_135782_();
        if (location.toString().contains("overworld")) {
            event.addCapability(Constants.Resources.HEMALURGY_WORLD_CAP, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final HemalurgyWorldCapability worldCapability;
                final LazyOptional<IHemalurgyWorldCap> worldCapInstance;
                {
                    this.worldCapability = new HemalurgyWorldCapability(level);
                    this.worldCapInstance = LazyOptional.of(() -> this.worldCapability);
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return cap == HemalurgyWorldCapability.CAPABILITY ? this.worldCapInstance : LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return this.worldCapability.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    this.worldCapability.deserializeNBT(nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            MinecraftServer server = level.m_7654_();
            if (server != null && server.m_6846_().m_11309_() == 0) {
                return;
            }
            HemalurgyWorldCapability.get(level).ifPresent(IHemalurgyWorldCap::tick);
        }
    }
}

