/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.hemalurgy.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.items.ChargeableMetalCurioItem;
import leaf.cosmere.common.registry.CosmereDamageTypesRegistry;
import leaf.cosmere.hemalurgy.common.config.HemalurgyConfigs;
import leaf.cosmere.hemalurgy.common.items.IHemalurgicInfo;
import leaf.cosmere.hemalurgy.common.registries.HemalurgyAttributes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="hemalurgy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HemalurgicSpikeItem
extends ChargeableMetalCurioItem
implements IHemalurgicInfo {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public HemalurgicSpikeItem(Metals.MetalType metalType) {
        super(metalType);
        float attackDamage = 3.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean canUnequip(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity livingEntity;
        boolean hasBindingCurse = EnchantmentHelper.m_44920_((ItemStack)stack);
        return !hasBindingCurse || (livingEntity = context.entity()) instanceof Player && (player = (Player)livingEntity).m_7500_();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap attributeModifiers = LinkedHashMultimap.create();
        Metals.MetalType metalType = this.getMetalType();
        Item item = stack.m_41720_();
        if (item instanceof IHemalurgicInfo) {
            IHemalurgicInfo hemalurgicInfo = (IHemalurgicInfo)item;
            hemalurgicInfo.getHemalurgicAttributes((Multimap<Attribute, AttributeModifier>)attributeModifiers, stack, metalType);
            UUID hemalurgicIdentity = this.getHemalurgicIdentity(stack);
            if (hemalurgicIdentity != null) {
                int spiritwebIntegrity = -1;
                if (slotContext.identifier().equals("linchpin")) {
                    Manifestation fGold;
                    spiritwebIntegrity += 3;
                    Manifestation aPewter = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("allomancy", Metals.MetalType.PEWTER.m_6082_()));
                    if (aPewter != null && attributeModifiers.containsKey((Object)aPewter.getAttribute())) {
                        spiritwebIntegrity += ((Integer)HemalurgyConfigs.SERVER.ALLOMANTIC_PEWTER_SPIRITWEB_BONUS.get()).intValue();
                    }
                    if ((fGold = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("feruchemy", Metals.MetalType.GOLD.m_6082_()))) != null && attributeModifiers.containsKey((Object)fGold.getAttribute())) {
                        spiritwebIntegrity += ((Integer)HemalurgyConfigs.SERVER.FERUCHEMICAL_GOLD_SPIRITWEB_BONUS.get()).intValue();
                    }
                }
                attributeModifiers.put((Object)HemalurgyAttributes.SPIRITWEB_INTEGRITY.getAttribute(), (Object)new AttributeModifier(hemalurgicIdentity, "Spiritweb Integrity", (double)spiritwebIntegrity, AttributeModifier.Operation.ADDITION));
            }
        }
        return attributeModifiers;
    }

    public float getMaxChargeModifier() {
        return 0.055555556f;
    }

    public void addFilled(CreativeModeTab.Output output) {
        super.addFilled(output);
        if (this.getMetalType().hasFeruchemicalEffect()) {
            if (this.getMetalType() == Metals.MetalType.IRON) {
                ItemStack filledIronSpike = new ItemStack((ItemLike)this);
                double strengthToAdd = 10.5;
                this.Invest(filledIronSpike, this.getMetalType(), strengthToAdd, UUID.randomUUID());
                output.m_246342_(filledIronSpike);
            } else if (this.getMetalType() == Metals.MetalType.TIN) {
                filledSpike = new ItemStack((ItemLike)this);
                this.Invest(filledSpike, this.getMetalType(), 0.25, UUID.randomUUID());
                output.m_246342_(filledSpike);
            } else if (this.getMetalType() == Metals.MetalType.COPPER) {
                filledSpike = new ItemStack((ItemLike)this);
                this.Invest(filledSpike, this.getMetalType(), 0.5, UUID.randomUUID());
                output.m_246342_(filledSpike);
            }
            Collection hemalurgyStealWhitelist = this.getMetalType().getHemalurgyStealWhitelist();
            if (hemalurgyStealWhitelist != null) {
                block6: for (Metals.MetalType stealType : hemalurgyStealWhitelist) {
                    if (!stealType.hasAssociatedManifestation()) continue;
                    try {
                        switch (this.getMetalType()) {
                            case STEEL: 
                            case BRONZE: 
                            case CADMIUM: 
                            case ELECTRUM: {
                                ItemStack allomancySpike = new ItemStack((ItemLike)this);
                                Manifestation allomancyMani = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("allomancy", stealType.m_6082_()));
                                if (allomancyMani == null) continue block6;
                                this.Invest(allomancySpike, allomancyMani, 7.0, UUID.randomUUID());
                                output.m_246342_(allomancySpike);
                                break;
                            }
                            case PEWTER: 
                            case BRASS: 
                            case BENDALLOY: 
                            case GOLD: {
                                ItemStack feruchemySpike = new ItemStack((ItemLike)this);
                                Manifestation feruchemyMani = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("feruchemy", stealType.m_6082_()));
                                if (feruchemyMani == null) break;
                                this.Invest(feruchemySpike, feruchemyMani, 7.0, UUID.randomUUID());
                                output.m_246342_(feruchemySpike);
                            }
                        }
                    }
                    catch (Exception e) {
                        CosmereAPI.logger.info(String.format("remove %s from whitelist for %s spikes", stealType, this.getMetalType()));
                    }
                }
            }
        }
        if (this.getMetalType() == Metals.MetalType.LERASATIUM) {
            ItemStack bound = new ItemStack((ItemLike)this);
            UUID identity = UUID.randomUUID();
            for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
                if (manifestation.getManifestationType() == Manifestations.ManifestationTypes.SURGEBINDING) continue;
                this.Invest(bound, manifestation, 5.0, identity);
            }
            output.m_246342_(bound);
        }
    }

    private void addDecay(ItemStack stack) {
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        this.addDecay(stack);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.getHemalurgicIdentity(stack) == null) {
            return;
        }
        this.addInvestitureInformation(stack, tooltip);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            SpiritwebCapability.get((LivingEntity)playerEntity).ifPresent(iSpiritweb -> {
                ItemStack itemstack = playerEntity.m_21205_();
                Item patt11113$temp = itemstack.m_41720_();
                if (patt11113$temp instanceof HemalurgicSpikeItem) {
                    HemalurgicSpikeItem spikeItem = (HemalurgicSpikeItem)patt11113$temp;
                    spikeItem.killedEntity(itemstack, playerEntity, event.getEntity());
                }
            });
        }
    }

    public void killedEntity(ItemStack stack, Player playerEntity, LivingEntity entityKilled) {
        if (!this.matchHemalurgicIdentity(stack, entityKilled.m_20148_())) {
            return;
        }
        this.stealFromSpiritweb(stack, this.getMetalType(), playerEntity, entityKilled);
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return super.m_5812_(stack) || this.hemalurgicIdentityExists(stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        switch (equipmentSlot) {
            case MAINHAND: 
            case OFFHAND: {
                return this.attributeModifiers;
            }
        }
        return super.getAttributeModifiers(equipmentSlot, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            UUID stackWeWantToEquipUUID = this.getHemalurgicIdentity(stack);
            HemalurgicSpikeItem item = (HemalurgicSpikeItem)stack.m_41720_();
            Metals.MetalType stackMetal = item.getMetalType();
            if (stackWeWantToEquipUUID != null) {
                Predicate<ItemStack> spikePredicate = stackToFind -> {
                    boolean isSpike = stackToFind.m_41720_() instanceof HemalurgicSpikeItem;
                    if (!isSpike) {
                        return false;
                    }
                    HemalurgicSpikeItem foundSpikeItem = (HemalurgicSpikeItem)stackToFind.m_41720_();
                    UUID foundSpikeUUID = this.getHemalurgicIdentity((ItemStack)stackToFind);
                    boolean matchingSpikeIdentity = foundSpikeItem.getMetalType() == this.getMetalType() && foundSpikeUUID != null && foundSpikeUUID.compareTo(stackWeWantToEquipUUID) == 0;
                    Metals.MetalType testStackMetal = foundSpikeItem.getMetalType();
                    boolean onlyOneIronAllowed = stackMetal == Metals.MetalType.IRON && stackMetal == testStackMetal;
                    return matchingSpikeIdentity || onlyOneIronAllowed;
                };
                LazyOptional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
                if (!curiosInventory.isPresent()) {
                    return false;
                }
                ICuriosItemHandler curiosInv = (ICuriosItemHandler)curiosInventory.resolve().get();
                return curiosInv.findFirstCurio(spikePredicate).isEmpty();
            }
        }
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        boolean isEquipping;
        boolean bl = isEquipping = prevStack == null || stack.m_41720_() != prevStack.m_41720_();
        if (isEquipping) {
            slotContext.entity().m_6469_(CosmereDamageTypesRegistry.SPIKED.source(slotContext.entity().m_9236_()), 4.0f);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        boolean isUnequipping;
        super.onUnequip(slotContext, newStack, stack);
        boolean bl = isUnequipping = newStack.m_41619_() || !newStack.m_150930_(stack.m_41720_());
        if (isUnequipping) {
            slotContext.entity().m_6469_(CosmereDamageTypesRegistry.SPIKED.source(slotContext.entity().m_9236_()), 4.0f);
        }
    }
}

