/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.hemalurgy.common.items;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import leaf.cosmere.api.Constants;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.api.helpers.StackNBTHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.hemalurgy.common.config.HemalurgyConfigs;
import leaf.cosmere.hemalurgy.common.items.HemalurgicSpikeItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;

public interface IHemalurgicInfo {
    public static final String stolen_identity_tag = "stolen_identity_tag";
    public static final List<Metals.MetalType> whiteList = new ArrayList<Metals.MetalType>(4);

    default public boolean matchHemalurgicIdentity(ItemStack stack, UUID uniqueID) {
        if (!this.hemalurgicIdentityExists(stack)) {
            return true;
        }
        return StackNBTHelper.getUuid((ItemStack)stack, (String)stolen_identity_tag).compareTo(uniqueID) == 0;
    }

    default public boolean hemalurgicIdentityExists(ItemStack stack) {
        return StackNBTHelper.verifyExistance((ItemStack)stack, (String)stolen_identity_tag);
    }

    default public void setHemalurgicIdentity(ItemStack stack, UUID uniqueID) {
        StackNBTHelper.setUuid((ItemStack)stack, (String)stolen_identity_tag, (UUID)uniqueID);
    }

    default public UUID getHemalurgicIdentity(ItemStack stack) {
        return StackNBTHelper.getUuid((ItemStack)stack, (String)stolen_identity_tag);
    }

    default public CompoundTag getHemalurgicInfo(ItemStack stack) {
        return stack.m_41698_("hemalurgy");
    }

    default public void stealFromSpiritweb(ItemStack stack, Metals.MetalType spikeMetalType, Player playerEntity, LivingEntity entityKilled) {
        boolean isPlayerEntity = entityKilled instanceof Player;
        if (this.getAttributes(stack, spikeMetalType, playerEntity, entityKilled)) {
            return;
        }
        ArrayList manifestationsFound = new ArrayList();
        SpiritwebCapability.get((LivingEntity)entityKilled).ifPresent(entityKilledSpiritWeb -> {
            manifestationsFound.addAll(entityKilledSpiritWeb.getAvailableManifestations(true));
            if (!manifestationsFound.isEmpty()) {
                whiteList.clear();
                Collection hemalurgyStealWhitelist = spikeMetalType.getHemalurgyStealWhitelist();
                if (hemalurgyStealWhitelist != null) {
                    whiteList.addAll(hemalurgyStealWhitelist);
                }
                switch (spikeMetalType) {
                    case STEEL: 
                    case BRONZE: 
                    case CADMIUM: 
                    case ELECTRUM: {
                        Manifestation manifestation = this.getRandomMetalPowerFromList(manifestationsFound, whiteList, Manifestations.ManifestationTypes.ALLOMANCY);
                        if (manifestation == null) break;
                        this.Invest(stack, manifestation, manifestation.getStrength(entityKilledSpiritWeb, true) * (double)0.7f, entityKilled.m_20148_());
                        entityKilledSpiritWeb.removeManifestation(manifestation);
                        return;
                    }
                    case PEWTER: 
                    case BRASS: 
                    case BENDALLOY: 
                    case GOLD: {
                        Manifestation manifestation = this.getRandomMetalPowerFromList(manifestationsFound, whiteList, Manifestations.ManifestationTypes.FERUCHEMY);
                        if (manifestation == null) break;
                        this.Invest(stack, manifestation, manifestation.getStrength(entityKilledSpiritWeb, true) * (double)0.7f, entityKilled.m_20148_());
                        entityKilledSpiritWeb.removeManifestation(manifestation);
                        return;
                    }
                    case ATIUM: {
                        Manifestation manifestation;
                        Manifestation atiumAllomancy = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("allomancy", Metals.MetalType.ATIUM.m_6082_()));
                        Manifestation atiumFeruchemy = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("feruchemy", Metals.MetalType.ATIUM.m_6082_()));
                        if (manifestationsFound.contains(atiumFeruchemy)) {
                            manifestation = atiumFeruchemy;
                        } else if (manifestationsFound.contains(atiumAllomancy)) {
                            manifestation = atiumAllomancy;
                        } else {
                            Collections.shuffle(manifestationsFound);
                            manifestation = (Manifestation)manifestationsFound.get(0);
                        }
                        if (manifestation == null) break;
                        this.Invest(stack, manifestation, manifestation.getStrength(entityKilledSpiritWeb, true) * (double)0.7f, entityKilled.m_20148_());
                        entityKilledSpiritWeb.removeManifestation(manifestation);
                        return;
                    }
                    case LERASATIUM: {
                        for (Manifestation manifestation : manifestationsFound) {
                            this.Invest(stack, manifestation, manifestation.getStrength(entityKilledSpiritWeb, true) * 0.5, entityKilled.m_20148_());
                            entityKilledSpiritWeb.removeManifestation(manifestation);
                        }
                        break;
                    }
                }
            }
        });
    }

    private boolean getAttributes(ItemStack stack, Metals.MetalType spikeMetalType, Player playerEntity, LivingEntity entityKilled) {
        switch (spikeMetalType) {
            case LERASIUM: {
                for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
                    switch (metalType) {
                        case IRON: 
                        case TIN: 
                        case COPPER: 
                        case ZINC: 
                        case ALUMINUM: 
                        case DURALUMIN: 
                        case CHROMIUM: 
                        case NICROSIL: {
                            this.getAttributes(stack, metalType, playerEntity, entityKilled);
                        }
                    }
                }
                return true;
            }
            case IRON: 
            case TIN: 
            case COPPER: 
            case ZINC: 
            case ALUMINUM: 
            case DURALUMIN: 
            case CHROMIUM: 
            case NICROSIL: {
                double strengthCurrent = this.getHemalurgicStrength(stack, spikeMetalType);
                double entityAbilityStrength = spikeMetalType.getEntityAbilityStrength(entityKilled, playerEntity);
                double strengthToAdd = strengthCurrent + entityAbilityStrength;
                if (strengthToAdd > 0.01 || strengthToAdd < -0.01) {
                    this.Invest(stack, spikeMetalType, strengthToAdd, entityKilled.m_20148_());
                }
                return true;
            }
        }
        return false;
    }

    default public Manifestation getRandomMetalPowerFromList(List<Manifestation> manifestationsFound, List<Metals.MetalType> whiteList, Manifestations.ManifestationTypes powerType) {
        Collections.shuffle(whiteList);
        for (Metals.MetalType typeToTrySteal : whiteList) {
            int i = manifestationsFound.indexOf(powerType.getManifestation(typeToTrySteal.getID()));
            if (i < 0) continue;
            return manifestationsFound.get(i);
        }
        return null;
    }

    default public Multimap<Attribute, AttributeModifier> getHemalurgicAttributes(Multimap<Attribute, AttributeModifier> attributeModifiers, ItemStack stack, Metals.MetalType metalType) {
        UUID hemalurgicIdentity = this.getHemalurgicIdentity(stack);
        if (metalType == Metals.MetalType.ALUMINUM) {
            for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
                Attribute attribute = manifestation.getAttribute();
                if (attribute == null) continue;
                attributeModifiers.put((Object)attribute, (Object)new AttributeModifier(Constants.NBT.ALUMINUM_UUID, manifestation.getTranslationKey(), -100.0, AttributeModifier.Operation.ADDITION));
            }
            return attributeModifiers;
        }
        if (hemalurgicIdentity == null) {
            return attributeModifiers;
        }
        double strength = this.getHemalurgicStrength(stack, metalType);
        Attribute attribute = null;
        AttributeModifier.Operation attributeModifier = AttributeModifier.Operation.ADDITION;
        switch (metalType) {
            case IRON: {
                attribute = Attributes.f_22281_;
                Attribute xpGainRate = AttributesRegistry.XP_RATE_ATTRIBUTE.getAttribute();
                attributeModifiers.put((Object)xpGainRate, (Object)new AttributeModifier(hemalurgicIdentity, "Kolossification", -0.15, AttributeModifier.Operation.ADDITION));
                break;
            }
            case TIN: {
                attribute = AttributesRegistry.NIGHT_VISION_ATTRIBUTE.getAttribute();
                break;
            }
            case COPPER: {
                attribute = AttributesRegistry.XP_RATE_ATTRIBUTE.getAttribute();
                break;
            }
            case CHROMIUM: {
                attribute = Attributes.f_22286_;
                break;
            }
        }
        if (attribute != null) {
            attributeModifiers.put((Object)attribute, (Object)new AttributeModifier(hemalurgicIdentity, "Hemalurgic " + metalType.m_6082_(), strength, attributeModifier));
        }
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            Attribute regAttribute;
            String path = manifestation.getName();
            double hemalurgicStrength = this.getHemalurgicStrength(stack, manifestation);
            if (!(hemalurgicStrength > 0.0) || (regAttribute = manifestation.getAttribute()) == null) continue;
            attributeModifiers.put((Object)regAttribute, (Object)new AttributeModifier(hemalurgicIdentity, String.format("Hemalurgic-%s: %s", path, hemalurgicIdentity.toString()), hemalurgicStrength, AttributeModifier.Operation.ADDITION));
        }
        return attributeModifiers;
    }

    default public double getHemalurgicStrength(ItemStack stack, Metals.MetalType metalType) {
        return this.getHemalurgicStrength(stack, metalType.m_6082_());
    }

    default public double getHemalurgicStrength(ItemStack stack, Manifestation manifestation) {
        return this.getHemalurgicStrength(stack, manifestation.getRegistryName().toString());
    }

    default public double getHemalurgicStrength(ItemStack stack, String name) {
        double strength = CompoundNBTHelper.getDouble((CompoundTag)this.getHemalurgicInfo(stack), (String)name, (double)0.0);
        HemalurgicSpikeItem spikeItem = (HemalurgicSpikeItem)stack.m_41720_();
        switch (spikeItem.getMetalType()) {
            case IRON: 
            case TIN: 
            case COPPER: 
            case ZINC: 
            case NICROSIL: {
                break;
            }
            case LERASATIUM: {
                int max = (Integer)HemalurgyConfigs.SERVER.LERASATIUM_MAX_SPIKE_STRENGTH.get();
                strength = Math.min((double)max, strength);
                break;
            }
            case CHROMIUM: {
                int max = (Integer)HemalurgyConfigs.SERVER.CHROMIUM_MAX_SPIKE_STRENGTH.get();
                strength = Math.min((double)max, strength);
                break;
            }
            default: {
                int max = (Integer)HemalurgyConfigs.SERVER.DEFAULT_POWER_MAX_SPIKE_STRENGTH.get();
                strength = Math.min((double)max, strength);
            }
        }
        return strength;
    }

    default public void setHemalurgicStrength(ItemStack stack, String name, double val) {
        CompoundNBTHelper.setDouble((CompoundTag)this.getHemalurgicInfo(stack), (String)name, (double)val);
    }

    default public void addInvestitureInformation(ItemStack stack, List<Component> tooltip) {
        if (!this.hemalurgicIdentityExists(stack)) {
            return;
        }
        tooltip.add((Component)TextHelper.createTranslatedText((String)"tooltip.cosmere.power.found", (Object[])new Object[0]));
        block6: for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            switch (metalType) {
                case IRON: 
                case TIN: 
                case COPPER: 
                case ZINC: 
                case ALUMINUM: 
                case DURALUMIN: 
                case CHROMIUM: 
                case NICROSIL: {
                    if (!this.hasHemalurgicPower(stack, metalType)) continue block6;
                    double hemalurgicStrength = this.getHemalurgicStrength(stack, metalType);
                    switch (metalType) {
                        case IRON: 
                        case CHROMIUM: {
                            break;
                        }
                        default: {
                            hemalurgicStrength *= 100.0;
                        }
                    }
                    double roundOff = (double)Math.round(hemalurgicStrength * 100.0) / 100.0;
                    String sign = roundOff > 0.0 ? "+" : "";
                    tooltip.add((Component)TextHelper.createTranslatedText((String)("tooltip.cosmere.attribute." + metalType.m_6082_()), (Object[])new Object[]{sign, roundOff}));
                }
            }
        }
        IForgeRegistry manifestations = CosmereAPI.manifestationRegistry();
        for (Manifestation manifestation : manifestations) {
            if (!this.hasHemalurgicPower(stack, manifestation)) continue;
            tooltip.add(manifestation.getTextComponent());
        }
    }

    default public boolean hasHemalurgicPower(ItemStack stack, Manifestation manifestation) {
        return this.getHemalurgicStrength(stack, manifestation) > 0.0;
    }

    default public boolean hasHemalurgicPower(ItemStack stack, Metals.MetalType metalType) {
        double hemalurgicStrength = this.getHemalurgicStrength(stack, metalType);
        double marginOfError = 0.01;
        return hemalurgicStrength > 0.01 || hemalurgicStrength < -0.01;
    }

    default public void Invest(ItemStack stack, Manifestation manifestation, double level, UUID identity) {
        this.Invest(stack, manifestation.getRegistryName().toString(), level, identity);
    }

    default public void Invest(ItemStack stack, Metals.MetalType metalType, double level, UUID identity) {
        this.Invest(stack, metalType.m_6082_(), level, identity);
    }

    default public void Invest(ItemStack stack, String manifestation, double level, UUID identity) {
        this.setHemalurgicStrength(stack, manifestation, level);
        this.setHemalurgicIdentity(stack, identity);
    }

    default public void Divest(ItemStack stack) {
        StackNBTHelper.removeEntry((ItemStack)stack, (String)"hemalurgy");
        StackNBTHelper.removeEntry((ItemStack)stack, (String)stolen_identity_tag);
    }
}

