#version 120

#include "/settings.glsl"

uniform sampler2D texture;

varying vec2 texcoord;
varying vec4 glcolor;

#if CAVE_LIGHT_LEAK_FIX_SKY == 1
	uniform ivec2 eyeBrightnessSmooth;
	uniform ivec2 eyeBrightness;
	uniform vec3 cameraPosition;
#endif

uniform float nightVision;
uniform float blindness;
uniform float darknessFactor;
uniform float viewHeight;
uniform float viewWidth;

void main() {
	vec4 color = texture2D(texture, texcoord) * glcolor;
	
	#if NIGHT_VISION_MODE == 1
		//Gamma based when no composite
			//uniform float nightVision;
		#if BORDERS == 0 && GODRAYS == 0 && CLOUDS == 0
			color.rgb = pow(color.rgb,vec3(1.-.5*nightVision));
		#endif
	#endif
	
	#if NIGHT_VISION_MODE == 2
		//Thermal Vision
		if(nightVision>0.)
		{
			float nv_effect = 1.-pow(min(1.,distance(gl_FragCoord.xy,vec2(viewWidth,viewHeight)*.5)/(.5*viewWidth)),3.);
			float heat=color.b+color.r*.5+color.g*.2;
			vec3 heat_vis =
				 heat < .25 ? mix(vec3(0.,0.,0.),vec3(0.,0.,1.), heat*4.)
				:heat < .5 ? mix(vec3(0.,0.,1.),vec3(0.,1.,0.), (heat-.25)*4.)
			:heat < .75 ? mix(vec3(0.,1.,0.),vec3(1.,1.,0.), (heat-.5)*4.)
			:heat < 1. ? mix(vec3(1.,1.,0.),vec3(1.,0.,0.), (heat-.75)*4.)
			: mix(vec3(1.,0.,0.),vec3(1.), (heat-1.)*4.)
;
			color.rgb  = mix(color.rgb,heat_vis, max(nightVision,nv_effect));
		}
	#endif

	#if CAVE_LIGHT_LEAK_FIX_SKY == 1
		//uniform ivec2 eyeBrightnessSmooth;
		//uniform ivec2 eyeBrightness;
		float cave_light_leak = mix(float(max(eyeBrightnessSmooth.y,eyeBrightness.y))/240.,1.,clamp(CAVE_DARKNESS_DEPTH +cameraPosition.y-SEA_LEVEL,0.,10.)*.1);
		
		color*=cave_light_leak;
	#endif
	
	
	
/* DRAWBUFFERS:0 */
	gl_FragData[0] = color; //gcolor
}