vec3 seed1 = vec3(gl_FragCoord.xy,10.);//viewPos.xyz;
vec3 seed2 = vec3(gl_FragCoord.yx,20.);//viewPos.xyz;


#define AO_WIDTH .1
#define AO_SAMPLES 10.
#define AO_EXTRA_SOFTNESS .01

float ao = 1.;

		float total_weight = 1.;
		for(float i = 1.;i<= AO_SAMPLES ;i++)
		{
			float samplling_width = (i/AO_SAMPLES)*pow(abs(sdist),1.0)*256.* AO_WIDTH;
			
			float r = i*.5;
			
			vec2 spiral=vec2(sin(r),cos(r)) * max(samplling_width,SHADOW_EXTRA_SOFTNESS);
			vec3 noise_blur = noise3from3_ver2(vec3(spiral,i))-.5;

			spiral=spiral*(1.+SHADOW_NOISE_STR*noise_blur.xy) 
			* (mix(1.,noise_blur.z*3.0,SHADOW_NOISE_VARIATION ));
			
			#if FLIP_SHADOW_SPIRAL_RANDOMLY == 1
				spiral *= vec2(sign(random(i)-.5) , sign(random(i+5.)-.5)  );
			#endif
			#if FLIP_SHADOW_SPIRAL_RANDOMLY == 2
				spiral *= vec2(sign(hashfrom3(seed1)-.5) , sign(hashfrom3(seed2)-.5)  );
			#endif
				
			float ao_wide = texture2DLod(colortex1,texcoord,i).x;

			float oc = ao_dist - ao_wide;
			oc=oc>.5?oc-(oc-.5):oc;
			//oc=ao_dist<5.?oc*(1.+2.*(1.-ao_dist/5.)) : oc/(ao_dist-5.);
			oc/=ao_dist*.25;
			ao-=max(0.,oc)*pow(1.-i/ao_steps,1.);

			float weight = mix(1.,1.-i/(AO_SAMPLES+1.),SHADOW_SOFTNESS_WEIGHT);
			total_weight+=weight;
				
				;
		}
		
		ao=clamp( pow(clamp(ao/(total_weight),0.,1.),SHADOW_WEIGHT_EXPONENT) ,0.,1.);
	#endif