/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.commands;

import com.shweit.expendablebackpacks.gui.BackpackGuideGUI;
import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import com.shweit.expendablebackpacks.storage.BackpackManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BackpackCommand
implements CommandExecutor,
TabCompleter {
    private final BackpackManager backpackManager;

    public BackpackCommand(BackpackManager backpackManager) {
        this.backpackManager = backpackManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subcommand;
        if (args.length == 0) {
            this.showGuide(sender);
            return true;
        }
        switch (subcommand = args[0].toLowerCase()) {
            case "give": {
                return this.handleGive(sender, args);
            }
            case "open": {
                return this.handleOpen(sender, args);
            }
            case "clear": {
                return this.handleClear(sender, args);
            }
            case "clone": {
                return this.handleClone(sender, args);
            }
            case "help": 
            case "?": {
                this.showGuide(sender);
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown subcommand. Use /backpack help");
        return true;
    }

    private void showGuide(CommandSender sender) {
        if (sender instanceof Player) {
            BackpackGuideGUI.openMainGuide((Player)sender);
            return;
        }
        sender.sendMessage("\u00a76\u00a7l=== Backpack Plugin Guide ===");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lBackpack Tiers:");
        for (BackpackTier tier : BackpackTier.values()) {
            sender.sendMessage("  " + tier.getDisplayName() + " \u00a77- " + tier.getRows() + " rows (" + tier.getSlots() + " slots)");
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lCrafting:");
        sender.sendMessage("  \u00a77Leather Backpack: \u00a7fLeather + String + Chest");
        sender.sendMessage("  \u00a77  Pattern: L S L / L C L / L L L");
        sender.sendMessage("  \u00a77Dirt Backpack: \u00a7fSurround Leather BP with Dirt");
        sender.sendMessage("  \u00a77Enderpack: \u00a7fEnder Eyes + Pearls + Chest + Iron Block");
        sender.sendMessage("  \u00a77  Pattern: E P E / P C P / E I E");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lUpgrades:");
        sender.sendMessage("  \u00a77Surround backpack with 8x upgrade material");
        sender.sendMessage("  \u00a77Leather \u2192 Copper: \u00a76Copper Ingots");
        sender.sendMessage("  \u00a77Copper \u2192 Iron: \u00a7fIron Ingots");
        sender.sendMessage("  \u00a77Iron \u2192 Gold: \u00a7eGold Ingots");
        sender.sendMessage("  \u00a77Gold \u2192 Diamond: \u00a7bDiamonds");
        sender.sendMessage("  \u00a77Diamond \u2192 Netherite: \u00a78Smithing Table");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lEnderpack Cloning:");
        sender.sendMessage("  \u00a77Place 1 Enderpack + 1 Ender Pearl in crafting");
        sender.sendMessage("  \u00a77Get 2 Enderpacks with \u00a75shared storage");
        sender.sendMessage("");
        sender.sendMessage("\u00a77Right-click any backpack to open it!");
    }

    private boolean handleGive(CommandSender sender, String[] args) {
        if (!sender.hasPermission("backpack.give")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /backpack give <player> <tier>");
            sender.sendMessage("\u00a7cTiers: dirt, leather, copper, iron, gold, diamond, netherite, enderpack");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found: " + args[1]);
            return true;
        }
        BackpackTier tier = BackpackTier.fromName(args[2]);
        if (tier == null) {
            sender.sendMessage("\u00a7cInvalid tier: " + args[2]);
            sender.sendMessage("\u00a7cAvailable: dirt, leather, copper, iron, gold, diamond, netherite, enderpack");
            return true;
        }
        ItemStack backpack = BackpackItem.createBackpack(tier);
        target.getInventory().addItem(new ItemStack[]{backpack});
        sender.sendMessage("\u00a7aGave " + tier.getDisplayName() + " \u00a7ato " + target.getName());
        target.sendMessage("\u00a7aYou received a " + tier.getDisplayName());
        return true;
    }

    private boolean handleOpen(CommandSender sender, String[] args) {
        UUID backpackUUID;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return true;
        }
        if (!sender.hasPermission("backpack.openOthers")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /backpack open <uuid>");
            return true;
        }
        try {
            backpackUUID = UUID.fromString(args[1]);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cInvalid UUID format.");
            return true;
        }
        if (!this.backpackManager.backpackExists(backpackUUID)) {
            sender.sendMessage("\u00a7cNo backpack found with that UUID.");
            return true;
        }
        Player player = (Player)sender;
        Inventory inventory = this.backpackManager.getInventory(backpackUUID, "\u00a77Backpack", 27);
        player.openInventory(inventory);
        player.sendMessage("\u00a7aOpened backpack: \u00a77" + backpackUUID.toString().substring(0, 8) + "...");
        return true;
    }

    private boolean handleClear(CommandSender sender, String[] args) {
        UUID backpackUUID;
        if (!sender.hasPermission("backpack.clear")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /backpack clear <uuid>");
            return true;
        }
        try {
            backpackUUID = UUID.fromString(args[1]);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cInvalid UUID format.");
            return true;
        }
        this.backpackManager.clearInventory(backpackUUID);
        sender.sendMessage("\u00a7aCleared backpack: \u00a77" + backpackUUID.toString().substring(0, 8) + "...");
        return true;
    }

    private boolean handleClone(CommandSender sender, String[] args) {
        UUID backpackUUID;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return true;
        }
        if (!sender.hasPermission("backpack.clone")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /backpack clone <uuid>");
            sender.sendMessage("\u00a7cNote: Only Enderpacks can be cloned.");
            return true;
        }
        try {
            backpackUUID = UUID.fromString(args[1]);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cInvalid UUID format.");
            return true;
        }
        Player player = (Player)sender;
        ItemStack enderpack = BackpackItem.createBackpack(BackpackTier.ENDERPACK, backpackUUID);
        player.getInventory().addItem(new ItemStack[]{enderpack});
        player.sendMessage("\u00a75Cloned Enderpack with ID: \u00a77" + backpackUUID.toString().substring(0, 8) + "...");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subcommand;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("give", "open", "clear", "clone", "help"));
        } else if (args.length == 2) {
            String subcommand2;
            switch (subcommand2 = args[0].toLowerCase()) {
                case "give": {
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                }
                case "open": 
                case "clear": 
                case "clone": {
                    return this.getBackpackUUIDCompletions();
                }
            }
        } else if (args.length == 3 && (subcommand = args[0].toLowerCase()).equals("give")) {
            return Arrays.stream(BackpackTier.values()).map(tier -> tier.name().toLowerCase()).collect(Collectors.toList());
        }
        return completions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }

    private List<String> getBackpackUUIDCompletions() {
        return this.backpackManager.getAllBackpackUUIDs().stream().map(UUID::toString).collect(Collectors.toList());
    }
}

