/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.gui;

import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BackpackGuideGUI
implements Listener {
    private static final String MAIN_TITLE = "\u00a76\u00a7lBackpack Guide";
    private static final String DETAIL_TITLE_PREFIX = "\u00a76\u00a7l";

    public static void openMainGuide(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MAIN_TITLE);
        ItemStack title = BackpackGuideGUI.createGuideItem(Material.CHEST, "\u00a76\u00a7lBackpack Plugin Guide", "\u00a77Click on any backpack to see", "\u00a77crafting recipes and features!");
        gui.setItem(4, title);
        int[] slots = new int[]{19, 20, 21, 22, 23, 24, 25, 28};
        BackpackTier[] tiers = BackpackTier.values();
        for (int i = 0; i < tiers.length && i < slots.length; ++i) {
            BackpackTier tier = tiers[i];
            ItemStack backpack = BackpackItem.createBackpack(tier);
            ItemMeta meta = backpack.getItemMeta();
            ArrayList<String> lore = meta.getLore();
            lore = lore == null ? new ArrayList<String>() : new ArrayList(lore);
            lore.add("");
            lore.add("\u00a7e\u00a7l\u25b6 Click for details!");
            meta.setLore(lore);
            if (!backpack.setItemMeta(meta)) {
                backpack = BackpackItem.createBackpack(tier);
            }
            gui.setItem(slots[i], backpack);
        }
        ItemStack craftingInfo = BackpackGuideGUI.createGuideItem(Material.CRAFTING_TABLE, "\u00a7e\u00a7lCrafting Info", "\u00a77Most backpacks are upgraded by", "\u00a77surrounding them with 8x material", "", "\u00a77Netherite uses Smithing Table", "\u00a77Enderpack has special recipes");
        gui.setItem(45, craftingInfo);
        ItemStack enderpackInfo = BackpackGuideGUI.createGuideItem(Material.ENDER_PEARL, "\u00a75\u00a7lEnderpack Special", "\u00a77All Enderpacks with the same ID", "\u00a77share the same inventory!", "", "\u00a77Clone: 1 Enderpack + 1 Pearl = 2 Packs", "\u00a77(Both share the same storage)");
        gui.setItem(49, enderpackInfo);
        ItemStack upgradeInfo = BackpackGuideGUI.createGuideItem(Material.DIAMOND, "\u00a7b\u00a7lUpgrade Path", "\u00a77Leather \u2192 \u00a76Copper \u2192 \u00a7fIron", "\u00a77\u2192 \u00a7eGold \u2192 \u00a7bDiamond \u2192 \u00a78Netherite", "", "\u00a77Also: Leather \u2192 \u00a77Dirt (downgrade)", "\u00a77Upgrades preserve your items!");
        gui.setItem(53, upgradeInfo);
        player.openInventory(gui);
    }

    public static void openTierDetail(Player player, BackpackTier tier) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(DETAIL_TITLE_PREFIX + tier.getDisplayName()));
        ItemStack backpack = BackpackItem.createBackpack(tier);
        gui.setItem(4, backpack);
        ItemStack features = BackpackGuideGUI.createGuideItem(Material.BOOK, "\u00a7e\u00a7lFeatures", "\u00a77Size: \u00a7f" + tier.getRows() + " rows (" + tier.getSlots() + " slots)", tier.isEnderpack() ? "\u00a75\u00a7lShared Storage" : "\u00a77Unique inventory per backpack", "", tier.isEnderpack() ? "\u00a77All Enderpacks with same ID" : "\u00a77Right-click to open", tier.isEnderpack() ? "\u00a77share the same storage" : "\u00a77Items saved automatically");
        gui.setItem(20, features);
        BackpackGuideGUI.addCraftingRecipe(gui, tier);
        BackpackGuideGUI.addUpgradeInfo(gui, tier);
        ItemStack back = BackpackGuideGUI.createGuideItem(Material.ARROW, "\u00a7e\u00a7l\u2190 Back to Guide", "\u00a77Return to main guide");
        gui.setItem(45, back);
        player.openInventory(gui);
    }

    private static void addCraftingRecipe(Inventory gui, BackpackTier tier) {
        switch (tier) {
            default: {
                break;
            }
            case LEATHER: {
                gui.setItem(10, new ItemStack(Material.LEATHER));
                gui.setItem(11, new ItemStack(Material.STRING));
                gui.setItem(12, new ItemStack(Material.LEATHER));
                gui.setItem(19, new ItemStack(Material.LEATHER));
                gui.setItem(20, new ItemStack(Material.CHEST));
                gui.setItem(21, new ItemStack(Material.LEATHER));
                gui.setItem(28, new ItemStack(Material.LEATHER));
                gui.setItem(29, new ItemStack(Material.LEATHER));
                gui.setItem(30, new ItemStack(Material.LEATHER));
                ItemStack leatherInfo = BackpackGuideGUI.createGuideItem(Material.CRAFTING_TABLE, "\u00a7e\u00a7lCrafting Recipe", "\u00a77Place in Crafting Table:", "\u00a77Pattern: L S L", "\u00a77         L C L", "\u00a77         L L L", "\u00a77(L=Leather, S=String, C=Chest)");
                gui.setItem(24, leatherInfo);
                break;
            }
            case DIRT: {
                Material[] dirt = new Material[]{Material.DIRT, Material.DIRT, Material.DIRT, Material.DIRT, null, Material.DIRT, Material.DIRT, Material.DIRT, Material.DIRT};
                int[] dirtSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
                for (int i = 0; i < dirtSlots.length; ++i) {
                    if (dirt[i] != null) {
                        gui.setItem(dirtSlots[i], new ItemStack(dirt[i]));
                        continue;
                    }
                    gui.setItem(dirtSlots[i], BackpackItem.createBackpack(BackpackTier.LEATHER));
                }
                ItemStack dirtInfo = BackpackGuideGUI.createGuideItem(Material.CRAFTING_TABLE, "\u00a7e\u00a7lCrafting Recipe", "\u00a77Surround Leather Backpack", "\u00a77with 8x Dirt", "", "\u00a77This is a downgrade from Leather", "\u00a77(smaller storage)");
                gui.setItem(24, dirtInfo);
                break;
            }
            case COPPER: 
            case IRON: 
            case GOLD: 
            case DIAMOND: {
                BackpackTier previous = BackpackTier.fromLevel(tier.getLevel() - 1);
                Material upgradeMat = tier.getUpgradeMaterial();
                Material[] pattern = new Material[]{upgradeMat, upgradeMat, upgradeMat, upgradeMat, null, upgradeMat, upgradeMat, upgradeMat, upgradeMat};
                int[] patternSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
                for (int i = 0; i < patternSlots.length; ++i) {
                    if (pattern[i] != null) {
                        gui.setItem(patternSlots[i], new ItemStack(pattern[i]));
                        continue;
                    }
                    gui.setItem(patternSlots[i], BackpackItem.createBackpack(previous));
                }
                ItemStack upgradeInfo = BackpackGuideGUI.createGuideItem(Material.CRAFTING_TABLE, "\u00a7e\u00a7lUpgrade Recipe", "\u00a77Surround " + previous.getDisplayName(), "\u00a77with 8x " + BackpackGuideGUI.getDisplayName(upgradeMat), "", "\u00a77Your items are preserved!", "\u00a77UUID stays the same");
                gui.setItem(24, upgradeInfo);
                break;
            }
            case NETHERITE: {
                gui.setItem(11, new ItemStack(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE));
                gui.setItem(20, BackpackItem.createBackpack(BackpackTier.DIAMOND));
                gui.setItem(29, new ItemStack(Material.NETHERITE_INGOT));
                ItemStack netheriteInfo = BackpackGuideGUI.createGuideItem(Material.SMITHING_TABLE, "\u00a7e\u00a7lSmithing Table Recipe", "\u00a77Template: \u00a78Netherite Upgrade", "\u00a77Base: \u00a7bDiamond Backpack", "\u00a77Material: \u00a78Netherite Ingot", "", "\u00a77Use Smithing Table to upgrade", "\u00a77Your items are preserved!");
                gui.setItem(24, netheriteInfo);
                break;
            }
            case ENDERPACK: {
                gui.setItem(10, new ItemStack(Material.ENDER_EYE));
                gui.setItem(11, new ItemStack(Material.ENDER_PEARL));
                gui.setItem(12, new ItemStack(Material.ENDER_EYE));
                gui.setItem(19, new ItemStack(Material.ENDER_PEARL));
                gui.setItem(20, new ItemStack(Material.CHEST));
                gui.setItem(21, new ItemStack(Material.ENDER_PEARL));
                gui.setItem(28, new ItemStack(Material.ENDER_EYE));
                gui.setItem(29, new ItemStack(Material.IRON_BLOCK));
                gui.setItem(30, new ItemStack(Material.ENDER_EYE));
                ItemStack enderInfo = BackpackGuideGUI.createGuideItem(Material.CRAFTING_TABLE, "\u00a7e\u00a7lCrafting Recipe", "\u00a77Pattern: E P E", "\u00a77         P C P", "\u00a77         E I E", "\u00a77(E=Ender Eye, P=Pearl,", "\u00a77 C=Chest, I=Iron Block)");
                gui.setItem(24, enderInfo);
                gui.setItem(14, BackpackItem.createBackpack(BackpackTier.ENDERPACK));
                gui.setItem(15, new ItemStack(Material.ENDER_PEARL));
                ItemStack cloneResult = BackpackItem.createBackpack(BackpackTier.ENDERPACK);
                cloneResult.setAmount(2);
                gui.setItem(17, cloneResult);
                ItemStack cloneInfo = BackpackGuideGUI.createGuideItem(Material.ENDER_PEARL, "\u00a75\u00a7lCloning Recipe", "\u00a771 Enderpack + 1 Ender Pearl", "\u00a77= 2 Enderpacks (same ID!)", "", "\u00a75Both share the same storage", "\u00a77Great for multiple access points!");
                gui.setItem(25, cloneInfo);
            }
        }
    }

    private static void addUpgradeInfo(Inventory gui, BackpackTier tier) {
        BackpackTier next;
        BackpackTier previous;
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a7e\u00a7lUpgrade Path");
        lore.add("");
        if (tier.getLevel() > 0 && (previous = BackpackTier.fromLevel(tier.getLevel() - 1)) != null && previous != BackpackTier.DIRT) {
            lore.add("\u00a77Upgraded from: " + previous.getDisplayName());
        }
        if ((next = BackpackTier.fromLevel(tier.getLevel() + 1)) != null && tier != BackpackTier.ENDERPACK) {
            lore.add("\u00a77Upgrades to: " + next.getDisplayName());
            lore.add("\u00a77Material: \u00a7f" + BackpackGuideGUI.getDisplayName(next.getUpgradeMaterial()));
        } else if (tier == BackpackTier.NETHERITE) {
            lore.add("\u00a77This is the max tier!");
        } else if (tier == BackpackTier.ENDERPACK) {
            lore.add("\u00a75Enderpack is special!");
            lore.add("\u00a77Cannot be upgraded");
        }
        ItemStack upgradeInfo = BackpackGuideGUI.createGuideItem(Material.EXPERIENCE_BOTTLE, lore.toArray(new String[0]));
        gui.setItem(32, upgradeInfo);
    }

    private static ItemStack createGuideItem(Material material, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (lore.length > 0) {
            meta.setDisplayName(lore[0]);
            if (lore.length > 1) {
                ArrayList<String> loreList = new ArrayList<String>();
                for (int i = 1; i < lore.length; ++i) {
                    loreList.add(lore[i]);
                }
                meta.setLore(loreList);
            }
        }
        if (!item.setItemMeta(meta)) {
            return item;
        }
        return item;
    }

    private static String getDisplayName(Material material) {
        String name = material.name().replace("_", " ").toLowerCase();
        String[] words = name.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return result.toString();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        if (!title.equals(MAIN_TITLE) && !title.startsWith(DETAIL_TITLE_PREFIX)) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (title.equals(MAIN_TITLE)) {
            BackpackTier tier;
            if (BackpackItem.isBackpack(clicked) && (tier = BackpackItem.getBackpackTier(clicked)) != null) {
                BackpackGuideGUI.openTierDetail(player, tier);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        } else if (title.startsWith(DETAIL_TITLE_PREFIX) && clicked.getType() == Material.ARROW) {
            BackpackGuideGUI.openMainGuide(player);
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }
}

