/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.expendablebackpacks.recipes;

import com.shweit.expendablebackpacks.items.BackpackItem;
import com.shweit.expendablebackpacks.items.BackpackTier;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.plugin.Plugin;

public class BackpackRecipes {
    private final Plugin plugin;

    public BackpackRecipes(Plugin plugin) {
        this.plugin = plugin;
    }

    public void registerAll() {
        this.registerDirtBackpack();
        this.registerLeatherBackpack();
        this.registerCopperUpgrade();
        this.registerIronUpgrade();
        this.registerGoldUpgrade();
        this.registerDiamondUpgrade();
        this.registerEnderpack();
        this.registerEnderpackClone();
        this.registerNetheriteUpgrade();
    }

    private void registerLeatherBackpack() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.LEATHER);
        NamespacedKey key = new NamespacedKey(this.plugin, "leather_backpack");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"LSL", "LCL", "LLL"});
        recipe.setIngredient('L', Material.LEATHER);
        recipe.setIngredient('S', Material.STRING);
        recipe.setIngredient('C', Material.CHEST);
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerDirtBackpack() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.DIRT);
        NamespacedKey key = new NamespacedKey(this.plugin, "dirt_backpack");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"DDD", "DBD", "DDD"});
        recipe.setIngredient('D', Material.DIRT);
        recipe.setIngredient('B', (RecipeChoice)new RecipeChoice.ExactChoice(BackpackItem.createBackpack(BackpackTier.LEATHER)));
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerEnderpack() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.ENDERPACK);
        NamespacedKey key = new NamespacedKey(this.plugin, "enderpack");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"EPE", "PCP", "EIE"});
        recipe.setIngredient('E', Material.ENDER_EYE);
        recipe.setIngredient('P', Material.ENDER_PEARL);
        recipe.setIngredient('C', Material.CHEST);
        recipe.setIngredient('I', Material.IRON_BLOCK);
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerEnderpackClone() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.ENDERPACK);
        result.setAmount(2);
        NamespacedKey key = new NamespacedKey(this.plugin, "enderpack_clone");
        ShapelessRecipe recipe = new ShapelessRecipe(key, result);
        recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(BackpackItem.createBackpack(BackpackTier.ENDERPACK)));
        recipe.addIngredient(Material.ENDER_PEARL);
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerCopperUpgrade() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.COPPER);
        NamespacedKey key = new NamespacedKey(this.plugin, "copper_upgrade");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"CCC", "CBC", "CCC"});
        recipe.setIngredient('C', Material.COPPER_INGOT);
        recipe.setIngredient('B', (RecipeChoice)new RecipeChoice.ExactChoice(BackpackItem.createBackpack(BackpackTier.LEATHER)));
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerIronUpgrade() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.IRON);
        NamespacedKey key = new NamespacedKey(this.plugin, "iron_upgrade");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"III", "IBI", "III"});
        recipe.setIngredient('I', Material.IRON_INGOT);
        recipe.setIngredient('B', (RecipeChoice)new RecipeChoice.ExactChoice(BackpackItem.createBackpack(BackpackTier.COPPER)));
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerGoldUpgrade() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.GOLD);
        NamespacedKey key = new NamespacedKey(this.plugin, "gold_upgrade");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"GGG", "GBG", "GGG"});
        recipe.setIngredient('G', Material.GOLD_INGOT);
        recipe.setIngredient('B', (RecipeChoice)new RecipeChoice.ExactChoice(BackpackItem.createBackpack(BackpackTier.IRON)));
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerDiamondUpgrade() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.DIAMOND);
        NamespacedKey key = new NamespacedKey(this.plugin, "diamond_upgrade");
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"DDD", "DBD", "DDD"});
        recipe.setIngredient('D', Material.DIAMOND);
        recipe.setIngredient('B', (RecipeChoice)new RecipeChoice.ExactChoice(BackpackItem.createBackpack(BackpackTier.GOLD)));
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerNetheriteUpgrade() {
        ItemStack result = BackpackItem.createBackpack(BackpackTier.NETHERITE);
        NamespacedKey key = new NamespacedKey(this.plugin, "netherite_upgrade");
        SmithingTransformRecipe recipe = new SmithingTransformRecipe(key, result, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (RecipeChoice)new RecipeChoice.ExactChoice(BackpackItem.createBackpack(BackpackTier.DIAMOND)), (RecipeChoice)new RecipeChoice.MaterialChoice(Material.NETHERITE_INGOT));
        Bukkit.addRecipe((Recipe)recipe);
    }
}

